self.oninstall = () => {
};

importScripts('/assets/js/scripts/common.js');

chrome.tabs.onActivated.addListener(function (activeInfo) {
    setTimeout(() => {

        var tab = chrome.tabs.get(activeInfo.tabId, async function(tab) {

            if (chrome.runtime.lastError) {
                console.log(chrome.runtime.lastError.message);
            }

            if (typeof tab == "undefined") return;

            if (tab.url.includes('chrome://')) {
                chrome.action.setIcon ({
                    path: {
                        "19": "assets/icons/imageinfo-16-mono.png",
                        "38": "assets/icons/imageinfo-32-mono.png"
                    }
                });
                return;
            }

            if (MAFunc.isAliPage(tab.url)) {

                if (MAFunc.isAliCatPage(tab.url)) {
                    chrome.action.setPopup ({ "popup": "popups/category.html" });
                } else {
                    chrome.action.setPopup ({ "popup": "popups/default.html" });
                }

                await MAWorker.updateRequestRules(
                    MAFunc.getOriginFromUrl(tab.url)
                );

                chrome.action.setIcon ({
                    path: {
                        "19": "assets/icons/imageinfo-16.png",
                        "38": "assets/icons/imageinfo-32.png"
                    }
                });

                return;
            } else {


            }
        });
    }, 500);
});

chrome.tabs.onUpdated.addListener(async function (tabId, changeInfo, tab) {
    if (tab.active) {
        // code below only for active tab
        if (changeInfo.url && changeInfo.url.includes('chrome://')) {
            chrome.action.setIcon ({
                path: {
                    "19": "assets/icons/imageinfo-16-mono.png",
                    "38": "assets/icons/imageinfo-32-mono.png"
                }
            });
            return;
        }

        if (MAFunc.isAliPage(tab.url)) {

            if (MAFunc.isAliCatPage(tab.url)) {
                chrome.action.setPopup ({ "popup": "popups/category.html" });
            } else {
                chrome.action.setPopup ({ "popup": "popups/default.html" });
            }

            await MAWorker.updateRequestRules(
                MAFunc.getOriginFromUrl(tab.url)
            );

            chrome.action.setIcon ({
                path: {
                    "19": "assets/icons/imageinfo-16.png",
                    "38": "assets/icons/imageinfo-32.png"
                }
            });

            return;
        } else {
        }
    }

});

chrome.runtime.onMessage.addListener(function(t, e, a) {

    chrome.action.setBadgeText({ text: "" });

    if (config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED == t.action) {
        var ext_options;

        var checkProductsImported = async function(ids) {
            var n = { id: ids.join() };
            try
            {     
                const httpClient = new HttpClient( { baseURL: ext_options.api_key } );
                const data = await httpClient.postForm( config.api.checkProductsImported, n );

                var p = {
                    "name": config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                    "products": data.products,
                    "status": 'OK',
                };
                chrome.tabs.sendMessage(e.tab.id, p);

    
            } catch ( err )
            {  
                if ( err.code == "503" )
                {
                    checkProductsImported( ids );
                } else
                {
                    var p = {
                        "name": config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                        "status": "error",
                        "status_text": "We can't check whether a product imported to your store. The error occuring " + err.message
                    }
                    chrome.tabs.sendMessage(e.tab.id, p);    
                }
            }            
            
        }

        config.get_ext_options(function(data) {
            ext_options = data;

            if (ext_options.api_key) {
                checkProductsImported(t.ids);
            } else {
                var p = {
                    "name": config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                    "status": "error",
                    "status_text": "Can`t find Active store"
                }
                chrome.tabs.sendMessage(e.tab.id, p);
            }


        })

    }

    if (config.actions.CONTENT_CLEAR_ORDER_DATA == t.action) {
        chrome.storage.sync.set({

            orderId: !1,
            orderItems: !1,
            orderNumber: !1,
            shopName: !1,
            currentProduct: 0,
            orderData: !1,
            defaultShipping: config.defaultShippingSettings.shippingOption,
            note: !1,
            cartLoaded: !1,
            formFilled: 0,
            countrySet: 0,
            createdAt: !1

        }, function() {

        });
    }

    if (config.actions.CONTENT_ORDER_FULFILLMENT_QUEUE == t.action) {

        var orderData = t.data;

        config.get_ext_options(function(data) {
            ext_options = data;

            if (ext_options.api_key !== false) {



                chrome.storage.sync.get({
                    orderData: !1,
                    currentProduct: 0,
                    orderNumber: !1,
                    aliTab: !1,
                    createdAt: 0,
                }, function (o) {
                    
                    const isEmptyObj = function(obj) {
                        return typeof obj === 'undefined'
                            ||  (obj && Object.keys(obj).length === 0
                            && Object.getPrototypeOf(obj) === Object.prototype);
                    }

                    const start_fulfillmment = function() {
                        openOrCreateTab(o.aliTab.id, config.urls.aliexpressLink).then(function(tab) {
                            initDataStorage(orderData, function() {
                                chrome.storage.sync.set({
                                    maTab: e.tab,
                                    aliTab: tab,
                                    cartEmpty: !1,
                                }, function() {
                                    orderFulfillment(tab)
                                });
                            });
                        });
                    }

                    //use data from storage if no data was sent. it means this is not a first product
                    if (typeof t.data == "undefined") orderData = JSON.parse(o.orderData);

                    if (typeof orderData.storeurl !== 'undefined' && !ext_options.api_key.includes(orderData.storeurl)) {
                        // please activate right store
                        chrome.storage.sync.set({ maTab: e.tab }, function() {
                            sendOrderFulfillmentStatus(2);
                        });
                    } else {
                        var isFreshStorage = MAOrder.isFreshStorage(o);

                        if (!isEmptyObj(t.data) || (o.currentProduct < 1 && isFreshStorage)) {
                            let currency = typeof orderData.currency != "undefined" ? orderData.currency : config.defaults.currency;
                            UpdateAliCurrency(currency).then(function() {
                                start_fulfillmment();
                            });

                        } else {

                            if (!isFreshStorage) {
                                //update plugin tab id to prevent error
                                chrome.storage.sync.set({
                                    maTab: e.tab,
                                }, function() {
                                    orderFulfillment(o.aliTab)
                                });


                            } else {
                                orderFulfillment(o.aliTab);
                            }

                        }


                    }
                });



            } else {
                chrome.storage.sync.set({ maTab: e.tab }, function() {
                    sendOrderFulfillmentStatus(1);
                });
            }
        });
    }

    if (config.actions.CONTENT_ORDER_FULFILLMENT_STATUS_RESPONSE == t.action) {

        sendOrderFulfillmentStatus(t.stage, t.param);
    }



    if (config.actions.CONTENT_ORDER_TRACKING_CODE_REQUEST == t.action) {

        var ali_order_id = t.data;

        MA_Background.get_aliexpress_tracking_data(ali_order_id)
            .then(function(o) {
                chrome.tabs.sendMessage(e.tab.id, {
                    source: "ma",
                    type: config.actions.CONTENT_ORDER_TRACKING_CODE_RESPONSE,
                    data: o
                });
            })
            .catch(function(e) {
                //todo: send the error back to the store
                console.log(e);
            })

    }

    if (config.actions.CONTENT_OPEN_PRICING_PAGE === t.action) {
        chrome.tabs.query({ active: true, currentWindow: true }, function(tabs) {
            if (tabs.length > 0) {
                chrome.tabs.update(tabs[0].id, {
                    url: "https://ali2woo.com/pricing/?utm_source=mass_import&utm_medium=extension&utm_campaign=alinext"
                });
            }
        });
    }

    if (config.actions.CONTENT_ORDER_FULFILLMENT_TO_CART == t.action) {
        toCart(e.tab);
    }

    if (config.actions.CONTENT_ORDER_FULFILLMENT_RESPONSE == t.action) {

        chrome.storage.sync.get({ maTab: !1, orderId: !1 }, function(o) {

            var ext_options;

            var GetOrderDetailsPage = function(id) {

                return fetch(config.urls.orderInfo.replace("{1}", id).replace("{2}", 1 + Math.floor(Math.random() * 16)), {
                    "credentials": "include",
                    "method": "GET",
                    "headers": {
                        "Accept": "*/*",
                        "Accept-Language": "en-US,en;q=0.5",
                    },
                }).then(function(e) {
                    return e.text()
                })

            }

            var findProductIdByOrder = function(e) {
                return new Promise(function(s, t) {
                    GetOrderDetailsPage(e)
                        .then(function(r) {
                            for (var o, n = /productId=(.*?)"/gim, a = []; o = n.exec(r);) o && 2 === o.length && a.push(o[1]);
                            if (a.length > 0) {
                                var i = "pending",
                                    c = "",
                                    d = "",
                                    _ = /<td class="order-price">(.*?)<\/td>/gims,
                                    u = /window.runparams.appealInfoParams = '\[(.*?)\]';/gim.exec(r);
                                if (u && 2 === u.length) i = JSON.parse(u[1])
                                    .orderStatus;
                                var p = _.exec(r);
                                p && 2 === p.length && (c = p[1].trim()), (p = (_ = /logisticsType="(.*?)"/gims)
                                    .exec(r)) && 2 === p.length && (d = p[1].trim()), s({
                                    orderId: e,
                                    orderStatus: i,
                                    orderTotal: c,
                                    tracking_logisticsType: d,
                                    matchProductIds: a
                                })
                            } else t(null)
                        })
                        .catch(function(e) {
                            t(e);
                        })
                })
            }

            var getUpdateOrderInAppPromise = function(d) {

                return new Promise(function(i, o) {
                    jQuery.ajax({
                        type: 'POST',
                        url: ext_options.api_key + config.api.orderSync,
                        dataType: 'json',
                        data: d,
                        xhrFields: {
                            withCredentials: !1
                        },
                        success: function(e) {
                            i(e)
                        },
                        error: function(e) {
                            o(e)
                        }
                    })
                });
            }

            var sendMatchedOrdersToApp = function(t, params) {
                //localOrderId, externalOrderIds - deprecated, they will be deleted
                var n = { id: params.localOrderId, external_id: params.externalOrderIds, match_orders: params.matchedOrders };

                getUpdateOrderInAppPromise(n)
                    .then(function(d) {
                        var p = { id: n.id, external_id: n.external_id, status: 'OK' };
                        t(p);
                    })
                    .catch(function(e) {

                        var v_status_text = e.data ? e.data.error : e.statusText,
                            p = { status: 'error', id: n.id, external_id: n.external_id, status_text: v_status_text };

                        console.log("Ali2Woo Chrome extension can`t update the Woocommerce Order"), t(p);
                    })
            }

            var startOperation = function(localOrderId, ordersData, t) {

                var nn = [];

                var externalOrderIds = ordersData.id;

                if (ordersData.matchedOrders.length > 0) {
                    //data comes from the new method
                    sendMatchedOrdersToApp(t, { matchedOrders: ordersData.matchedOrders, localOrderId, externalOrderIds });

                } else {
                    //data come from the old method
                    for (let a in externalOrderIds) {
                        let j = externalOrderIds[a];

                        nn.push(findProductIdByOrder(j));

                    }

                    Promise.all(nn).then(function(e) {
                        sendMatchedOrdersToApp(t, { matchedOrders: e, localOrderId, externalOrderIds });
                    });
                }
            }

            config.get_ext_options(function(data) {
                ext_options = data;
                startOperation(o.orderId, t, a);
            })

        });

        return true;
    }

    if (config.actions.CONTENT_GET_PRODUCT_HTML == t.action) {

        var p = { 'message': 'this method is not implemented' };
        console.log( p );

        chrome.action.setBadgeText({ text: "" });

        t(p);

        return true;

    }

    if (config.actions.CONTENT_DELETE_PRODUCT_FROM_APP == t.action) {

        var ext_options;

       /* var getDeleteProductFromAppPromise = function(e) {
            return (0, get_xhr_promise)({
                url: ext_options.api_key + config.api.productDelete,
                method: "POST",
                params: e,
                isForm: !0,
                isAjax: !0
            })
        }*/

        var DeleteProductFromApp = async function(i, t) {
            


            var n = { id: i };
     
            try
            {
                const httpClient = new HttpClient( { baseURL: ext_options.api_key } );
                const d = await httpClient.postForm( config.api.productDelete, n );

                var p = { id: n.id, status: 'OK' };
                t(p);
            } catch ( err )
            {
                t(err.message);  
            }
    

          /*  getDeleteProductFromAppPromise(n)
                .then(function(d) {
                    var p = { id: n.id, status: 'OK' };
                    t(p);
                })
                .catch(function(e) {
                    401 !== e.status && console.log("Product deleted" + n.id), t(e)
                })*/

        }

        config.get_ext_options(function(data) {
            ext_options = data;
            DeleteProductFromApp(t.id, a);
        })

        return true;
    }

    /*
    if (config.actions.CONTENT_TEST_CONNECTION == t.action) {
        const syncSettings = async function () {
            const httpClient = new HttpClient({baseURL: ext_options.api_key});
            return await httpClient.get(config.api.getSettings);
        };

        config.get_ext_options(function(data) {
            ext_options = data;
            debugger;
            try
            {
                syncSettings().then( (resp) =>
                {
                    chrome.storage.sync.set({
                        isPremium: resp['a2w_premium']
                    }, function () {
                        const p = {status: 'ok'};
                        a(p);
                    });
                } );

   
            } catch ( err )
            {
                const p = {status: 'error', error: err.message};
                a(p);
            }
        });

        return true;
    }*/

    if (config.actions.CONTENT_TEST_CONNECTION === t.action) {
        const syncSettings = async (extOptions) => {
            const httpClient = new HttpClient({ baseURL: extOptions.api_key });
            return await httpClient.get(config.api.getSettings);
        };

        config.get_ext_options(async (data) => {
            try {
                const resp = await syncSettings(data);

                const isPremium = Boolean(resp?.settings?.a2w_premium);

                chrome.storage.sync.set({ isPremium }, () => {
                    a({ status: 'ok' });
                });
            } catch (err) {
                a({ status: 'error', error: err?.message || String(err) });
            }
        });

        return true;
    }

    if (config.actions.CONTENT_SET_POPUP == t.action) {
        chrome.action.setPopup ({ popup: t.popup });
    }

    if (config.actions.SYNC_PRODUCT_LIST == t.action) {

        var ext_options;

        var getSyncProductListPromise = function(e) {

            return (0, get_xhr_promise)({
                url: ext_options.api_key + config.api.importList,
                method: "POST",
                params: e,
                isForm: !0,
                isAjax: !0
            })
        }

        var syncProductList = function(t) {


            getSyncProductListPromise()
                .then(function(d) {
                    var p = { products: d.data.products, status: 'OK', success: true };
                    t(p);
                }).catch(function(e) {
                    console.log("API: syncProductList error"), e.success = false, console.log(e), t(e)
                })


        }


        config.get_ext_options(function(data) {
            ext_options = data;
            syncProductList(a);
        })

        return true;
    }

    //+
    if (config.actions.CONTENT_PUSH_PRODUCT_TO_APP == t.action) {

        chrome.action.setBadgeBackgroundColor({ color: '#1ea8cf' });
        chrome.action.setBadgeText({ text: "SEND" });

        var ext_options;

        const pushProduct = async function(e, i, th, pmn, pmx, ttl, cur, apd, t) {

            let n = {
                    url: e,
                    id: i,
                    thumb: th,
                    price_min: pmn,
                    price_max: pmx,
                    title: ttl,
                    currency: cur,
                    apd: apd
                };

            try
            {
                const httpClient = new HttpClient( { baseURL: ext_options.api_key } );
                const data = await httpClient.postForm( config.api.productImport, n );

                if (data && data.status == 'ok') {

                    chrome.action.setBadgeText({ text: "" });

                    p = { url: n.url, id: n.id, status: 'OK' };
                    console.log(`Chrome extension imported product (id: ${n.id}) sucessfully`);
                } else {

                    chrome.action.setBadgeBackgroundColor({ color: '#fb0153' });
                    chrome.action.setBadgeText({ text: "ERROR" });

                    if (data && data.status && data.warning) {
                        p = { url: n.url, id: n.id, status: data.status, status_text: data.warning };
                    } else {
                        p = { url: n.url, id: n.id, status: 'error', status_text: `can't import product (id: ${n.id})` };
                    }

                }
                t(p);

            } catch ( err )
            {

                chrome.action.setBadgeBackgroundColor({ color: '#fb0153' });
                chrome.action.setBadgeText({ text: "ERROR" });

                if ( err.resultType && err.resultType === "timeout" )
                {
                    //todo: check above condition
                    console.log(`Chrome extension: product (id: ${n.id}) import timeout`);
                    setTimeout(function() {
                        pushProduct(n.url, n.id, n.thumb, n.price_min, n.price_max, n.title, n.currency, n.apd, t);
                    }, 3000);
                } else {

                    let p = {
                        url: n.url,
                        id: n.id,
                        th: n.thumb,
                        pmn: n.price_min,
                        pmx: n.price_max,
                        ttl: n.title,
                        cur: n.currency,
                        apd: apd,
                        status: 'error',
                        status_text: err.message
                    };

                    if (ext_options.api_key == !1) {
                        p.status_text = "Can`t find Active store";
                    }
                    console.log(`Chrome extension can't import product ${n.id}.`);
                    t(p);
                }
            }

        }

        config.get_ext_options(function(data) {
            ext_options = data;

            let cleanedUrl = t.url ? MAFunc.cleanAliUrl(t.url) : '';

            pushProduct(cleanedUrl, t.id, t.thumb, t.price_min,
                t.price_max, t.title, t.currency, t.apd, a);
        });

        return true;
    }

    if (config.actions.GET_AND_PUSH_PRODUCT_HTML_TO_APP == t.action) {

        chrome.action.setBadgeBackgroundColor({ color: '#1ea8cf' });
        chrome.action.setBadgeText({ text: "GET" });

        var ext_options;
        var getLoadProductHtmlPromise = function(e) {
            return (0, get_xhr_promise)({
                url: e.url,
                method: "GET"
            })

        }

        var getProductHtml = function(e, i, th, pmn, pmx, ttl, cur, t) {


            var r = this,
                n = {
                    url: e,
                    id: i,
                    thumb: th,
                    price_min: pmn,
                    price_max: pmx,
                    title: ttl,
                    currency: cur
                };


            getLoadProductHtmlPromise(n)
                .then(function(d) {

                    chrome.action.setBadgeBackgroundColor({ color: '#fb0153' });
                    chrome.action.setBadgeText({ text: "ERROR" });

                    var opts = ext_options /*config.defaultShippingSettings*/ ,
                        o = n.id;

                    shippingInfo.getByIds(opts, [o], function(e) {
                        var p = { url: n.url, id: n.id, html: d.responseText, shipdata: e.freight };

                        pushProductHtml(p.id, p.url, p.html, p.shipdata, t);
                    });


                })
                .catch(function(e) {

                    chrome.action.setBadgeBackgroundColor({ color: '#fb0153' });
                    chrome.action.setBadgeText({ text: "ERROR" });

                    var p = { url: n.url, id: n.id, status: e.status };
                    console.log("Ali2Woo Chrome extension can`t laod the Product html."), t(p);
                })


        }

        config.get_ext_options(function(data) {
            ext_options = data;
            getProductHtml(t.url, t.id, t.thumb, t.price_min,
                t.price_max, t.title, t.currency, a);
        })


        return true;
    }

    if (config.actions.CONTENT_OPEN_SETTING_TAB == t.action) {
        chrome.tabs.create({ 'url': "/options.html" })
    }

    if (config.actions.CONTENT_CLOSE_CHROME_TAB_REQUEST == t.action) {
        chrome.storage.sync.get({
            aliTab: !1
        }, function(o) {

            if (o.aliTab !== !1) {
                var i = o.aliTab.id;
                chrome.tabs.get(i, function() {
                    if (!chrome.runtime.lastError) {
                        chrome.tabs.remove(i, function() {});
                    }
                });
            }

        });
    }

    if (config.actions.CONTENT_SWITCH_TO_CHROME_TAB_REQUEST == t.action) {
        chrome.storage.sync.get({
            aliTab: !1
        }, function(o) {

            // Tab exists
            chrome.tabs.update(o.aliTab.id, {
                "active": true
            }, function(tab) {

            });

        });
    }

    if (config.actions.CONTENT_TEST_REQUEST == t.action) {

    }

    if (config.actions.CONTENT_UPDATE_TAB_URL == t.action) {
        chrome.storage.sync.get({
            aliTab: !1
        }, function(o) {
            chrome.tabs.query({ active: true, currentWindow: true }, function(tabs) {
                chrome.tabs.update(o.aliTab.id, { url: t.url });
            });
        });

    }

    if (config.actions.CONTENT_GET_COUNTRIES == t.action) {
        //todo: remove this
    }


    if (config.actions.CONTENT_ADD_PRODUCT_TO_CART == t.action) {
       //todo: remove this
    }

    if (config.actions.CONTENT_ADD_PRODUCT_TO_CART_V2 == t.action) {
        return function addProductToCart(e, r, n, o, ri, cc, i) {
            const s = new URLSearchParams;
            return s.append("callback", "_comet_request_2"),
                s.append("productId", e),
                s.append("quantity", n),
                s.append("_csrf_token_", o),
                s.append("country", cc),
                s.append("cartfrom", "main_detail"),
                s.append("skuId", ri),
                s.append("skuAttr", r),
                i && s.append("company", i), fetch(`${config.urls.v2AddToCart}?${s.toString()}`, {
                credentials: "include",
                method: "GET"
            })
        }(t.productId, t.skuAttr, t.qty, t.csrfToken, t.skuId, t.country, t.shippingMethod)
        .then((e => a(200 === e.status))), !0;
    }

    if (config.actions.CONTENT_SET_ADDRESS == t.action) {

        //todo: remove this

    }

    if (config.actions.CONTENT_SWITCH_TO_PLUGIN_TAB_REQUEST == t.action) {
        chrome.storage.sync.get({
            maTab: !1
        }, function(o) {

            // Tab exists
            chrome.tabs.update(o.maTab.id, {
                "active": true
            }, function(tab) {

            });

        });
    }

    if (config.actions.FETCH_PRODUCT_SHIPPING_METHODS_DATA == t.action) {
        return function fetchProductShippingMethods(e, r, n, o, i, s) {
            const c = new URLSearchParams;
            return c.append("productId", e), c.append("country", r), c.append("minPrice", n), c.append("maxPrice", o), c.append("tradeCurrency", i), c.append("userScene", "PC_DETAIL_SHIPPING_PANEL"), c.append("sellerAdminSeq", s), fetch(`${config.urls.v2GetShippingMethods}?${c.toString()}`, {
                credentials: "include",
                method: "GET"
            })
        }(t.productId, t.shippingCountry, t.minPrice, t.maxPrice, t.currency, t.sellerAdminSeq)
            .then((e => e.json()))
            .then((() => a())), !0;
    }

    if (config.actions.FETCH_CART_DATA == t.action) {
        //todo: remove this
    }

    if (config.actions.EMPTY_CART == t.action) {
        let apiCartUrl = MA_Background.normalizeApiUrl(config.urls.cart, t.isRuDomain);
            return function emptyCart(e, r) {
                    const n = {
                        action: "DELETE_ITEMS",
                        updates: e,
                        selected: "",
                        _csrf_token_: r
                    };
                    return fetch(apiCartUrl, {
                        headers: {
                            "Content-Type": "application/json; charset=UTF-8"
                        },
                        body: JSON.stringify(n),
                        credentials: "include",
                        method: "POST"
                    })
                }(t.items, t.csrfToken)
                .then(() => a()), !0;
    }

    if (config.actions.FETCH_CART_ITEMS == t.action) {
        return function fetchItemsData(e, r) {
            return fetch(config.urls.cartItems.replace("{1}", e).replace("{2}", r), {
                credentials: "include",
                method: "GET"
            })
        }(t.currentPage, t.uniqueId)
        .then(e => e.json())
        .then(e => a(e)), !0;
    }
});



chrome.runtime.onMessageExternal.addListener(function(t, e, r) {
    switch (t.action) {
        case "orders-placed":

            chrome.storage.sync.set({
                aliOrderIDs: t.orderIds,
            }, function() {

            });

            return !1;
        case "order-details":

            console.log('order-details');
            console.log(t.data);
            /*
                chrome.storage.sync.set({
                    aliOrderIDs: t.orderIds,
                }, function() {

                });*/
            return !1;
        default:
            console.log("External message action not defined", {
                action: t.action
            })
    }
    return !1
})


