jQuery(function ($) {
    
    const main = {
        productData: false,
        preInit: function() {

            var t = $("body");
            t.append(MAMessages.statusBar());
            main.initPage();

        },
        checkPageHeaders: function() {
            return new Promise(function(j, f) {
                chrome.storage.sync.get({ respStatus: 200 }, function(s) {
                    if (s.respStatus == 404) {
                        return f();
                    } else {
                        return j();
                    }
                });
            });
        },
        initPage: function() {

            document.body.classList.add("ma"), document.body.classList.add("ma-product");

            chrome.storage.sync.get({
                orderData: !1,
                currentProduct: 0,
                cartEmpty: !1,
            }, function (t) {

                var isOrderFulfillment = false;

                if (t.orderData !== !1) {
                    o = JSON.parse(t.orderData);
                    e1 = t.currentProduct;
                    n = o.products[e1];
                }

                isOrderFulfillment = (t.orderData !== false && typeof n !== "undefined");

                if (isOrderFulfillment) {
                    main.checkPageHeaders().then(function() {
                        if (t.cartEmpty !== !0) {
                            chrome.extension.sendMessage({ action: config.actions.CONTENT_ORDER_FULFILLMENT_TO_CART });
                        }
                        else {
                            main.processAddToCart(t);
                        }

                    }).catch(function(error) {
                        MAOrder.sendStatus({ 'stage': 21 }, function() {
                            MAFunc.goToPluginTab();
                        });

                        MAStatusBar.remove();
                        MAStatusBar.add("Can't add this product to the cart, try do that manually...");
                        console.log(error);
                    });


                } else {
                    main.maybeShowImportButton();
                }

            });
        },
        maybeShowImportButton: function (){
            main.productData = main.getProductData();
            var k = main.productData;

            chrome.runtime.onMessage.addListener( function ( t ){
                if ( t.name == config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED ){

                    if ( t.status == "OK" ){
                        var e = t.products;
                        for ( var i in e ){
                            if ( e[ i ].imported ) MAHtml.appendHtml( document, document.body, MAMessages.productImportedIcon() );
                            else main.addImportButton( k );
                        }
                    }
                }
            } );

            config.get_ext_options( function ( ext_options ){
                if ( ext_options.markImported ){
                    chrome.runtime.sendMessage( {
                        action: config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                        ids: [ k.id ]
                    } );
                } else {
                    main.addImportButton( k );
                }
            } );

        },
        addImportButton: function (k){
            MAHtml.appendHtml( document, document.body, MAMessages.productPushButton() );
            $( document.body ).on( "click", "#ma-push-button", function ( t )
            {
                t.preventDefault();

                var params = { 'id': k.id };
                var reqId = Math.random().toString();
                var data = { params, "reqId": reqId };


                MAProduct.requestProductInfo( data.params, data.reqId, function ( e )
                {

                    var responseData = { "status": e.status, "data": e.data, "error_msg": e.error_msg, "reqId": e.reqId };

                    MAProduct.pushProduct( k.url, k.id, k.thumb, k.price_min, k.price_max, k.title, k.currency, responseData.data ).catch( function ( error )
                    {
                        console.log( error );
                    } );

                } );


            } )
        },
        afterAddToCartSuccess: function (e1, n, originalId) {
            MAStatusBar.add("Product is added."),

            MAOrder.sendStatus({ 'stage': 53 }, function() {
                MAFunc.goToPluginTab();
            }, originalId),

            chrome.storage.sync.set({
                orderData: JSON.stringify(n)
            }, function() {


                if ((e1.currentProduct + 1) < n.products.length)
                    var act = config.actions.CONTENT_ORDER_FULFILLMENT_QUEUE
                else
                    var act = config.actions.CONTENT_ORDER_FULFILLMENT_TO_CART;

                main.markItemAsAdded(n, e1.currentProduct, function() {
                    chrome.extension.sendMessage({
                        action: act
                    })
                });

            });
        },
        afterAddToCartFailed: function () {
            console.log("Failed to add product to cart");
            MAStatusBar.remove(), MAStatusBar.add("Failed to add product to cart.");
        },
        getProductData: function() {
            var data = { id: false, url: false, thumb: false, price_min: false, price_max: false, title: false, currency: false };

            var formatPrice = function(e) {
                return e.replace(/[^0-9.,]\.*/g, '').replace(',', '.');
            }


            data.url = window.location.href;

            var tmp = data.url.match(/.+\/([0-9,_]+)\.html/mi);

            if (tmp) {
                var p = tmp[1],
                    s = p.split('_');
                if (s.length > 1) {
                    data.id = s[1];
                } else {
                    data.id = s[0];
                }
            }

            // var tmp = data.url.match(/aliexpress\.com\/item.*\/([0-9]+)\.html/);
            // data.id = tmp[1];

            i = document.querySelector("span.p-symbol");
            if (i == null) {
                i = document.querySelector('.currency');
            }

            data.currency = (i && i.innerText !== '') ? i.innerText : false;

            i = document.querySelector(".product-name");
            if (i == null) {
                i = document.querySelector(".product-title");
            }

            data.title = (i && i.innerText !== '') ? i.innerText : false;

            i = document.querySelector(".img-thumb-item img");
            if (i == null) {
                i = document.querySelector('.images-view-list img');
            }

            data.thumb = (i && i.src !== '') ? i.src : false;


            r = document.querySelector("span.p-price");
            if (r == null) {
                r = document.querySelector(".product-price-value");
            }

            if (r && "" !== r.innerText) {
                var p = r.innerText.split('-');
                if (p) {
                    data.price_min = (typeof p[0] !== 'undefined') ? formatPrice(p[0]) : false;
                    data.price_max = (typeof p[1] !== 'undefined') ? formatPrice(p[1]) : false;
                }
            }

            return data;


        },
        processAddToCart: function (e1) {

            function parseProductStatus(e) {
                for (const r of e.querySelectorAll("script")) {
                    const e = r.innerText.match(/"itemStatus":\s?(\d),/);
                    if (null !== e) return e[1]
                }
                return null
            }

            function processVariantIsnoLongerAvailable(orderData, currentProduct) {
                MAStatusBar.remove();
                MAStatusBar.add("Product variant is no longer available. Try to choose another product or add a similar product from another supplier manually...");
                main.allowManualMode(orderData, currentProduct);
            }

            var n = JSON.parse(e1.orderData);
            var e = n.products[e1.currentProduct];
            var os = e.originalId;
            var s = e.productId;
            var t = document.body;
            var r = $(location).attr("href");
            /*
            if (r.indexOf(s) < 0) {
                MAStatusBar.remove();
                MAStatusBar.add("It looks like the product url is changed. You need to decide to choose current product or add a similar product from another supplier manually...");
                main.allowManualMode(n, e1.currentProduct);
                return void 0;
            }*/

            if ("0" !== parseProductStatus(t)) {
                MAStatusBar.remove();
                MAStatusBar.add("Product is no longer available. Try to choose another one or add a similar product from another supplier manually...");
                main.allowManualMode(n, e1.currentProduct);
                return void 0;
            }

            MAStatusBar.add("Adding product to cart...");

            var productParser3 = MAProductParser3();
            var u = productParser3.getDataForRequest(t, e.sku);

            if (u !== null) {

                if (e.sku && e.sku.length > 0 && "" === u) {
                    processVariantIsnoLongerAvailable(n, e1.currentProduct);
                }
                else {
                    productParser3.sendAddToCartRequest(e, n, s, u, os, e1);
                }

            }
            else {
                var productParser2 = MAProductParser2();
                u = productParser2.getDataForRequest(t, e.sku);
                if (u !== null) {

                    if (e.sku && e.sku.length > 0 && "" === u) {
                        processVariantIsnoLongerAvailable(n, e1.currentProduct);
                    }
                    else {
                        //need to remake this method for V2
                        productParser2.sendAddToCartRequest(e, n, s, u, os, e1);
                    }

                }
                else {
                    MAStatusBar.remove();
                    MAStatusBar.add("Can't identify product template");
                    return;
                }
            }

        },
        markItemAsAdded: function(t, e, f) {
            t.products[e].inCart = !0;
            chrome.storage.sync.set({
                currentProduct: e + 1,
                orderData: JSON.stringify(t)
            }, function() {
                f();
            });
        },
        allowManualMode: function(t, e) {
            main.markItemAsAdded(t, e, function() {
                MAOrder.sendStatus({ 'stage': 21 });
                MAFunc.goToPluginTab();
            })
        },

    };

    function MAProductParser2() {
        console.log('MAProductParser2');

        return {
            parseCsrfToken: function(e) {
                for (const r of e.querySelectorAll("script")) {
                    const e = r.innerText.match(/csrfToken:\s?'(\w+)',/);
                    if (null !== e) return e[1]
                }
                return null
            },
            parseSellerAdminSeq: function(e) {
                for (const r of e.querySelectorAll("script")) {
                    const e = r.innerText.match(/sellerAdminSeq":\s*(\d+),/);
                    if (null !== e) return e[1]
                }
                return null
            },      
            getAvailableShippingMethods: function (e, r, n) {
                var productParser = this;
                const o = function parseSkuPrice(e) {
                    for (const r of e.querySelectorAll("script")) {
                        const e = r.innerText.match(/actSkuCalPrice":\s*"(\d+(?:\.\d+)?)"/);
                        if (null !== e) return e[1]
                    }
                    return null
                }(r);
                return new Promise((i => chrome.runtime.sendMessage({
                    action: config.actions.FETCH_PRODUCT_SHIPPING_METHODS_DATA,
                    productId: e,
                    shippingCountry: n.countryRegion,
                    minPrice: o,
                    maxPrice: o,
                    currency: "USD",
                    sellerAdminSeq: productParser.parseSellerAdminSeq(r)
                }, (e => i(e)))))
            },
            getDataForRequest: function(e, r){
                const n = function parseSkuPriceList(e) {
                    for (const r of e.querySelectorAll("script")) {
                        const e = r.innerText.match(/"skuPriceList":(\[{.*}]),"(?:title|warrantyDetailJson)"/);
                        if (null !== e) return JSON.parse(e[1])
                    }
                    return null
                }(e);
                if (!n) {
                    const n = function parseStockKeepingUnitProperties(e) {
                        for (const r of e.querySelectorAll("script")) {
                            const e = r.innerText.match(/"productSKUPropertyList":(\[{.*}]),"skuPriceList"/);
                            if (null !== e) return JSON.parse(e[1])
                        }
                        return null
                    }(e);
                    let o = "",
                        i = 0;
                    for (const e of r)
                        if (void 0 !== n[i]) {
                            const r = n[i];
                            for (const n of r.skuPropertyValues) n.propertyValueId.toString() !== e.toString() && n.propertyValueIdLong.toString() !== e.toString() || (o += `${r.skuPropertyId}:${n.propertyValueId}`, n.propertyValueDefinitionName ? o += `#${n.propertyValueDefinitionName};` : o += ";")
                        } return o = o.replace(/;\s*$/, ""), console.log("getSkuAttr fallback to parseStockKeepingUnitProperties method"), o
                } {
                    for (const e of n)
                        if (e.skuPropIds === r.join(",")) {
                            if ("object" == typeof e.skuVal && void 0 !== e.skuVal.inventory && 0 === e.skuVal.inventory) continue;
                            return {skuAttr: e.skuAttr, deliveryMethods: '', skuId: e.skuId}
                        } let e = r.slice()
                        .reverse();
                    for (const r of n)
                        if (r.skuPropIds === e.join(",")) return {skuAttr: r.skuAttr, deliveryMethods: '', skuId: r.skuId}
                }
                return ""
            },
            resolveShipping: function(e, r, n) {
                if (n && n.body && n.body.freightResult) {
                    const o = r.order.defaultShipping,
                        i = e.primaryShipping,
                        s = n.body.freightResult;
                    return i && s.find((e => e.serviceName === i)) ? i : o && s.find((e => e.serviceName === o)) ? o : s[0].serviceName
                }
                return null
            },
            sendAddToCartRequest: function (e, o, c, u, os, e1) {
                let r = document.body;
                let productParser = this;
               /* this.getAvailableShippingMethods(c, r, o).then((l => {*/
                var l = 1;
                   // const d = l ? productParser.resolveShipping(e, o, l) : null;
                   chrome.runtime.sendMessage({
                        action: config.actions.CONTENT_ADD_PRODUCT_TO_CART_V2,
                        productId: c,
                        skuAttr: u.skuAttr,
                        qty: e.qty,
                        csrfToken: productParser.parseCsrfToken(r),
                        skuId : u.skuId,
                        country: o.countryRegion,
                        shippingMethod: ''
                    }, (e => {
                        if (e) {
                            main.afterAddToCartSuccess(e1, o, os);
                        }
                        else {
                            main.afterAddToCartFailed();
                        }
                    }))
                /*}))*/
            }
        }
    }

    function MAProductParser3() {
        console.log('MAProductParser3');

        return {
            getDataForRequest: function(e, r) {
                //get skuAttr, skuId, available delivery methods
                var productParser = this;
                var result = function parseStockKeepingUnitProperties(e) {
                        for (const r of e.querySelectorAll("script")) {
                            const priceListData = r.innerText.match(/"skuInfo":{"propertyList":\[{.*}],"priceList":(\[{.*}]),"sizeData"/);
                     
                            if (null !== priceListData) {
                                const deliveryData = r.innerText.match(/"skuInfo":{.*},"delivery":(\{.*}),"quantity":/);
                                if (null !== deliveryData) {
                                    let priceList = JSON.parse(productParser.fixJsonString(priceListData[1]));
                                    let delivery = JSON.parse(productParser.fixJsonString(deliveryData[1]));
                                    return {priceList, delivery};        
                                }
                            }
                        }
                        return null
                }(e);

                if (result === null) {
                    return null;
                }
                
                const { priceList, delivery } = result;
         
           
                 {
                    for (const e of priceList)
                        if (e.skuPropIds === r.join(",")) {
                            if ("object" == typeof e.skuVal && void 0 !== e.skuVal.inventory && 0 === e.skuVal.inventory) continue;
                            return {skuAttr: e.skuAttr, deliveryMethods: delivery.methods, skuId: e.skuId}
                        }
                    
                    let e = r.slice().reverse();

                    for (const r of priceList)
                        if (r.skuPropIds === e.join(","))
                        return {skuAttr: r.skuAttr, deliveryMethods: delivery.methods, skuId: r.skuId}
                }
                return ""
            },
            fixJsonString: function(s) {
                // preserve newlines, etc - use valid JSON
                s = s.replace(/\\n/g, "\\n")  
                .replace(/\\'/g, "\\'")
                .replace(/\\"/g, '\\"')
                .replace(/\\&/g, "\\&")
                .replace(/\\r/g, "\\r")
                .replace(/\\t/g, "\\t")
                .replace(/\\b/g, "\\b")
                .replace(/\\f/g, "\\f");
                // remove non-printable and other non-valid JSON chars
                s = s.replace(/[\u0000-\u0019]+/g, ""); 
                
                return s;
            },
            sendAddToCartRequest: function(e, o, c, u, os, e1) {
                          
                const l = u.deliveryMethods;
                
                const d =  this.resolveShipping(e, o, l);
  
                chrome.runtime.sendMessage({
                    action: config.actions.CONTENT_ADD_PRODUCT_TO_CART,
                    productId: c,
                    skuAttr: u.skuAttr,
                    skuId: u.skuId,
                    qty: e.qty,
                    shippingMethod: d
                }, (e => {
                    if (e) {
                        main.afterAddToCartSuccess(e1, o, os);
                    }
                    else {
                        main.afterAddToCartFailed();
                    }
                }));

            },
            resolveShipping: function(e, r, n) {
                if (n && n.length > 0) {
                    const o = r.defaultShipping;
                    const i = e.shipping;
                    return i && n.find((e => e.serviceName === i)) ? i : o && n.find((e => e.serviceName === o)) ? o : n[0].serviceName
                }
                return null
            }
        }
    }


    main.preInit();
});