//need to inject ma_api because it should be available in the iframe too
if (!MAFunc.isScriptAlreadyIncluded("assets/js/scripts/ma_api.js")) {
    var s = document.createElement('script');
    s.id = "ali2woo-injected-script";
    s.setAttribute("data-runtime-id", chrome.runtime.id);
    s.src = chrome.runtime.getURL("assets/js/scripts/ma_api.js");
    document.documentElement.appendChild(s);
}

window.addEventListener("message", function(e) {
    if (e.data.from && e.data.subject && e.data.from === "a2w") {
        if ("updateMacthOrders" === e.data.subject) {

            var order_detail_blocks = e.data.order_detail.data;

            var matchOrder = {};

            chrome.storage.sync.get({
                stage: !1,
                matchOrders: [],
            }, function(params) {

                var saveMacthOrder = function() {
                    for (var prop in order_detail_blocks) {
                        if (Object.prototype.hasOwnProperty.call(order_detail_blocks, prop)) {

                            let block_data = order_detail_blocks[prop].fields;

                            if (prop.includes("detail_simple_order_info")) {

                                matchOrder['orderId'] = block_data.tradeOrderId;

                            } else if (prop.includes("detail_order_price")) {

                                matchOrder['orderTotal'] = block_data.totalPrice.value;

                            } else if (prop.includes("detail_product")) {

                                matchOrder['matchProductIds'] = [];

                                for (var i in block_data.productVOList) {
                                    matchOrder['matchProductIds'].push(block_data.productVOList[i].productId);
                                }

                            }
                        }
                    }

                    if (matchOrder && matchOrder['orderId']) {

                        chrome.storage.sync.get({
                            matchOrders: [],
                        }, function(params) {

                            if (!Array.isArray(params.matchOrders)) {
                                params.matchOrders = [];
                            }

                            params.matchOrders.push(matchOrder);

                            chrome.storage.sync.set({
                                matchOrders: params.matchOrders
                            }, function() {})

                        });

                    }
                }

                if (params.stage && params.stage.action === 'order_fulfillment_update_orders' && params.stage.state === 'active') {
                    saveMacthOrder();
                }

            });

            //  console.log('Order details:');
            //  console.log(e.data.order_detail);

            //   console.log('Matched order:');
            // console.log(matchOrder);

        }
    }
});

var continueToCheck = true;


var waitForHeader = new MutationObserver((mutations, observer) => {
    if (document.head) {
        observer.disconnect();
        waitForScriptsInTargetNode(document.head);
    }
}).observe(document, { childList: true, subtree: true });

var waitForBody = new MutationObserver((mutations, observer) => {
    if (document.body) {
        observer.disconnect();
        waitForScriptsInTargetNode(document.body);
    }
}).observe(document, { childList: true, subtree: true });


function waitForScriptsInTargetNode(target) {
    var observer = new MutationObserver(function(mutations) {
        mutations.forEach(function(mutation) {
            Array.from(document.querySelectorAll('script')).forEach(script => {

                if (script.src && script.src.indexOf('mtop.aliexpress.trade.buyer.order.detail') !== -1) {
                    continueToCheck = false;
                    observer.disconnect();
                    overrideOrderDetailsLoader(script);
                    return;
                }
            });
        });
    });

    var config = {
        childList: true
    };

    observer.observe(target, config);
};



function overrideOrderDetailsLoader(script) {

    var s = /callback=(.*)&/gim.exec(script.src);

    console.log('message sent!!!!');

    window.postMessage({
        subject: "getOrderDetail",
        from: "a2w",
        scriptCallback: s[1],
    }, window.location.href);

}