(function() {
    if (window.hasRun === true)
        return true; // Will ultimately be passed back to executeScript
    window.hasRun = true;


    chrome.runtime.onMessage.addListener(function(msg, sender, sendResponse) {
        if (msg.name === config.actions.CHECK_MAIN_CONTENT_IS_INCLUDED) {
            sendResponse({ status: "yes" });
        }
    });

    if (!MAFunc.isScriptAlreadyIncluded("assets/js/scripts/ma_api.js")) {
        var s = document.createElement('script');
        s.id = "ali2woo-injected-script";
        s.setAttribute("data-runtime-id", chrome.runtime.id);
        s.src = chrome.runtime.getURL("assets/js/scripts/ma_api.js");
        document.documentElement.appendChild(s);
    }

    if (window.location.href == config.urls.aliexpressMaintain) {

        chrome.storage.sync.get({
            orderData: !1
        }, function(o) {
            if (o.orderData !== !1) {
                setTimeout(function() {
                    history.back();
                }, 1000);
            }
        });

    }

    var requestHtml = function(t, r) {

        chrome.extension.sendMessage({
            action: config.actions.CONTENT_GET_PRODUCT_HTML,
            url: t,
            reqId: r
        }, function(e) {

            var responseData = { "html": e.html, "reqId": e.reqId };
            var fetchResponse = new CustomEvent(config.actions.WEB_GET_PRODUCT_HTML_RESPONSE, { "detail": responseData });
            document.dispatchEvent(fetchResponse);

        });
    };

    document.addEventListener(config.actions.WEB_GET_PRODUCT_HTML_REQUEST, function(event) {
        var data = event.detail;
        requestHtml(data.url, data.reqId);
    });

    document.addEventListener(config.actions.WEB_GET_PRODUCT_INFO_REQUEST, function(event) {
        var data = event.detail;
        MAProduct.requestProductInfo(data.params, data.reqId, function(e) {

            var responseData = { "status": e.status, "data": e.data, "error_msg": e.error_msg, "reqId": e.reqId };
            var fetchResponse = new CustomEvent(config.actions.WEB_GET_PRODUCT_INFO_RESPONSE, { "detail": responseData });
            document.dispatchEvent(fetchResponse);

        });
    });


    document.addEventListener(config.actions.WEB_ORDER_FULFILLMENT_REQUEST, function(event) {
        /*
         chrome.storage.sync.set({
             currentProduct: 0
         }, function(e) {*/
        var d = event.detail;
        chrome.extension.sendMessage({
            action: config.actions.CONTENT_ORDER_FULFILLMENT_QUEUE,
            data: d
        });
        /*  });*/

    });


    document.addEventListener(config.actions.WEB_ORDER_TRACKING_CODE_REQUEST, function(event) {
        var d = event.detail;
        chrome.extension.sendMessage({
            action: config.actions.CONTENT_ORDER_TRACKING_CODE_REQUEST,
            data: d
        });
    });


    chrome.runtime.onMessage.addListener(function(t, e, n) {
        config.actions.CONTENT_ORDER_TRACKING_CODE_RESPONSE == t.type &&
            document.dispatchEvent(new CustomEvent(config.actions.WEB_ORDER_TRACKING_CODE_RESPONSE, { "detail": t.data }));

    });

    chrome.runtime.onMessage.addListener(function(t, e, n) {
        config.actions.CONTENT_ORDER_FULFILLMENT_STATUS_RESPONSE == t.type &&
            document.dispatchEvent(new CustomEvent(config.actions.WEB_ORDER_FULFILLMENT_STATUS_RESPONSE, { "detail": t.data }));

    });

    document.addEventListener(config.actions.WEB_ORDER_FULFILLMENT_PAYALL_REQUEST, function(event) {
        var d = event.detail;
        chrome.extension.sendMessage({
            action: config.actions.CONTENT_ORDER_FULFILLMENT_PAYALL_REQUEST,
            data: d
        });
    })

    document.addEventListener(config.actions.WEB_CLOSE_CHROME_TAB_REQUEST, function(event) {
        var d = event.detail;
        chrome.extension.sendMessage({
            action: config.actions.CONTENT_CLOSE_CHROME_TAB_REQUEST,
            data: d
        });
    })

    document.addEventListener(config.actions.WEB_SWITCH_TO_CHROME_TAB_REQUEST, function(event) {
        var d = event.detail;
        chrome.extension.sendMessage({
            action: config.actions.CONTENT_SWITCH_TO_CHROME_TAB_REQUEST,
            data: d
        });
    })


})(); // <-- Invoke function. The return value is passed back to executeScript