(function() {
    function MACategoryPage(ext_options) {
        return {
            options: ext_options,
            init: function() {
                const e = this;
                document.body.classList.add("ma");
                document.body.classList.add("ma-category");

                if (document.querySelector('[class^="list--galleryWrapper"]')) {
                    console.log('MACategoryParser8');
                    let category_parser = MACategoryParser8(e.options);
                    mainPanel.render(category_parser);
                    category_parser.init();
                }
                else if (document.querySelector('[class^="list--gallery--"],[class*=" list--gallery--"]')) {
                    console.log('MACategoryParser7');
                    let category_parser= MACategoryParser7(e.options);
                    mainPanel.render(category_parser);
                    category_parser.init();
                }
                else if (document.querySelector('[class^="cateWaterFall--categoryFallContainer"]')) {
                    console.log('MACategoryParser12');
                    let category_parser = new MACategoryParser12(e.options);
                    mainPanel.render(category_parser);
                    category_parser.init();
                }
                else if (document.querySelector('[class^="red-snippet_RedSnippet__grid"]')) {
                    console.log('MACategoryParser10');
                    let category_parser= MACategoryParser10(e.options);
                    mainPanel.render(category_parser);
                    category_parser.init();
                }
                else if (
                    document.querySelector('[id^="card-list"]')
                ) {
                    console.log('MACategoryParser11');
                    let category_parser = new MACategoryParser11(e.options);
                    mainPanel.render(category_parser);
                    category_parser.init();
                }
                else if (document.querySelector('.main-wrap ul.items-list')) {
                    console.log('MAStoreParser');
                    let store_parser = MAStoreParser(e.options);
                    mainPanel.render(store_parser);
                    store_parser.init();
                }
                else if (
                    document.querySelector('body[data-spm="store_pc_home"]')
                ) {
                    console.log('MAStoreParser2_home');
                    let store_parser = MAStoreParser2_home(e.options);
                    mainPanel.render(store_parser);
                    store_parser.init();
                }
                else if (
                    document.querySelector('[class^="product-snippet_ProductSnippet__grid"]')
                ) {
                    console.log('MAStoreParser3');
                    let store_parser = MAStoreParser3(e.options);
                    mainPanel.render(store_parser);
                    store_parser.init();
                }
                else if (
                    document.querySelector('body[data-spm="store_pc_allItems_or_groupList"]') ||
                    document.querySelector('body[data-spm="store_pc_aeChoiceSimplified"]')
                ) {
                    console.log('MAStoreParser4');
                    let store_parser = MAStoreParser4(e.options);
                    mainPanel.render(store_parser);
                    store_parser.init();
                }
                else if (document.querySelector('.swiper > .swiper-wrapper')) {
                    console.log('MACategoryParserSwiper');
                    let category_parser = new MACategoryParserSwiper(e.options);
                    mainPanel.render(category_parser);
                    category_parser.init();
                }
            }
        };
    }

    class BaseParser {
        constructor(ext_options) {
            this.ext_options = ext_options;
            this.aliApiClient = new AliExpressAPIClient();

            this.shippingPanel = new Panel({
                containerId: 'ma-shipping-container',
                contentId: 'ma-panel-shipping-content',
                closeId: 'ma-close-shipping-popup',
                iconClose: chrome.runtime.getURL(config.assets.iconClose),
                svgLogo: chrome.runtime.getURL(config.assets.svgLogo)
            });

            this.importPanel = new Panel({
                containerId: 'ma-import-container',
                contentId: 'ma-panel-import-content',
                closeId: 'ma-close-popup',
                iconClose: chrome.runtime.getURL(config.assets.iconClose),
                svgLogo: chrome.runtime.getURL(config.assets.svgLogo)
            });
        }

        /**
         *
         * @param {number} product_id
         * @returns {shippingInfoDTO} shipping_info_dto
         */
        async getProductShippingData (product_id)
        {

            let product_shipping_cache = await ShippingCache.getByProductId(
                product_id,
                this.ext_options.shippingCountry,
                this.ext_options.shippingCurrency
            );

            if ( product_shipping_cache !== false )
            {
                //console.log( `from shipping cache: ${product_id} ${ext_options.shippingCountry} ${ext_options.shippingCurrency}  ${product_shipping_cache.time}` );
                let shipping_info_dto = new shippingInfoDTO(product_id, product_shipping_cache.freight);
                return shipping_info_dto;
            }
            else
            {
                let shipping_info_dto = new shippingInfoDTO( product_id );

                try
                {
                    let shipping_data = await this.aliApiClient.getShippingDataV1(
                        product_id,
                        this.ext_options.shippingCountry,
                        this.ext_options.shippingCurrency
                    );

                    shipping_info_dto = DTOFactory.buildShippingInfoFromAPIResponseV1( product_id, shipping_data );
                    await ShippingCache.set(
                        shipping_info_dto,
                        this.ext_options.shippingCountry,
                        this.ext_options.shippingCurrency
                    );

                } catch ( err )
                {
                    console.log( err.message );
                }
                finally
                {
                    return shipping_info_dto;
                }
            }

        }
    }

    function MAStoreParser ( ext_options )
    {
        const aliApiClient = new AliExpressAPIClient();

        /**
         *
         * @param {number} product_id
         * @returns {shippingInfoDTO} shipping_info_dto
         */
        async function getProductShippingData (product_id)
        {
            let product_shipping_cache = await ShippingCache.getByProductId(
                product_id,
                ext_options.shippingCountry,
                ext_options.shippingCurrency
            );

            if ( product_shipping_cache !== false ) {
                //console.log( `from shipping cache: ${product_id} ${ext_options.shippingCountry} ${ext_options.shippingCurrency}  ${product_shipping_cache.time}` );
                return new shippingInfoDTO(product_id, product_shipping_cache.freight);
            }
            else {
                let shipping_info_dto = new shippingInfoDTO(product_id);

                try {
                    let shipping_data = await aliApiClient.getShippingDataV1(
                        product_id,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );

                    shipping_info_dto = DTOFactory.buildShippingInfoFromAPIResponseV1(product_id, shipping_data);
                    await ShippingCache.set(
                        shipping_info_dto,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );

                } catch ( err ) {
                    console.log( err.message );
                }
                finally {
                    return shipping_info_dto;
                }
            }

        }

        return {
            productIds: [],
            processedProductIds: [],
            options: ext_options,

            init: async function() {
                await aliApiClient.setAliexpressCurrencyV1(ext_options.shippingCurrency);
                const e = this;

                chrome.runtime.onMessage.addListener(function(t) {

                    if (t.name == config.actions.GET_PRODUCTS_SHIPPING_INFO) {

                        e.processShippingInfoResponse(t.data);
                    }

                    if (t.name == config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED) {
                        if (t.status == "OK") {
                            e.processResponseImportedProduct(t.products)
                        } else {
                            /*
                            messagePanel.render({
                                iconClose: chrome.runtime.getURL(config.assets.iconClose),
                                svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                                state: MAProduct.getCheckImportedStateData(t)
                            });*/

                        }
                    }

                });

                e.productIds = [];

                p = document.querySelectorAll(".main-wrap ul.items-list li");
                e.prepareNodes(p);

            },

            prepareNodes: function(e) {
                for (let t = 0; t < e.length; t += 1) {
                    const r = e[t];
                    this.prepareNode(r);
                }

                let uniqueProductIds = [];

                this.productIds.forEach( id => {
                    if ( !this.processedProductIds.includes( id ) )
                    {
                        uniqueProductIds.push( id );
                        this.processedProductIds.push(id)
                    }
                });

                const $this = this;

                if (this.options.showShipping) {
                    uniqueProductIds.forEach( async function (product_id)
                    {
                        let shipping_info_dto = await getProductShippingData( product_id );
                        $this.processShippingInfoResponse( shipping_info_dto );
                    });
                }

                this.options.markImported && chrome.runtime.sendMessage({
                    action: config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                    ids: this.productIds
                });

                this.productIds = [];
            },

            prepareNode: function(e) {
                var t = this,
                    d = t.getProductData(e);

                if (!d) {
                    messagePanel.render(messagePanel.simpleErrorTpl('It looks like the AliExpress page template has changed, contact support.'));
                    return false;
                };

                var r = d.id;
                r && ! function() {
                    var n = d.url,
                        o = e.querySelector("div.info");

                    if (o) {
                        MAHtml.prependHtml(document, o, MAMessages.categoryPushButton());
                    }

                    e.addEventListener("mouseover", function(e) {
                        e.preventDefault();
                        $(this).find(".ma-btn-push-category-product").css("display", "block");
                    })

                    e.addEventListener("mouseout", function(e) {
                        e.preventDefault();
                        $(this).find(".ma-btn-push-category-product").css("display", "none");
                    })

                    var i = e.querySelector(".ma-btn-push-category-product");
                    i && i.addEventListener("click", function(e) {
                        e.preventDefault();

                        var params = { 'id': r };
                        var reqId = Math.random().toString();
                        var data = { params, "reqId": reqId };

                        MAProduct.requestProductInfo(data.params, data.reqId, function(e) {

                            var responseData = { "status": e.status, "data": e.data, "error_msg": e.error_msg, "reqId": e.reqId };

                            MAProduct.pushProduct(n, r, d.thumb, d.price_min, d.price_max, d.title, d.currency, responseData.data)
                                .catch(function(e) {
                                    console.log(e);
                                });

                        });

                    }), t.productIds.includes(r) || t.productIds.push(r)
                }()
            },

            getProductData: function(e) {

                var eo = this;

                var data = { id: false, url: false, thumb: false, price_min: false, price_max: false, title: false, currency: false };

                var formatPrice = function(e) {
                    return e.replace(/[^0-9.,]\.*/g, '').replace(',', '.');

                }

                r = $(e).find('h3 a');

                if (r.length) {
                    data.url = r.attr('href');

                    r = $(e).find('a[title]').attr('title');
                    if (r) {
                        data.title = r;
                    }
                } else {
                    return false;
                }


                if (typeof data.url.match === "undefined") {

                    return false;
                }

                var tmp = data.url.match(/.+\/([0-9,_]+)\.html/mi);

                if (tmp) {
                    var p = tmp[1],
                        s = p.split('_');
                    if (s.length > 1) {
                        data.id = s[1];
                    } else {
                        data.id = s[0];
                    }
                }


                r = $(e).find('.pic img');
                if (r.length && "" !== r[0].getAttribute('image-src')) data.thumb = r[0].getAttribute('image-src');
                else {
                    return false;
                }


                r = $(e).find('.cost').length ? $(e).find('.cost') : $(e).find('.price-current');

                if (r.length && "" !== r[0].innerText) {
                    var p = r[0].innerText.split('-');
                    if (p) {
                        data.price_min = (typeof p[0] !== 'undefined') ? formatPrice(p[0]) : false;
                        data.price_max = (typeof p[1] !== 'undefined') ? formatPrice(p[1]) : false;
                    }

                    data.currency = eo.getCurrency();
                }

                return data;
            },

            getCurrency: function(e) {
                return $("span.currency").length ? $("span.currency").text() : 'usd';
            },

            processResponseImportedProduct: function(t) {

                var n = t.filter(function(e) {
                    return e.imported;
                });

                for (var i in n) {

                    r = $('[value="' + n[i].id + '"].atc-product-id');
                    if (r.length > 0) {

                        j = $(r).parent();

                        if (j.length) {
                            MAHtml.prependHtml(document, j, MAMessages.categoryProductImportedIcon());
                        }
                    }
                }

            },

            processShippingInfoResponse: function(d) {
                var t = this,
                    r = document.querySelectorAll('[value="' + d.productId + '"].atc-product-id');

                r.forEach(function(r) {
                    var n = (0, t.findParentBySelector)(r, ".list-item") ? (0, t.findParentBySelector)(r, ".list-item") : (0, t.findParentBySelector)(r, ".item");
                    n && d.freight && t.renderShipping(t.options, d.freight, n)
                })

            },

            findParentBySelector: function(e, t) {

                for (var r = null, n = e.parentElement, o = function() {
                        return n.matches(t) && (r = n), r
                    }; n && !o();) n = n.parentElement;
                return r
            },

            renderShipping: function(e, t, r) {
                messagePanel.remove();

                var eo = this;

                var n = config.shippingOptions.find(function(t) {
                        return t.v === e.shippingOption
                    }),
                    o = n ? n.v : e.shippingOption,
                    i = n ? n.t : e.shippingOption,
                    a = t.find(function(e) {
                        return e.serviceName === o
                    }),
                    s = r.querySelector(".img img");

                var discount_div = $(r).find('.discount');

                if (discount_div.length > 0) discount_div.hide();


                if (s) {
                    var u = window.getComputedStyle(s),
                        c = eo.getImgCssClass(u),
                        l = (0, eo.findParentBySelector)(s, "div.img");
                    if (!a && e.showOnlyActive || eo.changeImgMaxSize(s, u, -6), l)
                        if (a) {
                            var d = a.price > 0 ? a.localPriceFormatStr : "Free",
                                f = l.querySelector("a");

                            if (f) {
                                f.style.border = "3px solid #79c772";
                                MAHtml.appendHtml(document, l, eo.renderShippingOptionAvailable(a.company, d, c));

                            }
                            /*   
                           if ( e.showProcessing && a.processingTime > 0) {
                               var h = r.querySelector(".picRind") ? r.querySelector(".picRind") : r.querySelector(".pic-rind");
                               h && (h.style.position = "relative", (0, MAHtml.appendHtml)(document, h, eo.renderProcessingTime(a.processingTime)))
                           }
                           */
                            if (a.time && e.showDelivery) {
                                var h = r.querySelector(".picRind") ? r.querySelector(".picRind") : r.querySelector(".pic-rind");
                                h && (h.style.position = "relative", (0, MAHtml.appendHtml)(document, h, eo.renderDeliveryTime(a.time)))
                            }


                        } else if (e.showOnlyActive) r.remove();


                    else {
                        var y = l.querySelector("a");
                        y && (y.style.border = "3px solid #dc6832"), (0, MAHtml.appendHtml)(document, l, eo.renderNoShippingOptionAvailable(i, c))
                    }
                }
            },

            renderShippingOptionAvailable: function(e, t, r) {
                return '<div class="ma-shipping has-options ' + r + '"><span>' + e + "</span><span>" + t + "</span></div>"
            },
            renderNoShippingOptionAvailable: function(e, t) {
                return '<div class="ma-shipping no-options ' + t + '"><span>No ' + e + "</span></div>"
            },
            renderProcessingTime: function(e) {
                var t = "Processing time: " + e + " Days";
                return '<div class="ma-processing-time" title="' + t + '">\n                <span class="first">Processing Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },
            renderDeliveryTime: function(e) {
                var t = "Delivery time: " + e + " Days";
                return '<div class="ma-delivery-time" title="' + t + '">\n                <span class="first">Delivery Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },

            build_products_array: function(l, p) {
                let eo = this;
                let d;
                for (let t = 0; t < l.length; t += 1) {
                    let r = l[t];
                    d = eo.getProductData(r);
                    p.push(d);
                }
                return p;
            },

            getImgCssClass: function(e) {
                var t = "large",
                    r = parseInt(e.getPropertyValue("width"), 10),
                    n = parseInt(e.getPropertyValue("padding-left"), 10);
                return 960 === r ? t = "small" : 220 === r && 8 === n && (t = "medium"), t
            },
            changeImgMaxSize: function(e, t, r) {
                var n = parseInt(t.getPropertyValue("max-height"), 10) + r,
                    o = parseInt(t.getPropertyValue("max-width"), 10) + r;
                e.style["max-height"] = n + "px", e.style["max-width"] = o + "px"
            },

            clickImportAllHandler: async function() {

                let eo = this;
                let l = document.querySelectorAll(".main-wrap ul.items-list li");
                let p = [];

                if (l) {
                    p = eo.build_products_array(l, p);
                }

                await MAProduct.pushProductArr(p);
            }

        }

    }

    function MAStoreParser2 ( ext_options )
    {
        const aliApiClient = new AliExpressAPIClient();

        /**
         *
         * @param {number} product_id
         * @returns {shippingInfoDTO} shipping_info_dto
         */
        async function getProductShippingData (product_id)
        {
            let product_shipping_cache = await ShippingCache.getByProductId(
                product_id,
                ext_options.shippingCountry,
                ext_options.shippingCurrency
            );

            if ( product_shipping_cache !== false ) {
                //console.log( `from shipping cache: ${product_id} ${ext_options.shippingCountry} ${ext_options.shippingCurrency}  ${product_shipping_cache.time}` );
                return new shippingInfoDTO(product_id, product_shipping_cache.freight);
            }
            else {
                let shipping_info_dto = new shippingInfoDTO(product_id);

                try {
                    let shipping_data = await aliApiClient.getShippingDataV1(
                        product_id,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );

                    shipping_info_dto = DTOFactory.buildShippingInfoFromAPIResponseV1(product_id, shipping_data);
                    await ShippingCache.set(
                        shipping_info_dto,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );

                } catch ( err ) {
                    console.log( err.message );
                }
                finally {
                    return shipping_info_dto;
                }
            }

        }

        return {
            productIds: [],
            processedProductIds: [],
            options: ext_options,

            init: async function() {
                await aliApiClient.setAliexpressCurrencyV1(ext_options.shippingCurrency);
                const $this = this;
                chrome.runtime.onMessage.addListener(function(t) {

                    if (t.name == config.actions.GET_PRODUCTS_SHIPPING_INFO) {

                        e.processShippingInfoResponse(t.data);
                    }

                    if (t.name == config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED) {
                        if (t.status == "OK") {
                            e.processResponseImportedProduct(t.products)
                        } else {
                            /*
                            messagePanel.render({
                                iconClose: chrome.runtime.getURL(config.assets.iconClose),
                                svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                                state: MAProduct.getCheckImportedStateData(t)
                            });*/

                        }
                    }

                });
                $this.productIds = [];
                $this.prepareAjaxNodes();
            },

            prepareAjaxNodes: function() {
                const $this = this;
                $this.product_container = document.querySelector('[id="right"]');
                let observer = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        if ("childList" === mutation.type && mutation.addedNodes.length > 0) {
                            mutation.addedNodes.forEach(function (addedNode)  {
                                if (addedNode.tagName === 'DIV' && addedNode.attributes['st_page_id']) {
                                    $this.processedProductIds = [];
                                    $this.prepareNodes([addedNode]);
                                }
                            });
                        }
                    });
                });

                observer.observe($this.product_container, {
                    attributes: true,
                    subtree: true,
                    childList: true,
                });
            },

            prepareNodes: function(e) {
                for (let t = 0; t < e.length; t += 1) {
                    const r = e[t];
                    if (r) {
                        this.prepareNode(r);
                    }
                }

                let uniqueProductIds = [];

                this.productIds.forEach( id => {
                    if (!this.processedProductIds.includes(id)) {
                        uniqueProductIds.push(id);
                        this.processedProductIds.push(id)
                    }
                });

                const $this = this;

                if (this.options.showShipping) {
                    uniqueProductIds.forEach( async function (product_id)
                    {
                        let shipping_info_dto = await getProductShippingData( product_id );
                        $this.processShippingInfoResponse( shipping_info_dto );
                    });
                }

                this.options.markImported && chrome.runtime.sendMessage({
                    action: config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                    ids: this.productIds
                });

                this.productIds = [];
            },

            prepareNode: function(e) {
                const t = this,
                    d = t.getProductData(e);

                if (!d) {
                    messagePanel.render(messagePanel.simpleErrorTpl(
                        'It looks like the AliExpress page template has changed, contact support.'
                    ));

                    return false;
                }

                const r = d.id;
                r && ! function() {
                    var n = d.url,
                        o = e.querySelector('a');

                    if (o) {
                        MAHtml.prependHtml(document, o, MAMessages.categoryPushButton());
                    }

                    e.addEventListener("mouseover", function(e) {
                        e.preventDefault();
                        $(this).find(".ma-btn-push-category-product").css("display", "block");
                    })

                    e.addEventListener("mouseout", function(e) {
                        e.preventDefault();
                        $(this).find(".ma-btn-push-category-product").css("display", "none");
                    })

                    var i = e.querySelector(".ma-btn-push-category-product");
                    i && i.addEventListener("click", function(e) {
                        e.preventDefault();
                        e.stopPropagation();

                        var params = { 'id': r };
                        var reqId = Math.random().toString();
                        var data = { params, "reqId": reqId };

                        MAProduct.requestProductInfo(data.params, data.reqId, function(e) {

                            var responseData = { "status": e.status, "data": e.data, "error_msg": e.error_msg, "reqId": e.reqId };

                            MAProduct.pushProduct(n, r, d.thumb, d.price_min, d.price_max, d.title, d.currency, responseData.data)
                                .catch(function(e) {
                                    console.log(e);
                                });

                        });

                    }), t.productIds.includes(r) || t.productIds.push(r)
                }()
            },

            getProductData: function(e) {
                let p;
                const $this = this;

                const data = {
                    id: false,
                    url: false,
                    thumb: false,
                    price_min: false,
                    price_max: false,
                    title: false,
                    currency: false
                };

                const formatPrice = function (e) {
                    return e.replace(/[^0-9.,]\.*/g, '').replace(',', '.');
                };

                let nodeA = $(e).find('a[clk_trigger]');

                if (!nodeA.length) {
                    return false;
                }

                data.url = nodeA.attr('href');

                let nodeSpan = nodeA.find('div > span');

                if (!nodeSpan.length) {
                    return false;
                }

                data.title = nodeA.children('div:last').children('span').html()


                if (typeof data.url.match === "undefined") {
                    return false;
                }

                const tmp = data.url.match(/.+\/([0-9,_]+)\.html/mi);

                if (tmp) {
                    p = tmp[1];
                    let s = p.split('_');
                    if (s.length > 1) {
                        data.id = s[1];
                    } else {
                        data.id = s[0];
                    }
                }

                return data;
            },

            getCurrency: function(e) {
                return $("span.currency").length ? $("span.currency").text() : 'usd';
            },


            processResponseImportedProduct: function(d) {

                var n = d.filter(function(e) {
                    return e.imported;
                });

                for (var i in n) {

                    let t = this;

                    let product_cont = t.product_container.querySelector("a[href*='" + n[i].id + "'");

                    if (product_cont) {
                        MAHtml.appendHtml(document, product_cont, MAMessages.categoryProductImportedIcon());
                    }
                }

            },

            /**
             *
             * @param {shippingInfoDTO} shipping_info_dto
             */
            processShippingInfoResponse: function ( shipping_info_dto )
            {
                let $this = this;
                let product_link = $this.product_container
                    .querySelector("a[href*='" + shipping_info_dto.productId + "'");
                let product_cont = product_link.parentElement;
                let img_el = product_link.querySelector('div > div > img');

                if (shipping_info_dto.freight && product_cont && img_el) {
                    $this.renderShipping(
                        $this.options,
                        shipping_info_dto.freight,
                        product_cont,
                        img_el
                    );
                }
            },

            renderShipping: function(e, t, r, s) {
                messagePanel.remove();

                var eo = this;

                var n = config.shippingOptions.find(function(t) {
                        return t.v === e.shippingOption
                    }),
                    o = n ? n.v : e.shippingOption,
                    i = n ? n.t : e.shippingOption,
                    a = t.find(function(e) {
                        return e.serviceName === o
                    });


                var c = 'large',
                    l = s,
                    f = s.parentElement, //img cont
                    h = f;

                if (a) {

                    var d = a.freightAmount.value > 0 ? a.freightAmount.formatedAmount : "Free";


                    if (f && ($(f).css('border', "3px solid #79c772").css("border-radius", "6% 6% 0 0")), (0, MAHtml.appendHtml)(document, f, eo.renderShippingOptionAvailable(a.company, d, c)), e.showProcessing && typeof a.processingTime !== "undefined" && a.processingTime > 0) {


                        MAHtml.prependHtml(document, h, eo.renderProcessingTime(a.processingTime));
                    }

                    if (a.time && e.showDelivery) {

                        MAHtml.prependHtml(document, h, eo.renderDeliveryTime(a.time));
                    }


                } else if (e.showOnlyActive) r.remove();
                else {


                    var y = f;
                    $(y).css('border', "3px solid #dc6832").css("border-radius", "6% 6% 0 0");

                    MAHtml.prependHtml(document, h, eo.renderNoShippingOptionAvailable(i, c));
                }

                //fix width and height;
                d = f.querySelector('.ma-shipping');
                $(s).css('height', $(d).width()).css('width', $(d).width());
                $(h).css('height', 'auto');

            },

            renderShippingOptionAvailable: function(e, t, r) {
                return '<div class="ma-shipping has-options ' + r + '"><span>' + e + "</span><span>" + t + "</span></div>"
            },
            renderNoShippingOptionAvailable: function(e, t) {
                return '<div class="ma-shipping no-options ' + t + '"><span>No ' + e + "</span></div>"
            },
            renderProcessingTime: function(e) {
                var t = "Processing time: " + e + " Days";
                return '<div class="ma-processing-time" title="' + t + '">\n                <span class="first">Processing Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },
            renderDeliveryTime: function(e) {
                var t = "Delivery time: " + e + " Days";
                return '<div class="ma-delivery-time" title="' + t + '">\n                <span class="first">Delivery Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },

            build_products_array: function(nodes, productDataArray) {
                const $this = this;
                let data;
                for (let t = 0; t < nodes.length; t += 1) {
                    const r = nodes[t];
                    data = $this.getProductData(r);
                    productDataArray.push(data);
                }

                return productDataArray;
            },

            getImgCssClass: function(e) {
                let t = "large",
                    r = parseInt(e.getPropertyValue("width"), 10),
                    n = parseInt(e.getPropertyValue("padding-left"), 10);

                return 960 === r ? t = "small" : 220 === r && 8 === n && (t = "medium"), t;
            },
            changeImgMaxSize: function(e, t, r) {
                var n = parseInt(t.getPropertyValue("max-height"), 10) + r,
                    o = parseInt(t.getPropertyValue("max-width"), 10) + r;
                e.style["max-height"] = n + "px", e.style["max-width"] = o + "px"
            },

            clickImportAllHandler: function() {
                const $this = this;
                MAFunc.waitForElm('div[st_page_id]').then(async (elm) => {
                    const nodes = document.querySelectorAll('div[st_page_id]');
                    let productDataArray = [];
                    if (nodes){
                        productDataArray = $this.build_products_array(nodes, productDataArray);
                    }
                    await MAProduct.pushProductArr(productDataArray);
                });
            }
        }
    }

    function MAStoreParser2_home ( ext_options )
    {
        const aliApiClient = new AliExpressAPIClient();

        /**
         *
         * @param {number} product_id
         * @returns {shippingInfoDTO} shipping_info_dto
         */
        async function getProductShippingData (product_id)
        {
            let product_shipping_cache = await ShippingCache.getByProductId(
                product_id,
                ext_options.shippingCountry,
                ext_options.shippingCurrency
            );

            if ( product_shipping_cache !== false ) {
                //console.log( `from shipping cache: ${product_id} ${ext_options.shippingCountry} ${ext_options.shippingCurrency}  ${product_shipping_cache.time}` );
                return new shippingInfoDTO(product_id, product_shipping_cache.freight);
            }
            else {
                let shipping_info_dto = new shippingInfoDTO(product_id);

                try {
                    let shipping_data = await aliApiClient.getShippingDataV1(
                        product_id,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );

                    shipping_info_dto = DTOFactory.buildShippingInfoFromAPIResponseV1(product_id, shipping_data);
                    await ShippingCache.set(
                        shipping_info_dto,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );

                } catch ( err ) {
                    console.log( err.message );
                }

                return shipping_info_dto;
            }

        }

        return {
            productIds: [],
            processedProductIds: [],
            options: ext_options,

            init: async function() {
                await aliApiClient.setAliexpressCurrencyV1(ext_options.shippingCurrency);
                const $this = this;
                chrome.runtime.onMessage.addListener(function(t) {

                    if (t.name == config.actions.GET_PRODUCTS_SHIPPING_INFO) {

                        e.processShippingInfoResponse(t.data);
                    }

                    if (t.name == config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED) {
                        if (t.status == "OK") {
                            e.processResponseImportedProduct(t.products)
                        }
                    }

                });

                messagePanel.render(
                    messagePanel.simpleTpl(
                        'Please wait. Our extension is waiting for AliExpress to show shipping data.'
                    )
                );

                $this.productIds = [];
                MAFunc.waitForElm('a[clk_trigger]').then((elm) => {
                    const nodes = [];
                    const aNodeList = document.querySelectorAll('a[clk_trigger]');
                    for (let i in aNodeList) {
                        nodes.push(aNodeList[i].parentElement);
                    }
                    $this.product_container = document.querySelector('[class="pi-component-root"]');
                    $this.prepareNodes(nodes);

                    $this.setupProductContainerWatcher();
                });
            },

            setupProductContainerWatcher: function () {
                const $this = this;
                const bufferedNodes = [];

                const observer = new MutationObserver((mutations) => {
                    mutations.forEach(mutation => {
                        if (mutation.type === 'childList' && mutation.addedNodes.length > 0) {
                            mutation.addedNodes.forEach(node => {
                                if (node.nodeType !== node.ELEMENT_NODE || node.nodeName !== 'DIV') return;

                                const targetClasses = [
                                    'ma-shipping',
                                    'ma-delivery-time',
                                    'ma-btn-push-category-product',
                                    'AIC-quickView'
                                ];
                                const nodeClasses = Array.from(node.classList);
                                const hasAnyClass = targetClasses.some(cls => nodeClasses.includes(cls));
                                if (hasAnyClass) return;

                                if (node.hasAttribute('st_page_id')) {
                                    bufferedNodes.push(node);
                                    scheduleProcessing();
                                }
                            });
                        }
                    });
                });

                observer.observe(this.product_container, {
                    childList: true,
                    subtree: true
                });

                let processingScheduled = false;
                let scheduleTimeout = null;

                function scheduleProcessing() {
                    if (processingScheduled) return;

                    processingScheduled = true;
                    clearTimeout(scheduleTimeout);
                    scheduleTimeout = setTimeout(() => {
                        const nodesToProcess = bufferedNodes.splice(0);
                        processingScheduled = false;
                        $this.prepareNodes(nodesToProcess);
                    }, 100);
                }
            },

            prepareNodes: function(nodes) {
                for (const node of nodes) {
                    if (node) {
                        this.prepareNode(node);
                    }
                }

                const uniqueProductIds = this.productIds.filter(id => {
                    if (!this.processedProductIds.includes(id)) {
                        this.processedProductIds.push(id);
                        return true;
                    }
                    return false;
                });

                this.productIds = [];

                if (!this.options.showShipping || !uniqueProductIds.length) return;

                const $this = this;

                const processor = new ChunkProcessor({
                    chunkSize: 20,
                    delay: 200,
                    onProgress: (done, total) => {
                        messagePanel.safeUpdateProgress({
                            text: `Loading ${done} of ${total} shipping items...`,
                            actions: [{
                                id: 'ma-stop-loading',
                                title: 'Stop Loading',
                                action: () => {
                                    processor.abort();
                                    messagePanel.safeUpdateProgress('Shipping loading manually aborted.');
                                }
                            }]
                        });
                    },
                    onError: (err, chunk) => {
                        console.warn(err);
                        messagePanel.safeUpdateProgress(
                            `Error loading a chunk of ${chunk.length} shipping items. Details: ${err.message || err}`
                        );
                    }
                });

                processor.process(uniqueProductIds, async productId => {
                    const shipping_info_dto = await getProductShippingData(productId);
                    $this.processShippingInfoResponse(shipping_info_dto);
                }).then(() => {
                    messagePanel.safeUpdateProgress('Shipping loading completed. Scroll the page to load more.');

                    if ($this.options.markImported) {
                        chrome.runtime.sendMessage({
                            action: config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                            ids: uniqueProductIds
                        });
                    }
                });
            },

            prepareNodesOld: function(e) {
                for (let t = 0; t < e.length; t += 1) {
                    const r = e[t];
                    if (r) {
                        this.prepareNode(r);
                    }
                }

                let uniqueProductIds = [];

                this.productIds.forEach( id => {
                    if ( !this.processedProductIds.includes(id)) {
                        uniqueProductIds.push( id );
                        this.processedProductIds.push(id)
                    }
                });

                const $this = this;

                if (this.options.showShipping) {
                    uniqueProductIds.forEach( async function (product_id)
                    {
                        let shipping_info_dto = await getProductShippingData( product_id );
                        $this.processShippingInfoResponse( shipping_info_dto );
                    });
                }

                this.options.markImported && chrome.runtime.sendMessage({
                    action: config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                    ids: this.productIds
                });

                this.productIds = [];
            },

            prepareNode: function(node) {
                const t = this,
                    data = t.getProductData(node);

                if (!data) {
                    messagePanel.render(messagePanel.simpleErrorTpl(
                        'It looks like the AliExpress page template has changed, contact support.'
                    ));

                    return false;
                }

                if (!node.querySelector(".ma-btn-push-category-product")) {
                    CategoryParserUtils.addPushButton(node, data);
                }

                //ignore duplicates within one set
                if (!this.productIds.includes(data.id)) {
                    this.productIds.push(data.id);
                }
            },

            getProductData: function(e) {
                let p;
                const $this = this;

                const data = {
                    id: false,
                    url: false,
                    thumb: false,
                    price_min: false,
                    price_max: false,
                    title: false,
                    currency: false
                };

                const formatPrice = function (e) {
                    return e.replace(/[^0-9.,]\.*/g, '').replace(',', '.');
                };

                let nodeA = $(e).find('a[clk_trigger]');

                if (!nodeA.length) {
                    return false;
                }

                data.url = nodeA.attr('href');

                let nodeSpan = nodeA.find('div > span');

                if (!nodeSpan.length) {
                    return false;
                }

                data.title = nodeA.children('div:last').children('span').html()


                if (typeof data.url.match === "undefined") {
                    return false;
                }

                const tmp = data.url.match(/.+\/([0-9,_]+)\.html/mi);

                if (tmp) {
                    p = tmp[1];
                    let s = p.split('_');
                    if (s.length > 1) {
                        data.id = s[1];
                    } else {
                        data.id = s[0];
                    }
                }

                return data;
            },

            getCurrency: function(e) {
                return $("span.currency").length ? $("span.currency").text() : 'usd';
            },


            processResponseImportedProduct: function(d) {

                var n = d.filter(function(e) {
                    return e.imported;
                });

                for (var i in n) {

                    let t = this;

                    let product_cont = t.product_container.querySelector("a[href*='" + n[i].id + "'");

                    if (product_cont) {
                        MAHtml.appendHtml(document, product_cont, MAMessages.categoryProductImportedIcon());
                    }
                }

            },

            /**
             *
             * @param {shippingInfoDTO} shipping_info_dto
             */
            processShippingInfoResponse: function ( shipping_info_dto )
            {
                let $this = this;
                let product_link = $this.product_container
                    .querySelector("a[href*='" + shipping_info_dto.productId + "'");
                let product_cont = product_link.parentElement;
                let img_el = product_link.querySelector('div > div > img');

                if (shipping_info_dto.freight && product_cont && img_el) {
                    CategoryParserUtils.renderShipping(
                        $this.options,
                        shipping_info_dto.freight,
                        product_cont,
                        img_el
                    );
                }
            },

            /*
            renderShipping: function(e, t, r, s) {
                messagePanel.remove();

                var eo = this;

                var n = config.shippingOptions.find(function(t) {
                        return t.v === e.shippingOption
                    }),
                    o = n ? n.v : e.shippingOption,
                    i = n ? n.t : e.shippingOption,
                    a = t.find(function(e) {
                        return e.serviceName === o
                    });


                var c = 'large',
                    l = s,
                    f = s.parentElement, //img cont
                    h = f;

                if (a) {

                    var d = a.freightAmount.value > 0 ? a.freightAmount.formatedAmount : "Free";


                    if (f && ($(f).css('border', "3px solid #79c772").css("border-radius", "6% 6% 0 0")), (0, MAHtml.appendHtml)(document, f, eo.renderShippingOptionAvailable(a.company, d, c)), e.showProcessing && typeof a.processingTime !== "undefined" && a.processingTime > 0) {


                        MAHtml.prependHtml(document, h, eo.renderProcessingTime(a.processingTime));
                    }

                    if (a.time && e.showDelivery) {

                        MAHtml.prependHtml(document, h, eo.renderDeliveryTime(a.time));
                    }


                } else if (e.showOnlyActive) r.remove();
                else {


                    var y = f;
                    $(y).css('border', "3px solid #dc6832").css("border-radius", "6% 6% 0 0");

                    MAHtml.prependHtml(document, h, eo.renderNoShippingOptionAvailable(i, c));
                }

                //fix width and height;
                d = f.querySelector('.ma-shipping');
                $(s).css('height', $(d).width()).css('width', $(d).width());
                $(h).css('height', 'auto');

            },

            renderShippingOptionAvailable: function(e, t, r) {
                return '<div class="ma-shipping has-options ' + r + '"><span>' + e + "</span><span>" + t + "</span></div>"
            },
            renderNoShippingOptionAvailable: function(e, t) {
                return '<div class="ma-shipping no-options ' + t + '"><span>No ' + e + "</span></div>"
            },
            renderProcessingTime: function(e) {
                var t = "Processing time: " + e + " Days";
                return '<div class="ma-processing-time" title="' + t + '">\n                <span class="first">Processing Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },
            renderDeliveryTime: function(e) {
                var t = "Delivery time: " + e + " Days";
                return '<div class="ma-delivery-time" title="' + t + '">\n                <span class="first">Delivery Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },
            */
            build_products_array: function(nodes, productDataArray) {
                const $this = this;
                let data;
                for (let t = 0; t < nodes.length; t += 1) {
                    const r = nodes[t];
                    data = $this.getProductData(r);
                    productDataArray.push(data);
                }

                return productDataArray;
            },

            getImgCssClass: function(e) {
                let t = "large",
                    r = parseInt(e.getPropertyValue("width"), 10),
                    n = parseInt(e.getPropertyValue("padding-left"), 10);

                return 960 === r ? t = "small" : 220 === r && 8 === n && (t = "medium"), t;
            },
            changeImgMaxSize: function(e, t, r) {
                var n = parseInt(t.getPropertyValue("max-height"), 10) + r,
                    o = parseInt(t.getPropertyValue("max-width"), 10) + r;
                e.style["max-height"] = n + "px", e.style["max-width"] = o + "px"
            },

            clickImportAllHandler: function() {
                const $this = this;
                MAFunc.waitForElm('div[st_page_id]').then(async (elm) => {
                    const nodes = document.querySelectorAll('div[st_page_id]');
                    let productDataArray = [];
                    if (nodes){
                        productDataArray = $this.build_products_array(nodes, productDataArray);
                    }
                    await MAProduct.pushProductArr(productDataArray);
                });
            }
        }
    }

    function MAStoreParser3 ( ext_options )
    {
        const aliApiClient = new AliExpressAPIClient();

        /**
         *
         * @param {number} product_id
         * @returns {shippingInfoDTO} shipping_info_dto
         */
        async function getProductShippingData (product_id)
        {
            let product_shipping_cache = await ShippingCache.getByProductId(
                product_id,
                ext_options.shippingCountry,
                ext_options.shippingCurrency
            );

            if ( product_shipping_cache !== false ) {
                //console.log( `from shipping cache: ${product_id} ${ext_options.shippingCountry} ${ext_options.shippingCurrency}  ${product_shipping_cache.time}` );
                return new shippingInfoDTO(product_id, product_shipping_cache.freight);
            }
            else {
                let shipping_info_dto = new shippingInfoDTO(product_id);

                try {
                    let shipping_data = await aliApiClient.getShippingDataV1(
                        product_id,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );

                    shipping_info_dto = DTOFactory.buildShippingInfoFromAPIResponseV1(product_id, shipping_data);
                    await ShippingCache.set(
                        shipping_info_dto,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );

                } catch ( err ) {
                    console.log( err.message );
                }
                finally {
                    return shipping_info_dto;
                }
            }

        }

        return {
            productIds: [],
            processedProductIds: [],
            observedProductIds: [],
            options: ext_options,

            init: async function() {
                await aliApiClient.setAliexpressCurrencyV1(ext_options.shippingCurrency);
                const $this = this;
                chrome.runtime.onMessage.addListener(function(t) {

                    if (t.name == config.actions.GET_PRODUCTS_SHIPPING_INFO) {

                        e.processShippingInfoResponse(t.data);
                    }

                    if (t.name == config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED) {
                        if (t.status == "OK") {
                            e.processResponseImportedProduct(t.products)
                        } else {
                            /*
                            messagePanel.render({
                                iconClose: chrome.runtime.getURL(config.assets.iconClose),
                                svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                                state: MAProduct.getCheckImportedStateData(t)
                            });*/

                        }
                    }

                });
                $this.productIds = [];
                $this.observedProductIds = [];
                let mainContSelector = '[class^="product-snippet_ProductSnippet__grid"]';

                MAFunc.waitForElm(mainContSelector).then((elm) => {
                    $this.product_container = $(elm)[0];

                    messagePanel.render(
                        messagePanel.simpleTpl(
                            'Please wait. Our extension is waiting for AliExpress to show shipping data.'
                        )
                    );
                    let mainContainerObserver =
                        new MutationObserver(function (mutationList) {
                            mutationList.forEach(function (mutation) {
                                if (mutation.type === "attributes" && mutation.oldValue.startsWith('gallery_Gallery__picture')) {
                                    let node = mutation.target.parentElement.parentElement
                                        .parentElement.parentElement.parentElement.parentElement;

                                    $this.fillObservedProductIds([node], function(node) {
                                        $this.prepareNodes([node]);
                                    });
                                }
                            })
                        });

                    mainContainerObserver.observe($this.product_container, {
                        attributes: true,
                        childList: true,
                        subtree: true,
                        characterData: false,
                        attributeOldValue: true,
                        attributeFilter: ["class"],
                    });

                    MAHtml.scrollPageTopBottom(300, function (){
                        messagePanel.remove();
                    });
                });
            },

            fillObservedProductIds: function (productNode, callback){
                let $this = this;
                productNode.forEach(function (el){
                    let link_el = $(el).find('a[class^="product-snippet_ProductSnippet__galleryBlock"]');
                    let id = MAProduct.getProductIdFromUrl(link_el.attr('href'));
                    if ( !$this.observedProductIds.includes(id)) {
                        $this.observedProductIds.push(id);
                        if (callback) {
                            callback(el);
                        }
                    }
                });
            },

            prepareNodes: function(e) {
                for (let t = 0; t < e.length; t += 1) {
                    const r = e[t];
                    this.prepareNode(r);
                }

                let uniqueProductIds = [];

                this.productIds.forEach( id => {
                    if (!this.processedProductIds.includes(id)) {
                        uniqueProductIds.push(id);
                        this.processedProductIds.push(id)
                    }
                });

                const $this = this;

                if (this.options.showShipping) {
                    uniqueProductIds.forEach( async function (product_id)
                    {
                        let shipping_info_dto = await getProductShippingData( product_id );
                        $this.processShippingInfoResponse( shipping_info_dto );
                    });
                }

                this.options.markImported && chrome.runtime.sendMessage({
                    action: config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                    ids: this.productIds
                });

                this.productIds = [];
            },

            prepareNode: function(e) {
                const t = this,
                    d = t.getProductData(e);

                if (!d) {
                    messagePanel.render(messagePanel.simpleErrorTpl(
                        'It looks like the AliExpress page template has changed, contact support.'
                    ));

                    return false;
                }

                const r = d.id;
                r && ! function() {
                    let n = d.url,
                        o = e.querySelector('a');

                    if (o) {
                        MAHtml.prependHtml(document, o, MAMessages.categoryPushButton());
                    }

                    e.addEventListener("mouseover", function(e) {
                        e.preventDefault();
                        $(this).find(".ma-btn-push-category-product").css("display", "block");
                    })

                    e.addEventListener("mouseout", function(e) {
                        e.preventDefault();
                        $(this).find(".ma-btn-push-category-product").css("display", "none");
                    })

                    let i = e.querySelector(".ma-btn-push-category-product");
                    i && i.addEventListener("click", function(e) {
                        e.preventDefault();
                        e.stopPropagation();

                        let params = { 'id': r };
                        let reqId = Math.random().toString();
                        let data = { params, "reqId": reqId };

                        MAProduct.requestProductInfo(data.params, data.reqId, function(e) {

                            let responseData = { "status": e.status, "data": e.data, "error_msg": e.error_msg, "reqId": e.reqId };

                            MAProduct.pushProduct(n, r, d.thumb, d.price_min, d.price_max, d.title, d.currency, responseData.data)
                                .catch(function(e) {
                                    console.log(e);
                                });

                        });

                    }), t.productIds.includes(r) || t.productIds.push(r)
                }()
            },

            getProductData: function(e) {
                let p;
                const $this = this;

                const data = {
                    id: false,
                    url: false,
                    thumb: false,
                    price_min: false,
                    price_max: false,
                    title: false,
                    currency: false
                };

                const formatPrice = function (e) {
                    return e.replace(/[^0-9.,]\.*/g, '').replace(',', '.');
                };

                data.url = $(e).find('a[class^="product-snippet_ProductSnippet__galleryBlock"]').attr('href');

                if (typeof data.url.match === "undefined") {
                    return false;
                }

                const tmp = data.url.match(/.+\/([0-9,_]+)\.html/mi);

                if (tmp) {
                    p = tmp[1];
                    let s = p.split('_');
                    if (s.length > 1) {
                        data.id = s[1];
                    } else {
                        data.id = s[0];
                    }
                }

                return data;
            },

            getCurrency: function(e) {
                return $("span.currency").length ? $("span.currency").text() : 'usd';
            },


            processResponseImportedProduct: function(d) {

                var n = d.filter(function(e) {
                    return e.imported;
                });

                for (var i in n) {

                    let t = this;

                    let product_cont = t.product_container.querySelector("a[href*='" + n[i].id + "'");

                    if (product_cont) {
                        MAHtml.appendHtml(document, product_cont, MAMessages.categoryProductImportedIcon());
                    }
                }

            },

            /**
             *
             * @param {shippingInfoDTO} shipping_info_dto
             */
            processShippingInfoResponse: function (shipping_info_dto) {
                let $this = this;
                let product_link = $this.product_container
                    .querySelector("a[href*='" + shipping_info_dto.productId + "'");
                let product_cont = product_link.parentElement.parentElement;
                let img_el = product_link;

                if (shipping_info_dto.freight && product_cont && img_el) {
                    $this.renderShipping(
                        $this.options,
                        shipping_info_dto.freight,
                        product_cont,
                        img_el
                    );
                }
            },

            renderShipping: function(e, t, r, s) {
                messagePanel.remove();

                var eo = this;

                var n = config.shippingOptions.find(function(t) {
                        return t.v === e.shippingOption
                    }),
                    o = n ? n.v : e.shippingOption,
                    i = n ? n.t : e.shippingOption,
                    a = t.find(function(e) {
                        return e.serviceName === o
                    });


                var c = 'large',
                    l = s,
                    f = s.parentElement, //img cont
                    h = f;

                if (a) {

                    var d = a.freightAmount.value > 0 ? a.freightAmount.formatedAmount : "Free";


                    if (f && ($(f).css('border', "3px solid #79c772").css("border-radius", "6% 6% 0 0")), (0, MAHtml.appendHtml)(document, f, eo.renderShippingOptionAvailable(a.company, d, c)), e.showProcessing && typeof a.processingTime !== "undefined" && a.processingTime > 0) {


                        MAHtml.prependHtml(document, h, eo.renderProcessingTime(a.processingTime));
                    }

                    if (a.time && e.showDelivery) {

                        MAHtml.prependHtml(document, h, eo.renderDeliveryTime(a.time));
                    }


                } else if (e.showOnlyActive) r.remove();
                else {


                    var y = f;
                    $(y).css('border', "3px solid #dc6832").css("border-radius", "6% 6% 0 0");

                    MAHtml.prependHtml(document, h, eo.renderNoShippingOptionAvailable(i, c));
                }

                //fix width and height;
                d = f.querySelector('.ma-shipping');
                $(s).css('height', $(d).width()).css('width', $(d).width());
                $(h).css('height', 'auto');

            },

            renderShippingOptionAvailable: function(e, t, r) {
                return '<div class="ma-shipping has-options ' + r + '"><span>' + e + "</span><span>" + t + "</span></div>"
            },
            renderNoShippingOptionAvailable: function(e, t) {
                return '<div class="ma-shipping no-options ' + t + '"><span>No ' + e + "</span></div>"
            },
            renderProcessingTime: function(e) {
                var t = "Processing time: " + e + " Days";
                return '<div class="ma-processing-time" title="' + t + '">\n                <span class="first">Processing Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },
            renderDeliveryTime: function(e) {
                var t = "Delivery time: " + e + " Days";
                return '<div class="ma-delivery-time" title="' + t + '">\n                <span class="first">Delivery Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },

            build_products_array: function(nodes, productDataArray) {
                const $this = this;
                let data;
                for (let t = 0; t < nodes.length; t += 1) {
                    const r = nodes[t];
                    data = $this.getProductData(r);
                    productDataArray.push(data);
                }

                return productDataArray;
            },

            getImgCssClass: function(e) {
                let t = "large",
                    r = parseInt(e.getPropertyValue("width"), 10),
                    n = parseInt(e.getPropertyValue("padding-left"), 10);

                return 960 === r ? t = "small" : 220 === r && 8 === n && (t = "medium"), t;
            },
            changeImgMaxSize: function(e, t, r) {
                var n = parseInt(t.getPropertyValue("max-height"), 10) + r,
                    o = parseInt(t.getPropertyValue("max-width"), 10) + r;
                e.style["max-height"] = n + "px", e.style["max-width"] = o + "px"
            },

            clickImportAllHandler: async function() {
                const $this = this;
                const nodes = $this.product_container.childNodes;
                let productDataArray = [];
                if (nodes){
                    productDataArray = $this.build_products_array(nodes, productDataArray);
                }
                await MAProduct.pushProductArr(productDataArray);
            }
        }
    }

    function MAStoreParser4(ext_options) {

        //[ae_object_type^="product"]
        const aliApiClient = new AliExpressAPIClient();

        /**
         *
         * @param {number} product_id
         * @returns {shippingInfoDTO} shipping_info_dto
         */
        async function getProductShippingData (product_id)
        {

            let product_shipping_cache = await ShippingCache.getByProductId(
                product_id,
                ext_options.shippingCountry,
                ext_options.shippingCurrency
            );

            if ( product_shipping_cache !== false )
            {
                //console.log( `from shipping cache: ${product_id} ${ext_options.shippingCountry} ${ext_options.shippingCurrency}  ${product_shipping_cache.time}` );
                let shipping_info_dto = new shippingInfoDTO(product_id, product_shipping_cache.freight);
                return shipping_info_dto;
            }
            else
            {
                let shipping_info_dto = new shippingInfoDTO( product_id );

                try
                {
                    let shipping_data = await aliApiClient.getShippingDataV1(
                        product_id,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );

                    shipping_info_dto = DTOFactory.buildShippingInfoFromAPIResponseV1( product_id, shipping_data );
                    await ShippingCache.set(
                        shipping_info_dto,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );

                } catch ( err )
                {
                    console.log( err.message );
                }
                finally
                {
                    return shipping_info_dto;
                }
            }

        }

        return {
            productIds: [],
            observedProductIds: [],
            options: ext_options,
            product_container: '',
            lazyLoadClass: 'lazy-load',

            init: async function() {
                await aliApiClient.setAliexpressCurrencyV1(ext_options.shippingCurrency);
                const $this = this;

                chrome.runtime.onMessage.addListener(function(t) {

                    if (t.name === config.actions.GET_PRODUCTS_SHIPPING_INFO) {

                        $this.processShippingInfoResponse(t.data);
                    }

                    if (t.name === config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED) {
                        if (t.status === "OK") {
                            $this.processResponseImportedProduct(t.products)
                        } else {
                            /*
                            messagePanel.render({
                                iconClose: chrome.runtime.getURL(config.assets.iconClose),
                                svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                                state: MAProduct.getCheckImportedStateData(t)
                            });
                            */
                        }
                    }

                });

                $this.processedProductIds = [];


                let mainContSelector = '[id="right"]';


                MAFunc.waitForElm(mainContSelector).then((elm) => {
                    $this.product_container = $(elm)[0];

                    messagePanel.render(
                        messagePanel.simpleTpl(
                            'Please wait. Our extension is waiting for AliExpress to show shipping data.'
                        )
                    );

                    let mainContainerObserver =
                        new MutationObserver(function (mutationList) {
                            mutationList.forEach(function (mutation) {
                                if ("childList" === mutation.type && mutation.addedNodes.length > 0) {
                                    mutation.addedNodes.forEach(function (addedNode)  {

                                        let condition = addedNode.tagName === 'DIV' && addedNode.firstChild &&
                                            addedNode.firstChild.attributes &&
                                            addedNode.firstChild.attributes['st_page_id'];
                                        if (condition) {
                                            addedNode.childNodes.forEach(function(node) {
                                                $this.fillObservedProductIds([node]);
                                                $this.prepareNodes([node]);
                                            });
                                            let msg = 'Received data for '
                                                + $this.observedProductIds.length
                                                + ' products. Rendering results...';

                                            messagePanel.render(
                                                messagePanel.simpleTpl(msg)
                                            );
                                        }
                                    });
                                }
                            })
                        });


                    mainContainerObserver.observe($this.product_container, {
                        attributes: true,
                        childList: true,
                        subtree: true,
                        characterData: false,
                        attributeOldValue: true,
                        attributeFilter: ["class"],
                    });

                    MAHtml.scrollPageTopBottom(300, function (){
                        messagePanel.remove();
                    });
                });
            },

            fillObservedProductIds: function (nodes, callback){
                let $this = this;
                nodes.forEach(function (node){
                    let link_el = node.querySelector('a[clk_trigger]');
                    let id = MAProduct.getProductIdFromUrl(link_el.href);
                    if ( !$this.observedProductIds.includes(id)) {
                        $this.observedProductIds.push(id);
                        if (callback) {
                            callback(node);
                        }
                    }
                });
            },

            /**
             *
             * @param {Array} nodes
             */
            prepareNodes: function (nodes) {

                const $this = this;

                for (let t = 0; t < nodes.length; t += 1) {
                    $this.prepareNode(nodes[t]);
                }

                let uniqueProductIds = [];

                this.productIds.forEach( id => {
                    if (!this.processedProductIds.includes(id)) {
                        uniqueProductIds.push( id );
                        this.processedProductIds.push(id)
                    }
                } );

                if ($this.options.showShipping) {
                    uniqueProductIds.forEach( async function (product_id) {
                        let shipping_info_dto = await getProductShippingData(product_id);
                        $this.processShippingInfoResponse(shipping_info_dto);
                    });
                }

                $this.options.markImported && chrome.runtime.sendMessage({
                    action: config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                    ids: $this.productIds
                });

                $this.productIds = [];
            },

            prepareNode: function(node) {
                let $this = this;
                let data = $this.getProductData(node);

                if (!data) {
                    return;
                }

                let productId = data.id;

                if (!productId) {
                    return;
                }

                let n = data.url;

                $(node).css('position', 'relative')
                    .css('overflow', 'visible');

                MAHtml.appendHtml(document, node, MAMessages.categoryPushButton());

                node.addEventListener("mouseover", function(event) {
                    event.preventDefault();

                    $(this).find(".ma-btn-push-category-product")
                        .css("display", "block");
                })
                node.addEventListener("mouseout", function(event) {
                    event.preventDefault();

                    $(this).find(".ma-btn-push-category-product")
                        .css("display", "none");
                })

                let pushProductButton = node.querySelector(".ma-btn-push-category-product");
                if (pushProductButton) {
                    pushProductButton.addEventListener("click", function(event) {
                        event.preventDefault();

                        let params = {
                            'id': productId
                        };
                        let reqId = Math.random().toString();
                        let requestData = {
                            params,
                            "reqId": reqId
                        };

                        MAProduct.requestProductInfo(requestData.params, requestData.reqId, function(event) {

                            let responseData = {
                                "status": event.status,
                                "data": event.data,
                                "error_msg": event.error_msg,
                                "reqId": event.reqId
                            };

                            MAProduct.pushProduct(
                                n, productId, data.thumb, data.price_min,
                                data.price_max, data.title, data.currency, responseData.data
                            ).catch(function(event) {
                                console.log(event);
                            });
                        });

                        event.stopPropagation();
                    });
                }

                if (!$this.productIds.includes(productId)) {
                    $this.productIds.push(productId)
                }
            },

            getProductData: function(node) {
                let data = {
                    id: false,
                    url: false,
                    thumb: false,
                    price_min: false,
                    price_max: false,
                    title: false,
                    currency: false
                };

                let nodeA = node.querySelector("a[href*='/item/']");

                if (nodeA) {
                    data.url = nodeA.getAttribute("href");
                } else {
                    return false;
                }

                if (typeof data.url.match === "undefined") {

                    return false;
                }

                data.id = MAProduct.getProductIdFromUrl(data.url);

                return data;
            },

            processResponseImportedProduct: function(d) {
                let n = d.filter(function(e) {
                    return e.imported;
                });

                for (let i in n) {

                    let t = this;

                    let product_link = t.product_container.querySelector("a[href*='" + n[i].id + "'");
                    let product_cont = product_link;

                    if (product_cont) {
                        MAHtml.appendHtml(document, product_cont, MAMessages.categoryProductImportedIcon());
                    }
                }

            },

            /**
             * @param {shippingInfoDTO} shipping_info_dto
             */
            processShippingInfoResponse: function(shipping_info_dto) {
                const $this = this;

                let product_link = $this.product_container.querySelector(
                    "a[href*='" + shipping_info_dto.productId + "'"
                );
                let product_cont = product_link.parentElement;
                let img_el = product_link.firstChild.firstChild;

                if (shipping_info_dto.freight && product_cont && img_el) {
                    $this.renderShipping($this.options, shipping_info_dto.freight, product_cont, img_el);
                }
            },

            renderShipping: function(settings, shippingItems, node, imgNode) {
                messagePanel.remove();

                const $this = this;

                const selectedShipping = config.shippingOptions.find(function(item) {
                    return item.v.toLowerCase() === settings.shippingOption.toLowerCase() ||
                        item.t.toLowerCase() === settings.shippingOption.toLowerCase()
                });

                const selectedShippingValue = selectedShipping ? selectedShipping.v : settings.shippingOption;
                const selectedShippingText = selectedShipping ? selectedShipping.t : settings.shippingOption;
                const shippingData = shippingItems.find(function(item) {
                    return item.serviceName.toLowerCase() === selectedShippingValue.toLowerCase() ||
                        item.serviceName.toLowerCase() === selectedShippingText.toLowerCase()
                });

                let imageClassName = 'large';
                let imgNodeParent = imgNode.parentElement; //img cont
                let otherNode = imgNodeParent;

                if (shippingData) {
                    let shippingCostText = shippingData.freightAmount.value > 0 ?
                        shippingData.freightAmount.formatedAmount : "Free";

                    if (imgNodeParent) {
                        $(imgNodeParent).css('border', "3px solid #79c772")
                            .css("border-radius", "6% 6% 0 0");
                        MAHtml.appendHtml(
                            document, imgNodeParent,
                            $this.renderShippingOptionAvailable(shippingData.company, shippingCostText, imageClassName)
                        );
                        let shouldShowProcessingTime = settings.showProcessing &&
                            typeof shippingData.processingTime !== "undefined" && shippingData.processingTime > 0;
                        if (shouldShowProcessingTime) {
                            MAHtml.prependHtml(
                                document, otherNode, $this.renderProcessingTime(shippingData.processingTime)
                            );
                        }
                    }

                    if (shippingData.time && settings.showDelivery) {
                        MAHtml.prependHtml(document, otherNode, $this.renderDeliveryTime(shippingData.time));
                    }
                } else if (settings.showOnlyActive) {
                    node.remove();
                }
                else {
                    // console.log(shippingItems);
                    $(imgNodeParent).css('border', "3px solid #dc6832")
                        .css("border-radius", "6% 6% 0 0");
                    MAHtml.prependHtml(
                        document, otherNode,
                        $this.renderNoShippingOptionAvailable(selectedShippingText, imageClassName)
                    );
                }

                //fix width and height;
                let shippingNode = imgNodeParent.querySelector('.ma-shipping');
                $(imgNode).css('height', $(shippingNode).width()).css('width', $(shippingNode).width());
                $(otherNode).css('height', 'auto');
            },

            renderShippingOptionAvailable: function(e, t, r) {
                return '<div class="ma-shipping has-options ' + r + '"><span>' + e + "</span><span>" + t + "</span></div>"
            },
            renderNoShippingOptionAvailable: function(e, t) {
                return '<div class="ma-shipping no-options ' + t + '"><span>No ' + e + "</span></div>"
            },
            renderProcessingTime: function(e) {
                var t = "Processing time: " + e + " Days";
                return '<div class="ma-processing-time" title="' + t + '">\n                <span class="first">Processing Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },
            renderDeliveryTime: function(e) {
                var t = "Delivery time: " + e + " Days";
                return '<div class="ma-delivery-time" title="' + t + '">\n                <span class="first">Delivery Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },

            build_products_array: function(nodes) {
                const $this = this;
                let products = [];

                for (let t = 0; t < nodes.length; t += 1) {
                    let product = $this.getProductData(nodes[t]);
                    if (product) {
                        products.push(product);
                    }
                }

                return products;
            },

            filterAllLazyLoadedNodes: function(nodes) {
                const $this = this;

                return [...nodes].filter(function (node) {
                    const lazyLoadChild = node.querySelectorAll('[class^="'+$this.lazyLoadClass+'"]');
                    return lazyLoadChild.length <= 0;
                });
            },

            clickImportAllHandler: function() {
                const $this = this;
                const loadLazyProducts = function () {
                    return new Promise(function (n) {
                        messagePanel.render(messagePanel.simpleTpl(
                            'Please wait. Extension is scrolling the page to catch all products for mass import... '
                        ));

                        MAHtml.scrollPageTopBottom(300, function () {
                            messagePanel.remove();
                            n();
                        });
                    })
                };
                loadLazyProducts().then(function() {
                    //find div with our products, it has grid style
                    $($this.product_container).children().children().each(async function() {
                        if ($(this).css('display') === 'grid') {
                            let nodes = $this.filterAllLazyLoadedNodes(this.childNodes);
                            if (nodes) {
                                let products = $this.build_products_array(nodes);
                                await MAProduct.pushProductArr(products);
                            }
                        }
                    });
                });
            }
        };
    }

    function MACategoryParser7(ext_options)
    {
        const aliApiClient = new AliExpressAPIClient();

        /**
         * 
         * @param {number} product_id 
         * @returns {shippingInfoDTO} shipping_info_dto
         */
        async function getProductShippingData (product_id)
        {
            let product_shipping_cache = await ShippingCache.getByProductId(
                product_id,
                ext_options.shippingCountry,
                ext_options.shippingCurrency
            );

            if ( product_shipping_cache !== false ) {
                //console.log( `from shipping cache: ${product_id} ${ext_options.shippingCountry} ${ext_options.shippingCurrency}  ${product_shipping_cache.time}` );
                return new shippingInfoDTO(product_id, product_shipping_cache.freight);
            }
            else {
                let shipping_info_dto = new shippingInfoDTO(product_id);
                        
                try {
                    let shipping_data = await aliApiClient.getShippingDataV1(
                        product_id,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );

                    shipping_info_dto = DTOFactory.buildShippingInfoFromAPIResponseV1(product_id, shipping_data);
                    await ShippingCache.set(
                        shipping_info_dto,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );
    
                } catch ( err ) {
                    console.log( err.message );    
                }
                finally {
                    return shipping_info_dto;
                }     
            }
   
        }

        return {
            productIds: [],
            observedProductIds: [],
            processedProductIds: [],
            options: ext_options,
            product_container: '',

            init: async function() {
                await aliApiClient.setAliexpressCurrencyV1(ext_options.shippingCurrency);
                const e = this;

                chrome.runtime.onMessage.addListener(function(t) {

                    if (t.name == config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED) {
                        if (t.status == "OK") {
                            e.processResponseImportedProduct(t.products)
                        } else {
                            /*
                            messagePanel.render({
                                iconClose: chrome.runtime.getURL(config.assets.iconClose),
                                svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                                state: MAProduct.getCheckImportedStateData(t)
                            });
                            */
                        }
                    }

                });

                e.productIds = [];
                e.observedProductIds = [];
                e.processedProductIds = [];

                //1

                e.product_container = document.querySelectorAll( '[class^="list--gallery--"],[class*=" list--gallery--"]' )[0];
                
                let child_nodes = e.product_container.childNodes;

                let p = [...child_nodes].filter(function(el) {
                    return !el.classList.contains("lazy-load") && !el.classList.contains("lazyload-placeholder") && !el.getElementsByClassName( 'lazy-load' ).length;
                } );

                e.fillObservedProductIds(p);
                e.prepareNodes(p);

                let product_cont_class = p[ 0 ].classList[ 0 ];
    
                messagePanel.render( messagePanel.simpleTpl( 'Please wait. Extension is waiting for AliExpress to show shipping data.' ) );
                
                var eo = e;

                main_cont_observer = new MutationObserver(function(e) {
                    e.forEach(function(e) {

                        if ( "childList" === e.type && e.addedNodes.length > 0 )
                        {

                            if ( e.addedNodes[ 0 ].classList.contains(product_cont_class) )
                            {
                                let nodes = [];

                                e.addedNodes.forEach( function ( addedNode )
                                {
                                    let lazy_load_child = addedNode.getElementsByClassName( 'lazy-load' );
                                    if ( !lazy_load_child.length )
                                    {
                                        nodes.push( addedNode );
                                        
                                    }
                                } );
                                
                                if ( nodes.length )
                                {
                                    eo.fillObservedProductIds(nodes); 
                                    eo.prepareNodes(nodes);
                                    
                                 //   messagePanel.render(messagePanel.simpleTpl('Recieved data for ' + eo.observedProductIds.length + ' products. Rendering results...'));    
                                }    
                            } else if( e.addedNodes[ 0 ].classList.contains("product-img"))
                            {
                                let nodes = [];

                                e.addedNodes.forEach( function ( addedNode )
                                {
                     
                                    let product_container_node = addedNode.closest( `.${ product_cont_class }` );
                                    if ( product_container_node instanceof HTMLElement )
                                    {
                                        nodes.push( product_container_node );    
                                    }    
                                } );
                                
                                if ( nodes.length )
                                {
                                    eo.fillObservedProductIds(nodes); 
                                    eo.prepareNodes(nodes);
                                    
                                 //   messagePanel.render(messagePanel.simpleTpl('Recieved data for ' + eo.observedProductIds.length + ' products. Rendering results...'));    
                                }  
                            }
                            
                            /*else
                            {
                                if ( !e.addedNodes[ 0 ].classList.contains( "ma-shipping" ) )
                                {
                              
                                    console.log( e.addedNodes[ 0 ] );    
                                }
                            }*/

                        }
                    })
                });

                main_cont_observer.observe(e.product_container, {
                    attributes: !1,
                    childList: !0,
                    subtree: !0,
                    characterData: !1
                } );


                MAHtml.scrollPageTopBottom(300, function (){
                    messagePanel.remove();
                });
            },

            fillObservedProductIds: function (p){
                let eo = this;

                p.forEach(function (el ){
                    let id = MAProduct.getProductIdFromUrl( el.href );
                    eo.observedProductIds.push( id );
                });         
            },

            /**
             * 
             * @param {Array} e 
             */
            prepareNodes: function (e) {
                  
                var eo = this;

                for (var t = 0; t < e.length; t += 1) {
                    var r = e[t];

                    eo.prepareNode(r);

                }
                
                let uniqueProductIds = [];

                this.productIds.forEach( id =>
                {
                    if ( !this.processedProductIds.includes( id ) )
                    {
                        uniqueProductIds.push( id );
                        this.processedProductIds.push(id)     
                    } 
                } );

                if ( eo.options.showShipping )
                {
                    uniqueProductIds.forEach( async function (product_id)
                    {
                        let shipping_info_dto = await getProductShippingData( product_id );
                        eo.processShippingInfoResponse( shipping_info_dto );    
                    });
                }

                eo.options.markImported && chrome.runtime.sendMessage({
                    action: config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                    ids: eo.productIds
                });

                eo.productIds = [];
            },

            prepareNode: function(e) {
                var t = this,
                    d = t.getProductData(e);

                if (!d) return;
        
                var r = d.id;
                r && ! function() {
                    var n = d.url;
        
                    $(e).css('position', 'relative').css('overflow', 'visible');

                    MAHtml.appendHtml(document, e, MAMessages.categoryPushButton());

                    e.addEventListener("mouseover", function(e) {
                        e.preventDefault();
                        $(this).find(".ma-btn-push-category-product").css("display", "block");
                    })

                    e.addEventListener("mouseout", function(e) {
                        e.preventDefault();
                        $(this).find(".ma-btn-push-category-product").css("display", "none");
                    })

                    var i = e.querySelector(".ma-btn-push-category-product");
                    i && i.addEventListener("click", function(e) {
                        e.preventDefault();

                        var params = { 'id': r };
                        var reqId = Math.random().toString();
                        var data = { params, "reqId": reqId };

                        MAProduct.requestProductInfo(data.params, data.reqId, function(e) {

                            var responseData = { "status": e.status, "data": e.data, "error_msg": e.error_msg, "reqId": e.reqId };

                            MAProduct.pushProduct(n, r, d.thumb, d.price_min, d.price_max, d.title, d.currency, responseData.data)
                                .catch(function(e) {
                                    console.log(e);
                                });

                        });

                    }), t.productIds.includes(r) || t.productIds.push(r)
                }()
            },

            getProductData: function(e) {
                var data = { id: false, url: false, thumb: false, price_min: false, price_max: false, title: false, currency: false };

                data.url = e.getAttribute("href");
                
                if (typeof data.url.match === "undefined") return false;

                data.id = MAProduct.getProductIdFromUrl( data.url );

                return data;
            },

            processResponseImportedProduct: function(d) {

                var n = d.filter(function(e) {
                    return e.imported;
                });

                for (var i in n) {

                    let t = this;

                    let product_link = t.product_container.querySelector("a[href*='" + n[i].id + "'");
                    let product_cont = product_link;

                    if (product_cont) {
                        MAHtml.appendHtml(document, product_cont, MAMessages.categoryProductImportedIcon());
                    }
                }

            },

            /**
             * 
             * @param {shippingInfoDTO} shipping_info_dto 
             */
            processShippingInfoResponse: function ( shipping_info_dto )
            {
                let t = this;

                let product_cont = false;

                let product_link = t.product_container.querySelector("a[href*='" + shipping_info_dto.productId + "'");
                let img_el = false;
        
                product_cont = product_link;
                img_el = product_link.firstChild.firstChild;

                if (shipping_info_dto.freight && product_cont && img_el) {
                    t.renderShipping(t.options, shipping_info_dto.freight, product_cont, img_el);
                }
            },

            renderShipping: function(e, t, r, s) {
                messagePanel.remove();

                var eo = this;

                var n = config.shippingOptions.find(function(t) {
                        return t.v === e.shippingOption
                    }),
                    o = n ? n.v : e.shippingOption,
                    i = n ? n.t : e.shippingOption,
                    a = t.find(function(e) {
                        return e.serviceName === o
                    });


                var c = 'large',
                    l = s,
                    f = s.parentElement, //img cont
                    h = f;

                if (a) {

                    var d = a.freightAmount.value > 0 ? a.freightAmount.formatedAmount : "Free";


                    if (f && ($(f).css('border', "3px solid #79c772").css("border-radius", "6% 6% 0 0")), (0, MAHtml.appendHtml)(document, f, eo.renderShippingOptionAvailable(a.company, d, c)), e.showProcessing && typeof a.processingTime !== "undefined" && a.processingTime > 0) {


                        MAHtml.prependHtml(document, h, eo.renderProcessingTime(a.processingTime));
                    }

                    if (a.time && e.showDelivery) {

                        MAHtml.prependHtml(document, h, eo.renderDeliveryTime(a.time));
                    }


                } else if (e.showOnlyActive) r.remove();
                else {


                    var y = f;
                    $(y).css('border', "3px solid #dc6832").css("border-radius", "6% 6% 0 0");

                    MAHtml.prependHtml(document, h, eo.renderNoShippingOptionAvailable(i, c));
                }

                    //fix width and height;
                    d = f.querySelector('.ma-shipping');
                    $(s).css('height', $(d).width()).css('width', $(d).width());
                    $(h).css('height', 'auto');

            },

            renderShippingOptionAvailable: function(e, t, r) {
                return '<div class="ma-shipping has-options ' + r + '"><span>' + e + "</span><span>" + t + "</span></div>"
            },
            renderNoShippingOptionAvailable: function(e, t) {
                return '<div class="ma-shipping no-options ' + t + '"><span>No ' + e + "</span></div>"
            },
            renderProcessingTime: function(e) {
                var t = "Processing time: " + e + " Days";
                return '<div class="ma-processing-time" title="' + t + '">\n                <span class="first">Processing Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },
            renderDeliveryTime: function(e) {
                var t = "Delivery time: " + e + " Days";
                return '<div class="ma-delivery-time" title="' + t + '">\n                <span class="first">Delivery Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },

            build_products_array: function(l) {

                var eo = this,
                    p = [];

                for (var t = 0; t < l.length; t += 1) {
                    var r = l[t];
                    d = eo.getProductData(r);
                    p.push(d);

                }
                return p;
            },

            clickImportAllHandler: function() {

                var eo = this;

                var loadLazyProducts = function() {
                    return new Promise(function(n) {
                        messagePanel.render(messagePanel.simpleTpl('Please wait. Extension is scrolling the page to catch all products for mass import... '));
                        
                        MAHtml.scrollPageTopBottom( 300, function (){
                            messagePanel.remove();
                            n();
                        });
                    })
                }

                loadLazyProducts().then(async function() {
                    let child_nodes = eo.product_container.childNodes;

                    let p = [...child_nodes].filter(function(el) {
                        return !el.classList.contains("lazyload-placeholder");
                    });

                    if (p) {
                        let p = eo.build_products_array(p);
                        await MAProduct.pushProductArr(p);
                    }

                });

            }
        };
    }

    function MACategoryParser8(ext_options) {

        const aliApiClient = new AliExpressAPIClient();

        /**
         *
         * @param {number} product_id
         * @returns {shippingInfoDTO} shipping_info_dto
         */
        async function getProductShippingData (product_id)
        {

            let product_shipping_cache = await ShippingCache.getByProductId(
                product_id,
                ext_options.shippingCountry,
                ext_options.shippingCurrency
            );

            if ( product_shipping_cache !== false )
            {
                //console.log( `from shipping cache: ${product_id} ${ext_options.shippingCountry} ${ext_options.shippingCurrency}  ${product_shipping_cache.time}` );
                let shipping_info_dto = new shippingInfoDTO(product_id, product_shipping_cache.freight);
                return shipping_info_dto;
            }
            else
            {
                let shipping_info_dto = new shippingInfoDTO( product_id );

                try
                {
                    let shipping_data = await aliApiClient.getShippingDataV1(
                        product_id,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );

                    shipping_info_dto = DTOFactory.buildShippingInfoFromAPIResponseV1( product_id, shipping_data );
                    await ShippingCache.set(
                        shipping_info_dto,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );

                } catch ( err )
                {
                    console.log( err.message );
                }
                finally
                {
                    return shipping_info_dto;
                }
            }

        }

        return {
            productIds: [],
            observedProductIds: [],
            options: ext_options,
            product_container: '',
            lazyLoadClass: 'lazy-load',

            init: async function() {
                await aliApiClient.setAliexpressCurrencyV1(ext_options.shippingCurrency);
                const e = this;

                chrome.runtime.onMessage.addListener(function(t) {

                    if (t.name == config.actions.GET_PRODUCTS_SHIPPING_INFO) {

                        e.processShippingInfoResponse(t.data);
                    }

                    if (t.name == config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED) {
                        if (t.status == "OK") {
                            e.processResponseImportedProduct(t.products)
                        } else {
                            /*
                            messagePanel.render({
                                iconClose: chrome.runtime.getURL(config.assets.iconClose),
                                svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                                state: MAProduct.getCheckImportedStateData(t)
                            });
                            */
                        }
                    }

                });

                e.productIds = [];
                e.observedProductIds = [];
                e.processedProductIds = [];

                //1

                e.product_container = document.querySelectorAll( '[class^="list--galleryWrapper"]' )[0];

                let p = e.filterAllLazyLoadedNodes(e.product_container.childNodes);

                e.fillObservedProductIds(p, function(node) {
                    e.prepareNodes([node]);
                });


                let productContainerClassName = p[0].className;
                let productContainerFirstClassName= productContainerClassName.split(/(\s+)/)[0];

                messagePanel.render( messagePanel.simpleTpl( 'Please wait. Extension is waiting for AliExpress to show shipping data.' ) );

                var eo = e;

                let main_cont_observer = new MutationObserver(function (mutationsList) {
                    mutationsList.forEach(function (mutation) {

                        let targetElement = mutation.target;

                        let jqProductContainerNode = $(targetElement).closest('.'+productContainerFirstClassName);

                        if (!jqProductContainerNode.length) {
                            return;
                        }

                        let productContainerNode = jqProductContainerNode[0];


                        let img_el = productContainerNode.querySelector("div[class^='multi--image']");
                        if (!img_el) {
                            return;
                        }

                        eo.fillObservedProductIds([productContainerNode], function(node) {
                            eo.prepareNodes([node]);
                            let msg = 'Received data for '
                                + eo.observedProductIds.length
                                + ' products. Rendering results...';

                            messagePanel.render(
                                messagePanel.simpleTpl(
                                    msg
                                ));
                        });
                    });
                });

                main_cont_observer.observe(e.product_container, {
                    attributes: true,
                    childList: true,
                    subtree: true,
                    characterData: false,
                    attributeOldValue: true,
                    attributeFilter: ["class"],
                } );

                MAHtml.scrollPageTopBottom(300, function (){
                    messagePanel.remove();
                });
            },

            fillObservedProductIds: function (p, callback=null){
                let eo = this;

                p.forEach(function (el){
                    let link_el = el.querySelector("a[href*='/item/']");
                    if (!link_el) {
                        return;
                    }
                    let id = MAProduct.getProductIdFromUrl(link_el.getAttribute("href"));
                    if (!eo.observedProductIds.includes(id)) {
                        eo.observedProductIds.push(id);
                        if (callback) {
                            callback(el);
                        }
                    }
                });
            },
            /**
             *
             * @param {Array} e
             */
            prepareNodes: function (e) {

                const eo = this;

                for (let t = 0; t < e.length; t += 1) {
                    const r = e[t];

                    eo.prepareNode(r);
                }

                let uniqueProductIds = [];

                this.productIds.forEach(id => {
                    if (!this.processedProductIds.includes(id)) {
                        uniqueProductIds.push( id );
                        this.processedProductIds.push(id)
                    }
                });

                if (eo.options.showShipping) {
                    uniqueProductIds.forEach(async function (product_id) {
                        let shipping_info_dto = await getProductShippingData(product_id);
                        eo.processShippingInfoResponse(shipping_info_dto);
                    });
                }

                eo.options.markImported && chrome.runtime.sendMessage({
                    action: config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                    ids: eo.productIds
                });

                eo.productIds = [];

            },

            prepareNode: function(e) {
                var t = this,
                    d = t.getProductData(e);

                if (!d) {
                    return;
                }

                var r = d.id;
                r && ! function() {
                    var n = d.url;

                    $(e).css('position', 'relative').css('overflow', 'visible');

                    MAHtml.appendHtml(document, e, MAMessages.categoryPushButton());

                    e.addEventListener("mouseover", function(e) {
                        e.preventDefault();
                        $(this).find(".ma-btn-push-category-product").css("display", "block");
                    })

                    e.addEventListener("mouseout", function(e) {
                        e.preventDefault();
                        $(this).find(".ma-btn-push-category-product").css("display", "none");
                    })

                    var i = e.querySelector(".ma-btn-push-category-product");
                    i && i.addEventListener("click", function(e) {
                        e.preventDefault();

                        var params = { 'id': r };
                        var reqId = Math.random().toString();
                        var data = { params, "reqId": reqId };

                        MAProduct.requestProductInfo(data.params, data.reqId, function(e) {

                            var responseData = { "status": e.status, "data": e.data, "error_msg": e.error_msg, "reqId": e.reqId };

                            MAProduct.pushProduct(n, r, d.thumb, d.price_min, d.price_max, d.title, d.currency, responseData.data)
                                .catch(function(e) {
                                    console.log(e);
                                });

                        });

                    }), t.productIds.includes(r) || t.productIds.push(r)
                }()
            },

            getProductData: function(e) {
                var data = { id: false, url: false, thumb: false, price_min: false, price_max: false, title: false, currency: false };

                data.url = e.querySelector("a[href*='/item/']").getAttribute("href");

                if (typeof data.url.match === "undefined") return false;

                data.id = MAProduct.getProductIdFromUrl( data.url );

                return data;
            },

            processResponseImportedProduct: function(d) {

                var n = d.filter(function(e) {
                    return e.imported;
                });

                for (var i in n) {

                    let t = this;

                    let product_link = t.product_container.querySelector("a[href*='" + n[i].id + "'");
                    let product_cont = product_link;

                    if (product_cont) {
                        MAHtml.appendHtml(document, product_cont, MAMessages.categoryProductImportedIcon());
                    }
                }

            },

            /**
             * @param {shippingInfoDTO} shipping_info_dto
             */
            processShippingInfoResponse: function(shipping_info_dto) {
                const t = this;
                let img_el = false;
                let product_link = t.product_container.querySelector("a[href*='" + shipping_info_dto.productId + "'");
                let product_cont = product_link.parentElement;
                img_el = product_link.querySelector("div[class^='multi--image']");
                if (shipping_info_dto.freight && product_cont && img_el) {
                    t.renderShipping(t.options, shipping_info_dto.freight, product_cont, img_el);
                }
            },

            renderShipping: function(e, t, r, s) {
                messagePanel.remove();

                const eo = this;

                var n = config.shippingOptions.find(function(t) {
                        return t.v === e.shippingOption
                    }),
                    o = n ? n.v : e.shippingOption,
                    i = n ? n.t : e.shippingOption,
                    a = t.find(function(e) {
                        return e.serviceName === o
                    });


                var c = 'large',
                    l = s,
                    f = s.parentElement, //img cont
                    h = f;

                if (a) {

                    var d = a.freightAmount.value > 0 ? a.freightAmount.formatedAmount : "Free";


                    if (f && ($(f).css('border', "3px solid #79c772").css("border-radius", "6% 6% 0 0")), (0, MAHtml.appendHtml)(document, f, eo.renderShippingOptionAvailable(a.company, d, c)), e.showProcessing && typeof a.processingTime !== "undefined" && a.processingTime > 0) {


                        MAHtml.prependHtml(document, h, eo.renderProcessingTime(a.processingTime));
                    }

                    if (a.time && e.showDelivery) {

                        MAHtml.prependHtml(document, h, eo.renderDeliveryTime(a.time));
                    }


                } else if (e.showOnlyActive) r.remove();
                else {


                    var y = f;
                    $(y).css('border', "3px solid #dc6832").css("border-radius", "6% 6% 0 0");

                    MAHtml.prependHtml(document, h, eo.renderNoShippingOptionAvailable(i, c));
                }

                //fix width and height;
                d = f.querySelector('.ma-shipping');
                $(s).css('height', $(d).width()).css('width', $(d).width());
                $(h).css('height', 'auto');

            },

            renderShippingOptionAvailable: function(e, t, r) {
                return '<div class="ma-shipping has-options ' + r + '"><span>' + e + "</span><span>" + t + "</span></div>"
            },
            renderNoShippingOptionAvailable: function(e, t) {
                return '<div class="ma-shipping no-options ' + t + '"><span>No ' + e + "</span></div>"
            },
            renderProcessingTime: function(e) {
                var t = "Processing time: " + e + " Days";
                return '<div class="ma-processing-time" title="' + t + '">\n                <span class="first">Processing Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },
            renderDeliveryTime: function(e) {
                var t = "Delivery time: " + e + " Days";
                return '<div class="ma-delivery-time" title="' + t + '">\n                <span class="first">Delivery Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },

            build_products_array: function(l) {

                var eo = this,
                    p = [];

                for (var t = 0; t < l.length; t += 1) {
                    var r = l[t];
                    d = eo.getProductData(r);
                    p.push(d);

                }
                return p;
            },

            filterAllLazyLoadedNodes: function(child_nodes) {
                const $this = this;

                return [...child_nodes].filter(function (el) {
                    if (el.classList.contains($this.lazyLoadClass)) {
                        return false;
                    }

                    return true;
                });
            },

            clickImportAllHandler: function() {
                const eo = this;

                const loadLazyProducts = function () {
                    return new Promise(function (n) {
                        messagePanel.render(messagePanel.simpleTpl(
                            'Please wait. Extension is scrolling the page to catch all products for mass import... '
                        ));

                        MAHtml.scrollPageTopBottom(300, function () {
                            messagePanel.remove();
                            n();
                        });
                    })
                };

                loadLazyProducts().then(async function() {
                    let child_nodes = eo.filterAllLazyLoadedNodes(eo.product_container.childNodes);

                    if (child_nodes) {
                        child_nodes = eo.build_products_array(child_nodes);
                        await MAProduct.pushProductArr(child_nodes);
                    }
                });
            }
        };
    }

    function MACategoryParser10(ext_options) {

        const aliApiClient = new AliExpressAPIClient();

        /**
         *
         * @param {number} product_id
         * @returns {shippingInfoDTO} shipping_info_dto
         */
        async function getProductShippingData (product_id)
        {

            let product_shipping_cache = await ShippingCache.getByProductId(
                product_id,
                ext_options.shippingCountry,
                ext_options.shippingCurrency
            );

            if ( product_shipping_cache !== false )
            {
                //console.log( `from shipping cache: ${product_id} ${ext_options.shippingCountry} ${ext_options.shippingCurrency}  ${product_shipping_cache.time}` );
                let shipping_info_dto = new shippingInfoDTO(product_id, product_shipping_cache.freight);
                return shipping_info_dto;
            }
            else
            {
                let shipping_info_dto = new shippingInfoDTO( product_id );

                try
                {
                    let shipping_data = await aliApiClient.getShippingDataV1(
                        product_id,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );

                    shipping_info_dto = DTOFactory.buildShippingInfoFromAPIResponseV1( product_id, shipping_data );
                    await ShippingCache.set(
                        shipping_info_dto,
                        ext_options.shippingCountry,
                        ext_options.shippingCurrency
                    );

                } catch ( err )
                {
                    console.log( err.message );
                }
                finally
                {
                    return shipping_info_dto;
                }
            }

        }

        return {
            productIds: [],
            observedProductIds: [],
            options: ext_options,
            product_container: '',
            lazyLoadClass: 'lazy-load',

            init: async function() {
                await aliApiClient.setAliexpressCurrencyV1(ext_options.shippingCurrency);
                const $this = this;

                chrome.runtime.onMessage.addListener(function(t) {

                    if (t.name == config.actions.GET_PRODUCTS_SHIPPING_INFO) {

                        $this.processShippingInfoResponse(t.data);
                    }

                    if (t.name == config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED) {
                        if (t.status == "OK") {
                            $this.processResponseImportedProduct(t.products)
                        } else {
                            /*
                            messagePanel.render({
                                iconClose: chrome.runtime.getURL(config.assets.iconClose),
                                svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                                state: MAProduct.getCheckImportedStateData(t)
                            });
                            */
                        }
                    }

                });

                $this.productIds = [];
                $this.observedProductIds = [];
                $this.processedProductIds = [];

                //1
                let mainContSelector = '[class^="red-snippet_RedSnippet__grid"]';
                MAFunc.waitForElm(mainContSelector).then((elm) => {
                  

                    $this.product_container = $(elm).get(0);
                    messagePanel.render(
                        messagePanel.simpleTpl(
                            'Please wait. Our extension is waiting for AliExpress to show shipping data.'
                        )
                    );
                 
                    let itemSelector = '[class^="red-snippet_RedSnippet__container"]';
                        MAFunc.waitForElm(itemSelector).then((elm) => {
                            let nodes = document.querySelectorAll(itemSelector);
                            $this.fillObservedProductIds(nodes, function(node) {
                                $this.prepareNodes([node]);
                            });
                        });

                    let mainContainerObserver =
                        new MutationObserver(function (mutationList) {
                            mutationList.forEach(function (mutation) {
                                let condition = mutation.type === "attributes" &&
                                    mutation.oldValue.startsWith('gallery_Gallery__picture');
                                if (condition) {
                                    if (!mutation.target.parentElement) {
                                        return;
                                    }
                                    let node= mutation.target.parentElement.parentElement
                                        .parentElement.parentElement.parentElement.parentElement;

                                    /*let link_el = node.firstChild.firstChild;
                                    let id = MAProduct.getProductIdFromUrl(link_el.href);
                                    */
                                    $this.fillObservedProductIds([node], function(node) {
                                        $this.prepareNodes([node]);
                                    });
                                }
                            })
                        });

                    mainContainerObserver.observe($this.product_container.parentElement, {
                        attributes: true,
                        childList: true,
                        subtree: true,
                        characterData: false,
                        attributeOldValue: true,
                        attributeFilter: ["class"],
                    });

                    let pageWrapperNode =
                        document.querySelector('[class^="SnowSearchWrap_SnowSearchWrap"]')
                    let pageLoaderObserver =  new MutationObserver(function (mutationList) {
                        mutationList.forEach(function (mutation) {

                            let condition = mutation.type === "attributes" &&
                                mutation.oldValue.startsWith('SnowSearchWrap_LoadOverlay__loadOverlayShow');

                            if (condition) {
                                $this.observedProductIds = [];
                                $this.processedProductIds = [];
                                $this.productIds = [];

                                $('.ma-shipping').remove();
                                $('.ma-delivery-time').remove();
                                $('.ma-btn-push-category-product').remove();
                            }

                        })
                    });

                    pageLoaderObserver.observe(pageWrapperNode.parentElement, {
                      /*  attributes: true,*/
                        childList: true,
                        subtree: true,
                        characterData: false,
                        attributeOldValue: true,
                        attributeFilter: ["class"],
                    });

                });
            },

            fillObservedProductIds: function (productNode, callback){
                let $this = this;
                productNode.forEach(function (el){
                    let link_el= el.firstChild.firstChild;
                    let id = MAProduct.getProductIdFromUrl(link_el.href);
                        if (!$this.observedProductIds.includes(id)) {
                            $this.observedProductIds.push(id);
                            if (callback) {
                                callback(el);
                            }
                        }
                });
            },

            /**
             *
             * @param {Array} e
             */
            prepareNodes: function (e) {

                const eo = this;

                for (let t = 0; t < e.length; t += 1) {
                    const r = e[t];

                    eo.prepareNode(r);
                }

                let uniqueProductIds = [];

                this.productIds.forEach( id =>
                {
                    if ( !this.processedProductIds.includes( id ) )
                    {
                        uniqueProductIds.push( id );
                        this.processedProductIds.push(id)
                    }
                } );

                if ( eo.options.showShipping )
                {
                    uniqueProductIds.forEach( async function (product_id)
                    {
                        let shipping_info_dto = await getProductShippingData( product_id );
                        eo.processShippingInfoResponse( shipping_info_dto );
                    });
                }

                eo.options.markImported && chrome.runtime.sendMessage({
                    action: config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                    ids: eo.productIds
                });

                eo.productIds = [];

            },

            prepareNode: function(e) {
                let t = this,
                    d = t.getProductData(e);

                if (!d) return;

                let r = d.id;
                r && ! function() {
                    let n = d.url;

                    $(e).css('position', 'relative').css('overflow', 'visible');

                    MAHtml.appendHtml(document, e, MAMessages.categoryPushButton());

                    e.addEventListener("mouseover", function(e) {
                        e.preventDefault();
                        $(this).find(".ma-btn-push-category-product").css("display", "block");
                    })

                    e.addEventListener("mouseout", function(e) {
                        e.preventDefault();
                        $(this).find(".ma-btn-push-category-product").css("display", "none");
                    })

                    let i = e.querySelector(".ma-btn-push-category-product");
                    i && i.addEventListener("click", function(e) {
                        e.preventDefault();

                        let params = { 'id': r };
                        let reqId = Math.random().toString();
                        let data = { params, "reqId": reqId };

                        MAProduct.requestProductInfo(data.params, data.reqId, function(e) {

                            let responseData = { "status": e.status, "data": e.data, "error_msg": e.error_msg, "reqId": e.reqId };

                            MAProduct.pushProduct(n, r, d.thumb, d.price_min, d.price_max, d.title, d.currency, responseData.data)
                                .catch(function(e) {
                                    console.log(e);
                                });

                        });

                        e.stopPropagation();

                    }), t.productIds.includes(r) || t.productIds.push(r)
                }()
            },

            getProductData: function(e) {
                let data = { id: false, url: false, thumb: false, price_min: false, price_max: false, title: false, currency: false };

                data.url = e.querySelector("a[href*='/item/']").getAttribute("href");

                if (typeof data.url.match === "undefined") return false;

                data.id = MAProduct.getProductIdFromUrl( data.url );

                return data;
            },

            processResponseImportedProduct: function(d) {

                let n = d.filter(function(e) {
                    return e.imported;
                });

                for (let i in n) {

                    let t = this;

                    let product_link = document.querySelector("a[href*='" + n[i].id + "'");
                    let product_cont = product_link.parentElement.parentElement;

                    if (product_cont) {
                        MAHtml.appendHtml(document, product_cont, MAMessages.categoryProductImportedIcon());
                    }
                }

            },

            /**
             * @param {shippingInfoDTO} shipping_info_dto
             */
            processShippingInfoResponse: function(shipping_info_dto) {
                const $this = this;
                let img_el = false;
                let product_link = document.querySelector(
                    "a[href*='" + shipping_info_dto.productId + "'"
                );

                if (!product_link) {
                    console.log(product_link);
                    console.log(shipping_info_dto.productId);
                    return;
                }

                let product_cont = product_link.parentElement.parentElement;
                img_el = product_link.querySelector('[class^="gallery_Gallery__gallery"]');

                if (shipping_info_dto.freight && product_cont && img_el) {
                    $this.renderShipping($this.options, shipping_info_dto.freight, product_cont, img_el);
                }
            },

            renderShipping: function(settings, shippingItems, node, imgNode) {
                messagePanel.remove();

                const $this = this;

                const selectedShipping = config.shippingOptions.find(function(item) {
                    return item.v.toLowerCase() === settings.shippingOption.toLowerCase() ||
                        item.t.toLowerCase() === settings.shippingOption.toLowerCase()
                });

                const selectedShippingValue = selectedShipping ? selectedShipping.v : settings.shippingOption;
                const selectedShippingText = selectedShipping ? selectedShipping.t : settings.shippingOption;
                const shippingData = shippingItems.find(function(item) {
                    return item.serviceName.toLowerCase() === selectedShippingValue.toLowerCase() ||
                        item.serviceName.toLowerCase() === selectedShippingText.toLowerCase()
                });

                let imageClassName = 'large';
                let imgNodeParent = imgNode.parentElement; //img cont
                let otherNode = imgNodeParent;

                if (shippingData) {
                    let shippingCostText = shippingData.freightAmount.value > 0 ?
                        shippingData.freightAmount.formatedAmount : "Free";

                    if (imgNodeParent) {
                        $(imgNodeParent).css('border', "3px solid #79c772")
                            .css("border-radius", "6% 6% 0 0");
                        MAHtml.appendHtml(
                            document, imgNodeParent,
                            $this.renderShippingOptionAvailable(shippingData.company, shippingCostText, imageClassName)
                        );
                        let shouldShowProcessingTime = settings.showProcessing &&
                            typeof shippingData.processingTime !== "undefined" && shippingData.processingTime > 0;
                        if (shouldShowProcessingTime) {
                            MAHtml.prependHtml(
                                document, otherNode, $this.renderProcessingTime(shippingData.processingTime)
                            );
                        }
                    }

                    if (shippingData.time && settings.showDelivery) {
                        MAHtml.prependHtml(document, otherNode, $this.renderDeliveryTime(shippingData.time));
                    }
                } else if (settings.showOnlyActive) {
                    node.remove();
                }
                else {
                    // console.log(shippingItems);
                    $(imgNodeParent).css('border', "3px solid #dc6832")
                        .css("border-radius", "6% 6% 0 0");
                    MAHtml.prependHtml(
                        document, otherNode,
                        $this.renderNoShippingOptionAvailable(selectedShippingText, imageClassName)
                    );
                }

                //fix width and height;
                let shippingNode = imgNodeParent.querySelector('.ma-shipping');
                $(imgNode).css('height', $(shippingNode).width()).css('width', $(shippingNode).width());
                $(otherNode).css('height', 'auto');
            },

            renderShippingOptionAvailable: function(e, t, r) {
                return '<div class="ma-shipping has-options ' + r + '"><span>' + e + "</span><span>" + t + "</span></div>"
            },
            renderNoShippingOptionAvailable: function(e, t) {
                return '<div class="ma-shipping no-options ' + t + '"><span>No ' + e + "</span></div>"
            },
            renderProcessingTime: function(e) {
                var t = "Processing time: " + e + " Days";
                return '<div class="ma-processing-time" title="' + t + '">\n                <span class="first">Processing Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },
            renderDeliveryTime: function(e) {
                var t = "Delivery time: " + e + " Days";
                return '<div class="ma-delivery-time" title="' + t + '">\n                <span class="first">Delivery Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
            },

            build_products_array: function(l) {

                var eo = this,
                    p = [];

                for (var t = 0; t < l.length; t += 1) {
                    var r = l[t];
                    d = eo.getProductData(r);
                    p.push(d);

                }
                return p;
            },

            filterAllLazyLoadedNodes: function(child_nodes) {
                const $this = this;

                return [...child_nodes].filter(function (el) {
                    const lazyLoadChild = el.querySelectorAll('[class^="'+$this.lazyLoadClass+'"]');
                    return lazyLoadChild.length <= 0;
                });
            },

            clickImportAllHandler: function() {
                const $this = this;

                const loadLazyProducts = function () {
                    return new Promise(function (n) {
                        messagePanel.render(messagePanel.simpleTpl(
                            'Please wait. Extension is scrolling the page to catch all products for mass import... '
                        ));

                        MAHtml.scrollPageTopBottom(300, function () {
                            messagePanel.remove();
                            n();
                        });
                    })
                };

                messagePanel.render(messagePanel.simpleTpl(
                    'Please wait. Extension is scrolling the page to catch all products for mass import... '
                ));
                let itemSelector = '[class^="red-snippet_RedSnippet__container"]';
                MAFunc.waitForElm(itemSelector).then(async (elm) => {
                    let nodes = document.querySelectorAll(itemSelector);
                    let productDataArray = $this.build_products_array(nodes);
                    await MAProduct.pushProductArr(productDataArray);
                });
            }
        };
    }

    class MACategoryParser11 extends BaseParser {
        constructor(ext_options) {
            super(ext_options);
            this.productIds = [];
            this.observedProductIds = [];
            this.product_container = '';
            this.lazyLoadClass = 'lazy-load';
            this.paginatorClass = 'comet-pagination';
            this.accumulatedIds = [];
        }

        async init() {
            const $this = this;
            await $this.aliApiClient.setAliexpressCurrencyV1($this.ext_options.shippingCurrency);

            chrome.runtime.onMessage.addListener(function(t) {

                if (t.name === config.actions.GET_PRODUCTS_SHIPPING_INFO) {

                    $this.processShippingInfoResponse(t.data);
                }

                if (t.name === config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED) {
                    if (t.status === "OK") {
                        $this.processResponseImportedProduct(t.products)
                    } else {
                        /*
                        messagePanel.render({
                            iconClose: chrome.runtime.getURL(config.assets.iconClose),
                            svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                            state: MAProduct.getCheckImportedStateData(t)
                        });
                        */
                    }
                }

            });

            $this.productIds = [];
            $this.observedProductIds = [];
            $this.processedProductIds = [];

            let mainContSelector = '[id^="card-list"]';

            MAFunc.waitForElm(mainContSelector).then((elm) => {
                $this.product_container = $(elm)[0];

                let nodes = $this.product_container.querySelectorAll(
                    '.search-item-card-wrapper-gallery'
                );

                $this.fillObservedProductIds(nodes, function(node) {
                    $this.prepareNodes([node]);
                });

                let mainContainerObserver =
                    new MutationObserver(function (mutationList) {
                        mutationList.forEach(function (mutation) {

                            /* let firstLoadCondition = mutation.type === "attributes" &&
                                 mutation.attributeName === 'class' &&
                                 mutation.target.classList.contains('search-item-card-wrapper-gallery');

                             if (firstLoadCondition) {
                                 let node = mutation.target;
                                // console.log(mutation.target);

                                 $this.fillObservedProductIds([node], function(node) {
                                     $this.prepareNodes([node]);
                                 });
                             }


                                     */

                            //console.log(mutation);
                            let ajaxLoadCondition = mutation.type === "attributes" &&
                                mutation.attributeName === 'class' &&
                                mutation.target.classList.contains('card-out-wrapper');

                            if (ajaxLoadCondition) {
                                let node = mutation.target;
                                //  console.log(mutation);
                                $this.fillObservedProductIds([node], function(node) {
                                    $this.prepareNodes([node]);
                                });
                            }

                            let itemImageMutation = mutation.type === "childList" &&
                                mutation.target.classList.contains('na_nc');

                            if (itemImageMutation) {
                                const node = mutation.target.closest(".search-item-card-wrapper-gallery");

                                $this.fillObservedProductIds([node], function(node) {
                                    $this.prepareNodes([node]);
                                });
                            }
                        })
                    });


                mainContainerObserver.observe($this.product_container, {
                    attributes: true,
                    childList: true,
                    subtree: true,
                    characterData: false,
                    attributeOldValue: true,
                    attributeFilter: ["class"],
                });
            });


            MAFunc.waitForElm('.' + $this.paginatorClass).then((elm) => {
                const paginationContainer =  $(elm)[0];

                let paginationContainerObserver = new MutationObserver(
                    function (mutationList) {
                        mutationList.forEach(function (mutation) {

                            let paginatorMutation = mutation.type === "attributes" &&
                                mutation.attributeName === 'class' &&
                                mutation.target.classList.contains('comet-pagination-item-active');

                            if (paginatorMutation) {
                                ShippingUtils.removeAllShippingBlocks();
                                CategoryParserUtils.removeAllPushButtons();
                                $this.observedProductIds = [];
                                $this.shippingPanel.updateState({
                                    text: "Searching for products on this page...",
                                });
                            }
                        });
                    }
                )

                paginationContainerObserver.observe(paginationContainer, {
                    attributes: true,
                    childList: true,
                    subtree: true,
                    characterData: false,
                    attributeOldValue: true,
                    attributeFilter: ["class"],
                });
            });

            this.shippingPanel.render({
                state: { text: "Searching for products on this page..." },
                showProgressLog: false
            });
        }

        fillObservedProductIds(nodes, callback){
            let $this = this;
            nodes.forEach(function (node){
                let link_el = node.querySelector('.search-card-item')
                let id = MAProduct.getProductIdFromUrl(link_el.href);
                if (!$this.observedProductIds.includes(id)) {
                    $this.observedProductIds.push(id);
                    if (callback) {
                        callback(node);
                    }
                }
            });

            const count = $this.observedProductIds.length;
            this.shippingPanel.updateText(
                `Found ${count} products. \n Scroll page to load more or import all.`,
                0
            );
        }

        /**
         *
         * @param {Array} nodes
         */
        prepareNodes(nodes) {
            let $this = this;
            for (const node of nodes) {
                this.prepareNode(node);
            }

            for (const id of this.productIds) {
                if (!this.accumulatedIds.includes(id)) {
                    this.accumulatedIds.push(id);
                }
            }

            this.productIds = [];

            if (this.ext_options.showShipping) {
                clearTimeout(this.collectTimeout);
                this.collectTimeout = setTimeout(() => {
                    $this.runShippingProcessor();
                }, 500);
            }
        }

        async runShippingProcessor() {
            let $this = this;

            if (!this.accumulatedIds.length) return;

            const idsToProcess = [...this.accumulatedIds];
            this.accumulatedIds = [];

            const processor = new ChunkProcessor({
                chunkSize: 20,
                delay: 200,
                onProgress: (done, total) => {
                    const count = $this.observedProductIds.length;
                    $this.shippingPanel.updateState({
                        text: `Found ${count} products. \n Fetching shipping info...`,
                        actions: [{
                            id: 'ma-stop-loading',
                            title: 'Stop Loading',
                            action: () => {
                                processor.abort();
                                this.shippingPanel.updateText(
                                    'Shipping data loading for this batch has been cancelled.',
                                    2000
                                );
                            }
                        }]
                    });
                },
                onError: (err, chunk) => {
                    console.warn(err);
                    $this.shippingPanel.updateText(
                        `Failed to load shipping info for  ${chunk.length} products. Details: ${err.message || err}`,
                        2000
                    );
                }
            });

            await processor.process(idsToProcess, async (productId) => {
                const dto = await $this.getProductShippingData(productId);
                $this.processShippingInfoResponse(dto);
            });

            const count = $this.observedProductIds.length;
            $this.shippingPanel.updateText(
                `Found ${count} products (shipping ready). \n Scroll to load more or import all.`,
                0
            );

            this.ext_options.markImported && chrome.runtime.sendMessage({
                action: config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                ids: idsToProcess
            });
        }

        prepareNode(node) {
            let data = this.getProductData(node);
            if (!data || !data.id) return;

            if (!node.querySelector(".ma-btn-push-category-product")) {
                CategoryParserUtils.refreshPushButton(node, data);
            }

            if (!this.productIds.includes(data.id)) {
                this.productIds.push(data.id)
            }
        }

        getProductData(node) {
            let data = {
                id: false,
                url: false,
                thumb: false,
                price_min: false,
                price_max: false,
                title: false,
                currency: false
            };

            // Try to find standard product link
            let nodeA = node.querySelector("a[href*='/item/']");

            // If not found, try to find bundle link
            if (!nodeA) {
                nodeA = node.querySelector("a[href*='productIds=']");
            }

            if (nodeA) {
                data.url = nodeA.getAttribute("href");
            } else {
                return false;
            }

            if (typeof data.url.match === "undefined") {
                return false;
            }

            data.id = MAProduct.getProductIdFromUrl(data.url);

            return data;
        }

        processResponseImportedProduct(d) {
            let n = d.filter(function(e) {
                return e.imported;
            });

            for (let i in n) {

                let t = this;

                let product_link = t.product_container.querySelector("a[href*='" + n[i].id + "'");
                let product_cont = product_link;

                if (product_cont) {
                    MAHtml.appendHtml(document, product_cont, MAMessages.categoryProductImportedIcon());
                }
            }

        }

        /**
         * @param {shippingInfoDTO} shipping_info_dto
         */
        processShippingInfoResponse(shipping_info_dto) {
            const $this = this;

            //matches either standard product links (.html) or bundle links with productIds
            const selector =
                "a[href*='" + shipping_info_dto.productId + ".html'], " +
                "a[href*='productIds=" + shipping_info_dto.productId + "']";

            const product_link = $this.product_container.querySelector(selector);

            if (product_link) {
                const product_cont = product_link.parentElement;
                const img_el = product_link.firstChild && product_link.firstChild.firstChild;

                if (shipping_info_dto.freight && product_cont && img_el) {
                    $this.renderShipping(
                        $this.ext_options,
                        shipping_info_dto.freight,
                        product_cont,
                        img_el
                    );
                }
            }
        }

        renderShipping(settings, shippingItems, node, imgNode) {
           // messagePanel.remove();

            const $this = this;

            const selectedShipping = config.shippingOptions.find(function(item) {
                return item.v.toLowerCase() === settings.shippingOption.toLowerCase() ||
                    item.t.toLowerCase() === settings.shippingOption.toLowerCase()
            });

            const selectedShippingValue = selectedShipping ? selectedShipping.v : settings.shippingOption;
            const selectedShippingText = selectedShipping ? selectedShipping.t : settings.shippingOption;
            const shippingData = shippingItems.find(function(item) {
                return item.serviceName.toLowerCase() === selectedShippingValue.toLowerCase() ||
                    item.serviceName.toLowerCase() === selectedShippingText.toLowerCase()
            });

            let imageClassName = 'large';
            let imgNodeParent = imgNode.parentElement; //img cont
            let otherNode = imgNodeParent;

            if (shippingData) {
                let shippingCostText = shippingData.freightAmount.value > 0 ?
                    shippingData.freightAmount.formatedAmount : "Free";

                if (imgNodeParent) {
                    $(imgNodeParent).css('border', "3px solid #79c772")
                        .css("border-radius", "6% 6% 0 0");
                    MAHtml.appendHtml(
                        document, imgNodeParent,
                        $this.renderShippingOptionAvailable(shippingData.company, shippingCostText, imageClassName)
                    );
                    let shouldShowProcessingTime = settings.showProcessing &&
                        typeof shippingData.processingTime !== "undefined" && shippingData.processingTime > 0;
                    if (shouldShowProcessingTime) {
                        MAHtml.prependHtml(
                            document, otherNode, $this.renderProcessingTime(shippingData.processingTime)
                        );
                    }
                }

                if (shippingData.time && settings.showDelivery) {
                    MAHtml.prependHtml(document, otherNode, $this.renderDeliveryTime(shippingData.time));
                }
            } else if (settings.showOnlyActive) {
                node.remove();
            }
            else {
                // console.log(shippingItems);
                $(imgNodeParent).css('border', "3px solid #dc6832")
                    .css("border-radius", "6% 6% 0 0");
                MAHtml.prependHtml(
                    document, otherNode,
                    $this.renderNoShippingOptionAvailable(selectedShippingText, imageClassName)
                );
            }

            //fix width and height;
            let shippingNode = imgNodeParent.querySelector('.ma-shipping');
            $(imgNode).css('height', $(shippingNode).width()).css('width', $(shippingNode).width());
            $(otherNode).css('height', 'auto');
        }

        renderShippingOptionAvailable(e, t, r) {
            return '<div class="ma-shipping has-options ' + r + '"><span>' + e + "</span><span>" + t + "</span></div>"
        }
        renderNoShippingOptionAvailable(e, t) {
            return '<div class="ma-shipping no-options ' + t + '"><span>No ' + e + "</span></div>"
        }
        renderProcessingTime(e) {
            const t = "Processing time: " + e + " Days";
            return '<div class="ma-processing-time" title="' + t + '">\n                <span class="first">Processing Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
        }
        renderDeliveryTime(e) {
            const t = "Delivery time: " + e + " Days";
            return '<div class="ma-delivery-time" title="' + t + '">\n                <span class="first">Delivery Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
        }

        build_products_array(nodes) {
            const $this = this;
            let products = [];

            for (let t = 0; t < nodes.length; t += 1) {
                let product = $this.getProductData(nodes[t]);
                if (product) {
                    products.push(product);
                }
            }

            return products;
        }

        //todo: remove this?
        filterAllLazyLoadedNodes(nodes) {
            const $this = this;

            return [...nodes].filter(function (node) {
                const lazyLoadChild = node.querySelectorAll('[class^="'+$this.lazyLoadClass+'"]');
                return lazyLoadChild.length <= 0;
            });
        }

        filterNodesWithItemLinks(nodes) {
            return [...nodes].filter(node => {
                const nodeA = node.querySelector("a[href*='/item/']");
                return nodeA !== null;
            });
        }

        async clickImportAllHandler() {
            const $this = this;
            if (this.ext_options.isPremium) {
                let nodes = $this.filterNodesWithItemLinks($this.product_container.childNodes);
                if (nodes) {
                    let products = $this.build_products_array(nodes);
                    await MAProduct.pushProductArr(products);
                }
            } else {
                this.importPanel.render({
                    state: {
                        text: "Mass import is available in AliNext Premium. Upgrade now to unlock this feature.",
                        iconUrl: config.assets.iconImportError,
                        actions: [
                            {
                                id: "ma-upgrade-premium",
                                title: "Get Premium",
                                action: () => {
                                    chrome.runtime.sendMessage({
                                        action: config.actions.CONTENT_OPEN_PRICING_PAGE
                                    });
                                }
                            }
                        ]
                    },
                    showProgressLog: false
                });
            }
        }
    }

    class MACategoryParser12 extends BaseParser {
        constructor(ext_options) {
            super(ext_options);
            this.productIds = [];
            this.observedProductIds = [];
            this.product_container = '';
            this.lazyLoadClass = 'lazy-load';
            this.paginatorClass = 'comet-pagination';
            this.accumulatedIds = [];

            this.waitForCleaner = false;
            this.collectTimeout = null;
        }

        async init() {
            const $this = this;
            await $this.aliApiClient.setAliexpressCurrencyV1($this.ext_options.shippingCurrency);

            chrome.runtime.onMessage.addListener(function(t) {

                if (t.name === config.actions.GET_PRODUCTS_SHIPPING_INFO) {

                    $this.processShippingInfoResponse(t.data);
                }

                if (t.name === config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED) {
                    if (t.status === "OK") {
                        $this.processResponseImportedProduct(t.products)
                    }
                }

            });

            $this.productIds = [];
            $this.observedProductIds = [];
            $this.processedProductIds = [];

            let mainContSelector = '[class^="cateWaterFall--categoryFallContainer"]';
            MAFunc.waitForElm(mainContSelector).then((elm) => {
                $this.product_container = $(elm)[0];

                let mainContainerObserver =
                    new MutationObserver(function (mutationList) {
                        mutationList.forEach(function (mutation) {

                            if ("childList" === mutation.type && mutation.addedNodes.length > 0) {
                                mutation.addedNodes.forEach(function (addedNode)  {
                                    let condition = addedNode.tagName === 'DIV' && addedNode.parentNode &&
                                        addedNode.parentNode.getAttribute('data-spm') === 'prodcutlist';
                                    if (condition) {
                                        $this.fillObservedProductIds([addedNode], function(node) {
                                            $this.prepareNodes([node]);
                                        });
                                    }
                                });
                            }
                        });
                    });

                mainContainerObserver.observe($this.product_container, {
                    attributes: true,
                    childList: true,
                    subtree: true,
                    characterData: false,
                    attributeOldValue: true,
                    attributeFilter: ["class"],
                } );
            });

            this.shippingPanel.render({
                state: { text: "Searching for products on this page..." },
                showProgressLog: false
            });
        }

        fillObservedProductIds(nodes, callback){
            let $this = this;
            nodes.forEach(function (node){
                let link_el = node.querySelector('a');
                if (link_el) {
                    let id = MAProduct.getProductIdFromUrl(link_el.href);
                    if (!$this.observedProductIds.includes(id)) {
                        $this.observedProductIds.push(id);
                    }
                    if (callback) {
                        callback(node);
                    }
                }
            });

            const count = $this.observedProductIds.length;
            this.shippingPanel.updateText(
                `Found ${count} products. \n Scroll page to load more or import all.`,
                0
            );
        }

        prepareNodes(nodes) {
            const $this = this;
            for (const node of nodes) {
                this.prepareNode(node);
            }

            for (const id of this.productIds) {
                if (!this.accumulatedIds.includes(id)) {
                    this.accumulatedIds.push(id);
                }
            }

            this.productIds = [];

            clearTimeout(this.collectTimeout);
            this.collectTimeout = setTimeout(() => {
                $this.runShippingProcessor();
            }, 500);
        }

        async runShippingProcessor() {
            const $this = this;

            if (!$this.accumulatedIds.length || !$this.ext_options.showShipping) return;

            const idsToProcess = [...this.accumulatedIds];
            this.accumulatedIds = [];

            const processor = new ChunkProcessor({
                chunkSize: 15,
                delay: 200,
                onProgress: (done, total) => {
                    const count = $this.observedProductIds.length;
                    $this.shippingPanel.updateState({
                        text: `Found ${count} products. \n Fetching shipping info...`,
                        actions: [{
                            id: 'ma-stop-loading',
                            title: 'Stop Loading',
                            action: () => {
                                processor.abort();
                                this.shippingPanel.updateText(
                                    'Shipping data loading for this batch has been cancelled.',
                                    2000
                                );
                            }
                        }]
                    });
                },
                onError: (err, chunk) => {
                    console.warn(err);
                    $this.shippingPanel.updateText(
                        `Failed to load shipping info for  ${chunk.length} products. Details: ${err.message || err}`,
                        2000
                    );
                }
            });

            await processor.process(idsToProcess, async (productId) => {
                const dto = await $this.getProductShippingData(productId);
                $this.processShippingInfoResponse(dto);
            });

            const count = $this.observedProductIds.length;
            $this.shippingPanel.updateText(
                `Found ${count} products (shipping ready). \n Scroll to load more or import all.`,
                0
            );

            $this.ext_options.markImported && chrome.runtime.sendMessage({
                action: config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                ids: idsToProcess
            });
        }

        prepareNode(node) {
            const data = this.getProductData(node);
            if (!data || !data.id) return;

            if (!node.querySelector(".ma-btn-push-category-product")) {
                CategoryParserUtils.addPushButton(node, data);
            }

            //ignore duplicates within one set
            if (!this.productIds.includes(data.id)) {
                this.productIds.push(data.id);
            }
        }

        getProductData(node) {
            let data = {
                id: false,
                url: false,
                thumb: false,
                price_min: false,
                price_max: false,
                title: false,
                currency: false
            };

            let nodeA = node.querySelector("a[href*='/item/']");

            if (nodeA) {
                data.url = nodeA.getAttribute("href");
            } else {
                return false;
            }

            if (typeof data.url.match === "undefined") {

                return false;
            }

            data.id = MAProduct.getProductIdFromUrl(data.url);

            return data;
        }

        processResponseImportedProduct(d) {
            let n = d.filter(function(e) {
                return e.imported;
            });

            for (let i in n) {

                let t = this;

                let product_cont = t.product_container.querySelector("a[href*='" + n[i].id + "'");

                if (product_cont) {
                    MAHtml.appendHtml(document, product_cont, MAMessages.categoryProductImportedIcon());
                }
            }

        }

        /**
         * @param {shippingInfoDTO} shipping_info_dto
         */
        processShippingInfoResponse(shipping_info_dto) {
            const $this = this;

            let product_link = $this.product_container.querySelector(
                "a[href*='" + shipping_info_dto.productId + "'"
            );
            let product_cont = product_link.parentElement;
            let img_el = product_link.firstChild.firstChild;

            if (shipping_info_dto.freight && product_cont && img_el) {
                CategoryParserUtils.renderShipping(
                    $this.ext_options, shipping_info_dto.freight, product_cont, img_el
                );
            }
        }

        build_products_array(nodes) {
            const $this = this;
            let products = [];

            for (let t = 0; t < nodes.length; t += 1) {
                let product = $this.getProductData(nodes[t]);
                if (product) {
                    products.push(product);
                }
            }

            return products;
        }

        //todo: remove this?
        filterAllLazyLoadedNodes(nodes) {
            const $this = this;

            return [...nodes].filter(function (node) {
                const lazyLoadChild = node.querySelectorAll('[class^="'+$this.lazyLoadClass+'"]');
                return lazyLoadChild.length <= 0;
            });
        }

        filterNodesWithItemLinks(nodes) {
            return [...nodes].filter(node => {
                const nodeA = node.querySelector("a[href*='/item/']");
                return nodeA !== null;
            });
        }

        async clickImportAllHandler() {
            const $this = this;

            if (this.ext_options.isPremium) {
                let nodes = $this.filterNodesWithItemLinks($this.product_container.childNodes[0].childNodes);
                if (nodes) {
                    let products = $this.build_products_array(nodes);
                    await MAProduct.pushProductArr(products);
                }
            } else {
                this.importPanel.render({
                    state: {
                        text: "Mass import is available in AliNext Premium. Upgrade now to unlock this feature.",
                        iconUrl: config.assets.iconImportError,
                        actions: [
                            {
                                id: "ma-upgrade-premium",
                                title: "Get Premium",
                                action: () => {
                                    chrome.runtime.sendMessage({
                                        action: config.actions.CONTENT_OPEN_PRICING_PAGE
                                    });
                                }
                            }
                        ]
                    },
                    showProgressLog: false
                });
            }
        }
    }

    class MACategoryParserSwiper extends BaseParser
    {
        constructor(ext_options) {
            super(ext_options);
            this.productIds = [];
            this.observedProductIds = [];
            this.product_container = '';
            this.lazyLoadClass = 'lazy-load';

            this.waitForCleaner = false;
            this.processedProductIds = [];
            this.isProcessing = false;
            this.slideProductNodes = [];
        }

        async init() {
            const $this = this;
            await $this.aliApiClient.setAliexpressCurrencyV1($this.ext_options.shippingCurrency);

            let slideObserver = null;

            const handleSlide = async (slide) => {
                if (!slide || $this.isProcessing) return;
                $this.isProcessing = true;

                try {
                    let productNodes = $this.extractProductNodes(slide);

                    if (productNodes.length) {
                        await $this.prepareNodes(productNodes);
                    } else {
                        productNodes = $this.extractProductNodesV2(slide);
                        if (productNodes.length) {
                            await $this.prepareNodes(productNodes);
                        }
                    }

                    $this.slideProductNodes = productNodes;
                } catch (e) {
                    console.error('Error in prepareNodes:', e);
                } finally {
                    $this.isProcessing = false;
                }
            };

            const observeNewSlide = (newSlide) => {
                if (slideObserver) {
                    slideObserver.disconnect();
                }

                handleSlide(newSlide);

                slideObserver = new MutationObserver((mutations) => {
                    mutations.forEach(mutation => {
                        if (mutation.type === 'childList' && mutation.addedNodes.length > 0) {
                            mutation.addedNodes.forEach(node => {
                                if (node.nodeType !== node.ELEMENT_NODE || node.nodeName !== 'DIV') {
                                    return;
                                }

                                const targetClasses = [
                                    'ma-shipping',
                                    'ma-delivery-time',
                                    'ma-btn-push-category-product',
                                    'AIC-quickView'
                                ];
                                const nodeClasses = Array.from(node.classList);
                                const hasAnyClass = targetClasses.some(cls => nodeClasses.includes(cls));

                                if (hasAnyClass) {
                                    return;
                                }

                                handleSlide(newSlide);
                            });
                        }
                    });
                });

                slideObserver.observe(newSlide, {
                    childList: true,
                    subtree: true,
                });
            }

            MAFunc.waitForElm('.swiper-wrapper').then((wrapper) => {
                $this.product_container = wrapper;

                // wait for .swiper-slide-active on initial page load
                MAFunc.waitForElm('.swiper-slide-active').then((activeSlide) => {

                    this.shippingPanel.render({
                        state: { text: "Searching for products on this page..." },
                        showProgressLog: false
                    });
                    this.observedProductIds = [];
                    //here we have active slide 100%
                    observeNewSlide(activeSlide);

                    //then observe all slides to see slide change event
                    const observer = new MutationObserver(mutations => {
                        mutations.forEach(mutation => {
                            if (
                                mutation.type === 'attributes' &&
                                mutation.attributeName === 'class'
                            ) {
                                const node = mutation.target;
                                let isActiveSlideChanged = node.classList.contains('swiper-slide-active')
                                    && mutation.oldValue === "swiper-slide swiper-slide-active";
                                if (isActiveSlideChanged) {
                                    observeNewSlide(node);
                                }
                            }
                        });
                    });

                    document.querySelectorAll('.swiper-slide').forEach(slide => {
                        observer.observe(slide, { attributes: true, attributeOldValue: true });
                    });

                    let isScrolling;
                    window.addEventListener('scroll', () => {
                        clearTimeout(isScrolling);

                        isScrolling = setTimeout(() => {
                            let currentSlide = wrapper.querySelector('.swiper-slide.swiper-slide-active');
                            handleSlide(currentSlide);
                        }, 350);
                    });
                });
            });
        }

        extractProductNodes(slide) {
            const nodes = [];
            const indexBlocks = slide.querySelectorAll('[data-index]');

            indexBlocks.forEach(indexBlock => {
                const links = indexBlock.querySelectorAll('a[href*="/item/"]');
                links.forEach(link => {
                    const node = link.closest('div');
                    if (node) nodes.push(node);
                });
            });

            return CategoryParserUtils.filterAllLazyLoadedNodes(nodes, this.lazyLoadClass);
        }

        extractProductNodesV2(slide) {
            return slide.querySelectorAll('.productContainer');
        }

        fillObservedProductIds(nodes, callback) {
            const $this = this;
            nodes.forEach(node => {
                const productData = $this.getProductData(node);
                const id = productData.id;
                if (id) {
                    if (!this.observedProductIds.includes(id)) {
                        this.observedProductIds.push(id);
                    }
                    if (callback) callback(node, productData);
                }
            });
        }

        async prepareNodes(nodes) {
            const $this = this;

            $this.fillObservedProductIds(nodes, function(node, productData) {
                $this.prepareNode(node, productData)
            });

            if ($this.ext_options.showShipping) {
                const processor = new ChunkProcessor({
                    chunkSize: 20,
                    delay: 200,
                    onProgress: (done, total) => {
                        const count = $this.observedProductIds.length;
                        $this.shippingPanel.updateState({
                            text: `Found ${count} products. \n Fetching shipping info...`,
                            actions: [{
                                id: 'ma-stop-loading',
                                title: 'Stop Loading',
                                action: () => {
                                    processor.abort();
                                    this.shippingPanel.updateText(
                                        'Shipping data loading for this batch has been cancelled.',
                                        2000
                                    );
                                }
                            }]
                        });
                    },
                    onError: (err, chunk) => {
                        console.warn(err);
                        $this.shippingPanel.updateText(
                            `Failed to load shipping info for  ${chunk.length} products. Details: ${err.message || err}`,
                            2000
                        );
                    }
                });

                await processor.process($this.productIds, async (productId) => {
                    const dto = await $this.getProductShippingData(productId);
                    $this.processShippingInfoResponse(dto);
                });
            }

            if ($this.ext_options.markImported) {
                chrome.runtime.sendMessage({
                    action: config.actions.CONTENT_CHECK_PRODUCTS_IMPORTED,
                    ids: $this.productIds
                });
            }

            const count = $this.observedProductIds.length;
            $this.shippingPanel.updateText(
                `Found ${count} products (shipping ready). \n Scroll to load more or import all.`,
                0
            );

            $this.productIds = [];
        }

        prepareNode(node, productData) {
            const data = productData;
            if (!data || !data.id) return;

            if (!node.parentElement.querySelector(".ma-btn-push-category-product")) {
                CategoryParserUtils.addPushButton(node.parentElement, data);
            }

            //ignore duplicates within one set
            if (!this.productIds.includes(data.id)) {
                this.productIds.push(data.id);
            }
        }

        getFirstValidIdFromNode(node) {
            if (node.id && /^[0-9]{10,}$/.test(node.id)) {
                return node.id;
            }

            const allIdElements = node.querySelectorAll('[id]');
            for (let el of allIdElements) {
                const currentId = el.id;
                if (currentId && /^[0-9]{10,}$/.test(currentId)) {
                    return currentId;
                }
            }

            return false;
        }

        getProductData(node) {

            let id = '';
            const link = node.querySelector("a[href*='/item/']");
            const url = link ? link.getAttribute("href") : '';

            if (!link || !url?.match) {
                id = this.getFirstValidIdFromNode(node);
                if (!id) {
                    return false;
                }
            } else {
                id = MAProduct.getProductIdFromUrl(url);
            }

            return {
                id: id,
                url: url,
                thumb: false,
                price_min: false,
                price_max: false,
                title: false,
                currency: false
            };
        }

        processShippingInfoResponse(dto) {
            const link = this.product_container.querySelector(`a[href*='${dto.productId}']`);
            let node = '';
            let imgNode = '';

            if (!link) {
                if (!/^\d+$/.test(dto.productId)) {
                    return null;
                }

                const targetNode = this.product_container.querySelector(`[id*="${dto.productId}"]`);
                if (!targetNode) {
                    return null;
                }

                node = targetNode.closest('.productContainer');
                imgNode = node.querySelector('img');

            } else {
                node = link.closest('div').parentElement;
                imgNode = link.querySelector('img');
            }

            if (!node) {
                return null;
            }

            //check if shipping was already added
            if (node.querySelector('.ma-shipping')) {
                return;
            }

            if (dto.freight && node && imgNode) {
                CategoryParserUtils.renderShipping(this.ext_options, dto.freight, node, imgNode);
            }
        }

        build_products_array(nodes) {
            const $this = this;
            let products = [];

            for (let t = 0; t < nodes.length; t += 1) {
                let product = $this.getProductData(nodes[t]);
                if (product) {
                    products.push(product);
                }
            }

            return products;
        }

        filterNodesWithIdOrItemLinks(nodes) {
            return [...nodes].filter(node => {
                const hasId = node.hasAttribute("id");
                const hasItemLink = node.querySelector("a[href*='/item/']") !== null;
                return hasId || hasItemLink;
            });
        }

        async clickImportAllHandler() {
            const $this = this;
            if (this.ext_options.isPremium) {
                let nodes = $this.filterNodesWithIdOrItemLinks($this.slideProductNodes);
                if (nodes) {
                    let products = $this.build_products_array(nodes);
                    await MAProduct.pushProductArr(products);
                }
            } else {
                this.importPanel.render({
                    state: {
                        text: "Mass import is available in AliNext Premium. Upgrade now to unlock this feature.",
                        iconUrl: config.assets.iconImportError,
                        actions: [
                            {
                                id: "ma-upgrade-premium",
                                title: "Get Premium",
                                action: () => {
                                    chrome.runtime.sendMessage({
                                        action: config.actions.CONTENT_OPEN_PRICING_PAGE
                                    });
                                }
                            }
                        ]
                    },
                    showProgressLog: false
                });
            }
        }
    }

    const ShippingUtils = {
        removeAllShippingBlocks: function() {
            document.querySelectorAll('.ma-shipping').forEach(el => el.remove())
        }
    };

    const CategoryParserUtils = {
        refreshPushButton: function (node, data) {
            const existingBtn = node.querySelector(".ma-btn-push-category-product");
            if (existingBtn) {
                existingBtn.remove();
            }

            CategoryParserUtils.addPushButton(node, data);
        },

        removeAllPushButtons: function() {
            document.querySelectorAll('.ma-btn-push-category-product').forEach(el => el.remove())
        },

        addPushButton: function(node, data) {
            $(node).css({ position: 'relative', overflow: 'visible' });
            MAHtml.appendHtml(document, node, MAMessages.categoryPushButton());

            node.addEventListener("mouseover", () => {
                $(node).find(".ma-btn-push-category-product").css({
                    visibility: "visible",
                    pointerEvents: "auto",
                    opacity: 1
                });
            });
            node.addEventListener("mouseout", () => {
                $(node).find(".ma-btn-push-category-product").css({
                    visibility: "hidden",
                    pointerEvents: "none",
                    opacity: 0
                });
            });

            const pushBtn = node.querySelector(".ma-btn-push-category-product");
            if (pushBtn) {
                pushBtn.addEventListener("click", (e) => {
                    e.preventDefault();
                    const reqId = Math.random().toString();
                    MAProduct.requestProductInfo({ id: data.id }, reqId, (resp) => {
                        MAProduct.pushProduct(
                            data.url, data.id, data.thumb, data.price_min,
                            data.price_max, data.title, data.currency, resp.data
                        ).catch(console.log);
                    });
                    e.stopPropagation();
                });
            }
        },

        filterAllLazyLoadedNodes: function(nodes, lazyLoadClass) {
            return [...nodes].filter(function(node) {
                const lazyChilds = node.querySelectorAll('[class^="' + lazyLoadClass + '"]');
                return lazyChilds.length <= 0;
            });
        },

        renderShipping: function(settings, shippingItems, node, imgNode) {
            const $this = this;

            const selectedShipping = config.shippingOptions.find(function(item) {
                return item.v.toLowerCase() === settings.shippingOption.toLowerCase() ||
                    item.t.toLowerCase() === settings.shippingOption.toLowerCase()
            });

            const selectedShippingValue = selectedShipping ? selectedShipping.v : settings.shippingOption;
            const selectedShippingText = selectedShipping ? selectedShipping.t : settings.shippingOption;
            const shippingData = shippingItems.find(function(item) {
                return item.serviceName.toLowerCase() === selectedShippingValue.toLowerCase() ||
                    item.serviceName.toLowerCase() === selectedShippingText.toLowerCase()
            });

            let imageClassName = 'large';
            let imgNodeParent = imgNode.parentElement; //img cont
            let otherNode = imgNodeParent;

            if (shippingData) {
                let shippingCostText = shippingData.freightAmount.value > 0 ?
                    shippingData.freightAmount.formatedAmount : "Free";

                if (imgNodeParent) {
                    $(imgNodeParent).css('border', "3px solid #79c772")
                        .css("border-radius", "6% 6% 0 0");
                    MAHtml.appendHtml(
                        document, imgNodeParent,
                        $this.renderShippingOptionAvailable(shippingData.company, shippingCostText, imageClassName)
                    );
                    let shouldShowProcessingTime = settings.showProcessing &&
                        typeof shippingData.processingTime !== "undefined" && shippingData.processingTime > 0;
                    if (shouldShowProcessingTime) {
                        MAHtml.prependHtml(
                            document, otherNode, $this.renderProcessingTime(shippingData.processingTime)
                        );
                    }
                }

                if (shippingData.time && settings.showDelivery) {
                    MAHtml.prependHtml(document, otherNode, $this.renderDeliveryTime(shippingData.time));
                }
            } else if (settings.showOnlyActive) {
                node.remove();
            }
            else {
                // console.log(shippingItems);
                $(imgNodeParent).css('border', "3px solid #dc6832")
                    .css("border-radius", "6% 6% 0 0");
                MAHtml.prependHtml(
                    document, otherNode,
                    $this.renderNoShippingOptionAvailable(selectedShippingText, imageClassName)
                );
            }

            //fix width and height;
            let shippingNode = imgNodeParent.querySelector('.ma-shipping');
            $(imgNode).css('height', $(shippingNode).width()).css('width', $(shippingNode).width());
            $(otherNode).css('height', 'auto');
        },

        renderShippingOptionAvailable: function(e, t, r) {
            return '<div class="ma-shipping has-options ' + r + '"><span>' + e + "</span><span>" + t + "</span></div>"
        },
        renderNoShippingOptionAvailable: function(e, t) {
            return '<div class="ma-shipping no-options ' + t + '"><span>No ' + e + "</span></div>"
        },
        renderProcessingTime: function(e) {
            var t = "Processing time: " + e + " Days";
            return '<div class="ma-processing-time" title="' + t + '">\n                <span class="first">Processing Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
        },
        renderDeliveryTime: function(e) {
            var t = "Delivery time: " + e + " Days";
            return '<div class="ma-delivery-time" title="' + t + '">\n                <span class="first">Delivery Time</span>\n                <span class="last">' + e + " Days</span>\n            </div>"
        },
    };

    class ChunkProcessor {
        constructor({ chunkSize = 10, delay = 300, onProgress = null, onError = null }) {
            this.chunkSize = chunkSize;
            this.delay = delay;
            this.onProgress = onProgress;
            this.onError = onError;
            this.abortController = new AbortController();
        }

        async process(items, handler) {
            const signal = this.abortController.signal;

            for (let i = 0; i < items.length; i += this.chunkSize) {
                if (signal.aborted) {
                    break;
                }

                const chunk = items.slice(i, i + this.chunkSize);

                try {
                    await Promise.all(
                        chunk.map(item => handler(item, signal))
                    );
                } catch (err) {
                    if (this.onError) this.onError(err, chunk);
                }

                if (this.onProgress) this.onProgress(i + chunk.length, items.length);
                await this._pause(this.delay);
            }
        }

        abort() {
            this.abortController.abort();
        }

        _pause(ms) {
            return new Promise(resolve => setTimeout(resolve, ms));
        }
    }


    config.get_ext_options(function(data) {
        let page = MACategoryPage(data);
        setTimeout(() => page.init(), 300);
    });

}());