//chrome.runtime.sendMessage({clicked : true});

jQuery(function($) {

    $.each(config.shippingOptions, function(i,o) {
        $('#shipping-option')
            .append($("<option></option>")
                .attr("value",o.v)
                .text(o.t));
    });

    $.each(config.shippingCountries, function(i,o) {
        $('#shipping-country')
            .append($("<option></option>")
                .attr("value",o.v)
                .text(o.t));
    });

    $.each(config.shippingCurrencies, function(i,o) {
        $('#shipping-currency')
            .append($("<option></option>")
                .attr("value",o)
                .text(o));
    });

    config.get_ext_options(function(data) {
        ext_options = data;
console.log(ext_options);
        if (!ext_options.showShipping) {
            $(".ali2woo-panel-setting-content").not(":first-child").hide();
            $(".ali2woo-panel-setting-details").hide();
            $('html').height($("ali2woo-panel").height());
        }

        $( '#show-shipping' ).prop('checked', ext_options.showShipping);
        $( '#shipping-option' ).val(ext_options.shippingOption);
        $( '#shipping-country' ).val(ext_options.shippingCountry);
        $( '#shipping-currency' ).val(ext_options.shippingCurrency);
        $( '#show-only-active' ).prop('checked', ext_options.showOnlyActive);
      //  $( '#show-processing' ).prop('checked', ext_options.showProcessing);
        $( '#show-delivery' ).prop('checked', ext_options.showDelivery);
        $( '#mark-imported' ).prop('checked', ext_options.markImported);


    });

    $('#show-shipping').click(function(){
        if( $(this).is(':checked') ){
            $(".ali2woo-panel-setting-content").not(":first-child").show();
            $(".ali2woo-panel-setting-details").show();
        } else {
            $(".ali2woo-panel-setting-content").not(":first-child").hide();
            $(".ali2woo-panel-setting-details").hide();
            $('html').height($("ali2woo-panel").height());
        }
    });

    $('.ali2woo-btn-primary').click(function(){

        chrome.storage.sync.set({
            showShipping: $( '#show-shipping' ).prop('checked'),
            shippingOption: $( '#shipping-option' ).val(),
            shippingCountry: $( '#shipping-country' ).val(),
            shippingCurrency: $( '#shipping-currency' ).val(),
            showOnlyActive: $( '#show-only-active' ).prop('checked'),
           /* showProcessing: $( '#show-processing' ).prop('checked'),*/
            showDelivery : $( '#show-delivery' ).prop('checked'),
            markImported: $( '#mark-imported' ).prop('checked'),

        }, function() {
            chrome.tabs.query({active: true, currentWindow: true}, function(tabs) {
                chrome.tabs.update(tabs[0].id, {url: tabs[0].url});
                window.close();
            });
        })

    });
});


 
    