jQuery(function ($) {

    var count = 0;

    function updateCounter() {
        $('.count').text(count);
        var deleteButton = $('.clear-all');
        if (count === 0) {
            deleteButton.attr('disabled', 'disabled').addClass('disabled');
        }
        else {
            deleteButton.removeAttr('disabled').removeClass('disabled');
        }
    }

    var saveStore = function (id, content, f) {

        var id = id;

        config.get_ext_options(function (data) {

            if (id !== null && id in data.stores) {
                data.stores[id] = content;

                if (typeof content.value_api_key !== "undefined") {
                    data.stores[id].value_api_key = content.value_api_key;
                }

                if (typeof content.tracking_autosync !== "undefined") {
                    data.stores[id].tracking_autosync = content.tracking_autosync;
                }

            } else {
                id = data.stores.push(content) - 1;
            }

            chrome.storage.sync.set({ stores: data.stores }, function () { f(id) });
        });

    };

    var test_connection = function () {
        MA_Auth.testConnection(function (e) {

        })
    }

    var editStore = function (id) {
        var store = $('#store' + id),
            html_actions = store.find('.actions');

        var edit_button = store.find('.edit-button');

        store.find('input').each(function () { $(this).prop("disabled", false) });

        store.find('.value_api_key').focus();
        edit_button.after($('<button />', {
            "class": "icon-save save-button",
            click: function () {

                store.find('input').each(function () { $(this).prop("disabled", true) });

                var content = Object.create(null);

                content.value_api_key = store.find('.value_api_key').val();


                if (validateStore(content)) {
                    // content.value_domain = normalizeStoreUrl(content.value_domain); 

                    var saved = $('.save-notification');

                    config.get_ext_options(function (data) {
                        var active_id = data.active_store;

                        saveStore(id, content, function (id) {
                            if (active_id == id) setActiveStore(id);

                            saved.show();

                            setTimeout(function () {
                                saved.hide();
                            }, 2000);

                            store.find('.save-button').remove();
                            /* var edit_button = store.find('.edit-button'); */
                            edit_button.show();
                            edit_button.addClass('icon-pencil');

                            html_actions.find('.delete-button').prop('disabled', false);
                            html_actions.find('.active-button').prop('disabled', false);
                        })


                    });
                }

            }


        }));
    };


    var deleteStore = function (id) {

        config.get_ext_options(function (data) {

            var deleted = $('.delete-notification');
            deleted.show();

            delete data.stores[id];
            chrome.storage.sync.set({ stores: data.stores }, function () {
                setTimeout(function () {
                    deleted.hide();
                }, 2000);
            });
        });
        count--;
        updateCounter();
    };

    var checkNullStores = function (s, f) {

        for (var key in s) {
            var content = s[key];
            if (content == null) {
                s.splice(key, 1);
                checkNullStores(s, f);
            }

        }

        chrome.storage.sync.set({ stores: s }, function () { f(s) });
    }

    var removeStore = function (id) {
        var item = $('#store' + id);

        config.get_ext_options(function (data) {
            var active_id = data.active_store;

            if (active_id == id) setActiveStore(false);
            item.addClass('removed-item')
                .one('webkitAnimationEnd oanimationend msAnimationEnd animationend', function (e) {
                    $(this).remove();
                });

            deleteStore(id);
        });

    };

    var createStore = function (id, content, index) {

        var fields = '<tr  id="store' + id + '" class="values"><td><input type="text" class="value_api_key" value="' + content.value_api_key + '" disabled></td></tr>';
        //var store = '<table id="store' + id + '">' + fields + '</table>';
        var store = fields;

        if (!$('#store' + id).length) {

            $('.stores').append($(store).addClass('new-item'));


            var createdItem = $('#store' + id);


            var html_actions = $('<td>').appendTo(createdItem);

            html_actions = $('<div>').addClass('actions').appendTo(html_actions);

            /*
            html_actions.append($('<button />', {
                "class": "icon-spinner autosync-button",
                "contenteditable": "false",
                "title": "shipment tracking auto-sync",
                click: function () {

                    var el_node = $(this);

                    switchStoreAutoTracking(id).then(function (tracking_autosync) {

                        $('.stores').find('.icon-spinner').each(function () {
                            $(this).removeClass('active');
                        });

                        if (tracking_autosync) {
                            el_node.addClass("active");
                        }

                    }).catch(function (e) {
                        alert(e);
                    });

                }
            }));
            */
            html_actions.append($('<button />', {
                "class": "icon-trash delete-button",
                "contenteditable": "false",
                "title": "delete the store`s connection",
                click: function () {
                    var confirmation = confirm('Delete this item?');
                    if (confirmation) {
                        removeStore(id);
                    }
                }
            }));

            html_actions.append($('<button />', {
                "class": "icon-pencil edit-button",
                "contenteditable": "false",
                "title": "edit connection key",
                click: function () {
                    //  createdItem.attr('contenteditable', 'true');
                    createdItem.find('li').each(function () { $(this).attr('contenteditable', 'true') });

                    html_actions.find('.active-button').prop('disabled', true);
                    html_actions.find('.delete-button').prop('disabled', true);

                    editStore(id);
                    $(this).hide();

                    $(this).removeClass('icon-pencil');

                }
            }));


            var active_btn_class_string = "icon-check-empty active-button";
            if (typeof content.value_active !== "undefined" && content.value_active === 1) {
                active_btn_class_string = "icon-check active-button";
            }

            html_actions.append($('<button />', {
                "class": active_btn_class_string,
                "contenteditable": "false",
                click: function () {



                    //remove 'active store' icon for other items
                    $('.stores').find('.icon-check').each(function () {
                        $(this).removeClass('icon-check');
                        $(this).addClass('icon-check-empty');
                    });

                    //remove 'active tracking sync' class for other items
                    $('.stores').find('.icon-spinner').each(function () {

                        let el_values_node = $(this).parents(".values");

                        if (el_values_node.attr('id').indexOf(id) < 0) {
                            $(this).removeClass('active');
                        }
                    });

                    $(this).removeClass('icon-check-empty');
                    $(this).addClass('icon-check');

                    //save active
                    setActiveStore(id);
                }
            }));




            createdItem.on('keydown', function (ev) {
                if (ev.keyCode === 13) return false;
            });

            count++;
            updateCounter();
        }
    };

    var handleInput = function () {
        $('#input-form').on('submit', function (event) {
            var content = Object.create(null);

            content.value_api_key = $('#api_key').val();

            if (validateStore(content)) {

                event.preventDefault();
                //content.value_domain = normalizeStoreUrl(content.value_domain); 
                //content.value_api_key = normalizeStoreUrl(content.value_api_key); 
                saveStore(null, content, function (id) {
                    createStore(id, content);

                    $('#api_key').val('');
                });

            } else return false;



        });
    };

    var validateStore = function (content) {
        var is_error = false, error_msg = '';

        if (content.value_api_key == '') {
            is_error = true;
            error_msg = 'Error! Input your API Key to add a new store.';
        }

        if (is_error) alert(error_msg);

        return !is_error;
    }

    var normalizeStoreUrl = function (url) {
        url = url.replace(/\/*$/, '/');
        return url;
    }

    var validURL = function (str) {

        var res = str.match(/(http(s)?:\/\/.)?(www\.)?localhost/g);
        if (res == null) {
            var res = str.match(/(http(s)?:\/\/.)?(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,8}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/g);
        }
        return (res !== null)
    }

    var switchStoreAutoTracking = function (id) {

        return new Promise(function (t, n) {

            config.get_ext_options(function (data) {
                if (parseInt(data.active_store) === parseInt(id) && typeof data.stores[id] !== "undefined") {

                    //disable tracking auto-sync for all stores
                    //and tracking auto-sync for the active store
                    for (var key in data.stores) {

                        if (key === id) {
                            if (typeof data.stores[key].tracking_autosync === "undefined") {
                                data.stores[id].tracking_autosync = !1;
                            }

                            data.stores[id].tracking_autosync = !(data.stores[id].tracking_autosync);


                        } else {
                            data.stores[key].tracking_autosync = !1;
                        }

                    }

                    chrome.storage.sync.set({ stores: data.stores }, function () {
                        t(data.stores[id].tracking_autosync);
                    });



                } else {
                    n("Please make this store active first!");
                }

            });

        });

    }

    var markActiveStore = function (id) {
        if ($('.stores').find('.icon-check').length < 1)
            $('.stores').find('.icon-check-empty:eq(' + id + ')')
                .removeClass('icon-check-empty')
                .addClass('icon-check');

    }

    var setActiveStore = function (id) {

        config.get_ext_options(function (data) {

            if (id !== null && id in data.stores) {
                var s = data.stores[id];

                if (!validURL(s.value_api_key)) {

                    var e = { success: !1, msg: "The operation is failed!<br/><br/>You need to use a correct API Key." };

                    messagePanel.render({
                        iconClose: chrome.runtime.getURL(config.assets.iconClose),
                        svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                        state: MA_Auth.getCustomStateData(e)
                    });

                    return false;
                }

                var root_url = s.value_api_key.match(/(.*?)\/\?.*/);

                if (root_url == null) {
                    var e = {
                        success: !1,
                        msg: "The operation is failed!<br/><br/>Copy the correct API Key from the Ali2Woo plugin settings."
                    };

                    messagePanel.render({
                        iconClose: chrome.runtime.getURL(config.assets.iconClose),
                        svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                        state: MA_Auth.getCustomStateData(e)
                    });

                    return false;
                }

                try {
                    var dt = new URL(root_url[1]);

                    chrome.permissions.contains({
                        origins: ['https://' + dt.hostname + '/*', 'http://' + dt.hostname + '/*']
                    }, function (result) {
                        if (result) {

                            chrome.storage.sync.set({
                                api_root_url: root_url[1],
                                api_key: s.value_api_key,
                                active_store: id
                            }, function () {
                                test_connection();
                            });

                        } else {
                            chrome.permissions.request({
                                origins: ['https://' + dt.hostname + '/*', 'http://' + dt.hostname + '/*']
                            }, granted => {
                                if (granted) {

                                    chrome.storage.sync.set({
                                        api_root_url: root_url[1],
                                        api_key: s.value_api_key,
                                        active_store: id
                                    }, function () {
                                        test_connection();
                                    });

                                } else {
                                    var e = {
                                        success: !1,
                                        msg: "Please allow Ali2Woo Chrome extension to access your website."
                                    };

                                    messagePanel.render({
                                        iconClose: chrome.runtime.getURL(config.assets.iconClose),
                                        svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                                        state: MA_Auth.getCustomStateData(e)
                                    });

                                }
                            });

                        }
                    });

                } catch (err) {

                    var e = {
                        success: !1,
                        msg: err.message
                    };

                    messagePanel.render({
                        iconClose: chrome.runtime.getURL(config.assets.iconClose),
                        svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                        state: MA_Auth.getCustomStateData(e)
                    });

                    return false;

                }




            } else {

                chrome.storage.sync.set({ api_root_url: false, api_key: false, active_store: false }, function () { });

            }

        });

    }

    var loadStores = function () {

        config.get_ext_options(function (data) {
            if (data.stores.length == 0 && data.api_key) {
                data.stores.push({
                    value_api_key: data.api_key,

                });

                chrome.storage.sync.set({ stores: data.stores, active_store: 0 }, function () { });
            }




            if (data.stores.length !== 0) {
                checkNullStores(data.stores, function (s) {
                    if (s.length !== 0) {

                        for (var key in s) {
                            var content = s[key];
                            if (content !== null) createStore(key, content);

                        }

                        var act_ind = data.active_store;
                        if (act_ind == false || typeof data.stores[act_ind] == "undefined") {
                            act_ind = 0;
                            setActiveStore(act_ind);
                        }
                        markActiveStore(act_ind);
                    }
                });

            }

        });

    };

    var handleDeleteButton = function () {
        $('.clear-all').on('click', function () {
            if (confirm('Are you sure you want to delete all the items in the list? There is no turning back after that.')) {                 //remove items from DOM
                var items = $('tr[id ^= store]');
                items.addClass('removed-item').one('webkitAnimationEnd oanimationend msAnimationEnd animationend', function (e) {
                    $(this).remove();
                });


                chrome.storage.sync.set({
                    api_key: false,
                    stores: [],
                    active_store: false
                }, function () { });

                count = 0;
                updateCounter();
            }
        });
    };

    var init = function () {
        $('#text').focus();
        loadStores();
        handleDeleteButton();
        handleInput();
        updateCounter();
    };

    init();

});



