(function(window) {
    const supportedPaymentMethodsIds = ['5600000', '700000', '400000', '5500000', '4400000', '6400000', '6500000', '6501', '6300000'];
    const SELECTOR = {
        orderPage: '#root .order-main',
        confirmBtnElementV2: '.payment-main-container .comet-btn-large',
        confirmBtnElement: '.payment-main button',
        checkoutBtnElement: '#checkout-button',
        paymentContainerV2: '.payment-container-body div:nth-child(1)',
        paymentContainer: '.checkout-container',
        modalPaymentButtonSection: '#payment-botton-section',
    };

    const script = document.getElementById('ali2woo-injected-script');
    /*if (script) {
        script.remove();
    }*/

    const chromeRuntimeId = script.getAttribute('data-runtime-id');

    const originalOpen = XMLHttpRequest.prototype.open;
    XMLHttpRequest.prototype.open = function () {
        this.addEventListener('load', function () {

            if (this.responseURL.includes('aliexpress.com/order/placeOrder4Js.htm')) {
                const responseText = this.responseText;
                if (responseText && responseText.trim() !== '') {
                    const parsedResponse = JSON.parse(responseText.trim()
                        .replace(/^__jp\d+\((.+)\);$/, '$1'));
                    // Notify extension about placed orders
                    chrome.runtime.sendMessage(
                        chromeRuntimeId, {
                        action: 'orders-placed',
                        orderIds: parsedResponse.orderIds
                    }
                    );
                } else {
                    console.log('Unexpected response');
                }
            }

            //new method to get order details
            if (this.responseURL.includes('aliexpress.com/h5/mtop.aliexpress.trade.buyer.order.detail')) {
                const responseText = this.responseText;
                if (responseText && responseText.trim() !== '') {
                    const parsedResponse = JSON.parse(responseText.trim()
                        .replace(/^ mtopjsonp2\d+\((.+)\);$/, '$1'));
                    // Notify extension order details
                    chrome.runtime.sendMessage(
                        chromeRuntimeId, {
                        action: 'order-details',
                        data: parsedResponse
                    }
                    );
                } else {
                    console.log('Unexpected response');
                }
            }

        });

        originalOpen.apply(this, arguments)
    }

    function getReactInstance(node, up = 0) {
        const reactInternalInstancePropName = Object.getOwnPropertyNames(node)
            .find(function (node) {
                return node.startsWith('__reactInternalInstance$');
            });
        let fiber = node[reactInternalInstancePropName] === null ? null : node[reactInternalInstancePropName].return;
        for (let i = 0; i < up; i++) {
            fiber = fiber.return;
        }
        return fiber.stateNode;
    }

    var maAPILoaded = new CustomEvent('maAPILoaded');
    document.dispatchEvent(maAPILoaded);

    window.addEventListener("message", function (t) {
        if ("a2w" == t.data.from) {
            if (t.data.subject === 'addOtherPaymentOption') {
                let paymentMethodEl = document.querySelector('#main .payment-info .pay-method');
                if (paymentMethodEl === null) {
                    paymentMethodEl = document.querySelector('.pay-method');
                }
                if (paymentMethodEl !== null) {
                    const options = {
                        bindCardAllowed: !0,
                        subPaymentMethodList: [{
                            available: !0,
                            paymentMethodName: '...',
                            paymentGateway: 'alipay',
                        }],
                        needChangeCurrency: !1,
                        needCpfInput: !1,
                        pmtOpt: 'others',
                        screen: 1,
                        available: !0
                    };
                    const payMethodComponentReactInstance = getReactInstance(paymentMethodEl);
                    payMethodComponentReactInstance.selectPayMethod(options);
                    payMethodComponentReactInstance.confirmPay();
                    const rootComponentEl = document.querySelector('#root > div');
                    const rootComponentReactInstance = getReactInstance(rootComponentEl, 1);
                    let intervalId = setInterval(() => {
                        if (payMethodComponentReactInstance.props.payMethodState.pmtOpt === 'others' &&
                            rootComponentReactInstance.props.payMethod.saveCardLoading === false) {
                            t.source.postMessage({
                                from: "a2w",
                                subject: "paymentMethodSelected"
                            }, t.origin)
                        }
                    }, 400);
                    setTimeout(() => clearInterval(intervalId), 5000);

                } else {
                    let checkoutContainerSelector;
                    let checkoutContainerComponentReactInst;
                    let paymentMethod;
                    let paymentMethodAvailable = false;
                    let paymentMethodIndex = null;
                    let filteredPaymentMethodIndex = null;


                    // Choose payment method from the list
                    let intervalId = setInterval(() => {
                        checkoutContainerSelector = document.querySelector(SELECTOR.paymentContainer) || document.querySelector(SELECTOR.paymentContainerV2);

                        if (checkoutContainerSelector) {
                            checkoutContainerComponentReactInst = getReactInstance(checkoutContainerSelector, 1);

                            // Format available payment methods a bit
                            const availablePaymentMethodsNodeList = checkoutContainerComponentReactInst.allItemsList || checkoutContainerComponentReactInst.props.componentData.fields.radioItemList;

                            const availablePaymentMethods = availablePaymentMethodsNodeList.filter((paymentMethod) => typeof paymentMethod.disable === 'undefined' || paymentMethod.disable === false)
                                .map(
                                    (paymentMethod, index) => {
                                        paymentMethodIndex = index;
                                        return {
                                            id: paymentMethod.id,
                                            methodCode: paymentMethod.methodCode,
                                            title: paymentMethod.title.trim()
                                        };
                                    }
                            );

                            var autopay = t.data.autopay;
                            
                            if (!autopay) {
                                paymentMethod = availablePaymentMethods.find((paymentMethod, index) => {
                                    filteredPaymentMethodIndex = index;
                                    return supportedPaymentMethodsIds.includes(paymentMethod.id);
                                });    
                            } else {
                                paymentMethod = availablePaymentMethods.find((paymentMethod, index) => {
                                    filteredPaymentMethodIndex = index;
                                    return true;
                                });       
                            }


                            if (!paymentMethod) {
                                t.source.postMessage({
                                    subject: 'supportedPaymentMethodNotAvailable',
                                    from: "a2w",
                                    availablePaymentMethods,
                                },
                                    t.origin
                                );
                                return;
                            }

                            // Payment modal V2
                            if (!checkoutContainerComponentReactInst.selectedId && checkoutContainerComponentReactInst.props) {
                                checkoutContainerComponentReactInst.props.onChange({
                                    fields: {
                                        selectedId: availablePaymentMethodsNodeList[filteredPaymentMethodIndex].id,
                                        actionType: availablePaymentMethodsNodeList[filteredPaymentMethodIndex].actionType,
                                        paymentData: availablePaymentMethodsNodeList[filteredPaymentMethodIndex].paymentData || null,
                                    }
                                });
                            }

                            // Payment modal V1
                            if (checkoutContainerComponentReactInst.selectedId !== paymentMethod.id && checkoutContainerComponentReactInst.pmtOptChange) {
                                checkoutContainerComponentReactInst.pmtOptChange({
                                    id: paymentMethod.id
                                })
                            }
                            if (checkoutContainerComponentReactInst && availablePaymentMethods && paymentMethod) {
                                clearInterval(intervalId)
                            };
                        }
                    }, 1000);


                    // Confirm choosen payment method
                    const waitForPmtOptChangeIntervalId = setInterval(async () => {
                        if (checkoutContainerSelector) {
                            const componentReactInst = getReactInstance(checkoutContainerSelector, 1);

                            // selectedId is available only on V1, payment button is available on V2 after payment method selected
                            if ((componentReactInst && componentReactInst.selectedId && componentReactInst.selectedId === paymentMethod.id) || document.querySelector(SELECTOR.modalPaymentButtonSection)) {
                                clearInterval(waitForPmtOptChangeIntervalId);
                                paymentMethodAvailable = true;
                                const confirmBtnEl = document.querySelector(SELECTOR.confirmBtnElement) || document.querySelector(SELECTOR.checkoutBtnElement);
                                const confirmBtnElV2 = document.querySelector(SELECTOR.confirmBtnElementV2);

                                //Payment method confirmation for V1
                                if (confirmBtnEl && !confirmBtnElV2) {
                                    const confirmComponentReactInst = getReactInstance(confirmBtnEl, 4);
                                    confirmComponentReactInst.confirm();

                                    // Wait for payment method to be actually selected
                                    let paymentMethodSelected = false;
                                    const confirmPmtOptChangeIntervalId = setInterval(() => {
                                        let chosenPaymentMethodContainerEl = document.querySelector('.chosen-channel-container-wrap');
                                        if (!chosenPaymentMethodContainerEl) {
                                            chosenPaymentMethodContainerEl = document.querySelector('._2P6Ey');
                                        }

                                        if (paymentMethod && chosenPaymentMethodContainerEl && ( chosenPaymentMethodContainerEl.textContent.includes(paymentMethod.title) || chosenPaymentMethodContainerEl.textContent.includes(paymentMethod.title.replace(/\s/g, '')) )) {
                                            clearInterval(confirmPmtOptChangeIntervalId);
                                            paymentMethodSelected = true;
                                            // Notify extension
                                            t.source.postMessage({
                                                subject: 'paymentMethodSelected',
                                                from: "a2w",
                                            },
                                                t.origin
                                            );
                                        }

                                        setTimeout(() => {
                                            clearInterval(confirmPmtOptChangeIntervalId);
                                            if (!paymentMethodSelected) {
                                                t.source.postMessage({
                                                    subject: 'failedToConfirmThatPaymentMethodWasSelected',
                                                    from: "a2w",
                                                },
                                                    t.origin
                                                );
                                            }
                                        }, 15000);
                                    }, 400);

                                } else {
                                    //Payment method confirmation for V2
                                    let paymentMethodSelected = false;
                                    await new Promise((resolve) => setTimeout(() => {
                                        confirmBtnElV2.click();
                                        resolve();
                                    }, 1000));
                                    
                                    const confirmPmtOptChangeIntervalId = setInterval(() => {
                                        const chosenPaymentMethodContainerEl = document.querySelector('#main #placeorder-page-payment-container')?.parentNode?.querySelector("span > span > span");
                                        
                                        if (paymentMethod && chosenPaymentMethodContainerEl && (chosenPaymentMethodContainerEl.textContent.includes(paymentMethod.title) || chosenPaymentMethodContainerEl.textContent.includes(paymentMethod.title.replace(/\s/g, '')))) {
                                            paymentMethodSelected = true;
                                            // Notify extension
                                            clearInterval(confirmPmtOptChangeIntervalId);
                                            t.source.postMessage({
                                                subject: 'paymentMethodSelected',
                                                from: "a2w",
                                            },
                                                t.origin
                                            );
                                        }

                                        setTimeout(() => {
                                            clearInterval(confirmPmtOptChangeIntervalId);
                                            if (!paymentMethodSelected) {
                                                t.source.postMessage({
                                                    subject: 'failedToConfirmThatPaymentMethodWasSelected',
                                                    from: "a2w",
                                                },
                                                    t.origin
                                                );
                                            }
                                        }, 15000);
                                    }, 400);
                                }

                                setTimeout(() => {
                                    clearInterval(waitForPmtOptChangeIntervalId);
                                    if (!paymentMethodAvailable) {
                                        t.source.postMessage({
                                            subject: 'supportedPaymentMethodNotAvailable',
                                            from: "a2w",
                                            availablePaymentMethods,
                                        },
                                            t.origin
                                        );
                                    }
                                }, 30000);

                            }
                        }
                    });


                }
            }

            else if (t.data.subject === 'placeOrder') {
                window.paymentUltronAsyncData = {};
                // noinspection SpellCheckingInspection
                /** @type {{ placeorder: function }} */


                try {
                    let intervalId = setInterval(() => {
                        const mainComponentReactInst = getReactInstance(document.querySelector(SELECTOR.orderPage)
                            .parentNode, 1);
                        if (mainComponentReactInst && mainComponentReactInst.placeorder) {
                            clearInterval(intervalId);
                            mainComponentReactInst.placeorder();
                        }
                    }, 1000);
                } catch (e) {
                    t.source.postMessage({
                        subject: 'err',
                        from: "a2w",
                        error: e.toString()
                    },
                        t.origin
                    );
                    throw e;
                }
            } 
        }
    }, false);

    window.addEventListener("message",
    function (t) {
        if ("a2w" == t.data.from) {
            if (t.data.subject === 'getOrderDetail') {

                    Function.prototype.clonef = function () {
                        var cloneObj = this;
                        if (this.__isClone) {
                            cloneObj = this.__clonedFrom;
                        }

                        var temp = function () { return cloneObj.apply(this, arguments); };
                        for (var key in this) {
                            temp[key] = this[key];
                        }

                        temp.__isClone = true;
                        temp.__clonedFrom = cloneObj;

                        return temp;
                    };

                    var callback = window[t.data.scriptCallback];

                    var originalCallback = callback.clonef();

                    window[t.data.scriptCallback] = function () {
                        let order_detail_data = Array.prototype.slice.call(arguments);

                        if (typeof order_detail_data[0] !== 'undefined' &&
                            typeof order_detail_data[0].data !== 'undefined') {

                            t.source.postMessage({
                                type: 'ok',
                                from: "a2w",
                                subject: "updateMacthOrders",
                                order_detail: order_detail_data[0].data
                            },
                                t.origin);

                        } else {
                            //todo: error
                        }


                        //console.log(order_detail_data);
                        //  console.log(originalCallback);

                        originalCallback(arguments);
                    }

            }

        }
    }, true);

    
})(window);

function a2w_get_order_fulfillment(data, callback) {

    var storeEvent = new CustomEvent('order_fulfillment', { "detail": data });

    document.addEventListener('order_fulfillment_status_response', function respListener(event) {
        var data = event.detail;

        if (typeof callback !== "undefined")
            callback(data);

        if (data.stage == 5) {
            document.removeEventListener('order_fulfillment_status_response', respListener);
        }

    });

    document.dispatchEvent(storeEvent);
}

function a2w_get_order_tracking_code(data, callback) {
    var storeEvent = new CustomEvent('order_tracking_code', { "detail": data });

    document.addEventListener('order_tracking_code_response', function respListener(event) {
        var data = event.detail;

        callback(data);

        document.removeEventListener('order_tracking_code_response', respListener);


    });

    document.dispatchEvent(storeEvent);
}

function ma_get_product(url, callback) {
    var reqId = Math.random().toString();
    var data = { "url": url, "reqId": reqId };
    var storeEvent = new CustomEvent('WEB_GET_PRODUCT_HTML_REQUEST', { "detail": data });

    document.addEventListener('WEB_GET_PRODUCT_HTML_RESPONSE', function respListener(event) {
        var data = event.detail;
        if (data.reqId == reqId) {
            callback(data.html);
            document.removeEventListener('WEB_GET_PRODUCT_HTML_RESPONSE', respListener);
        }
    });

    document.dispatchEvent(storeEvent);
}

function a2w_get_product(params, callback) {
    var reqId = Math.random().toString();
    var data = { params, "reqId": reqId };
    var storeEvent = new CustomEvent('WEB_GET_PRODUCT_INFO_REQUEST', { "detail": data });

    document.addEventListener('WEB_GET_PRODUCT_INFO_RESPONSE', function respListener(event) {
        var data = event.detail;
        if (data.reqId == reqId) {
            callback(data.status, data.data, data.error_msg);
            document.removeEventListener('WEB_GET_PRODUCT_INFO_RESPONSE', respListener);
        }
    });

    document.dispatchEvent(storeEvent);
}

function a2w_go_to_payall() {
    var e = new CustomEvent('order_fulfillment_payall');
    document.dispatchEvent(e);
}

function a2w_close_chrome_tab() {
    var e = new CustomEvent('close_chrome_tab');
    document.dispatchEvent(e);
}

function a2w_switch_to_chrome_tab() {
    var e = new CustomEvent('switch_to_chrome_tab');
    document.dispatchEvent(e);
}


const ali_get_order_fulfillment = a2w_get_order_fulfillment;
const ali_get_order_tracking_code = a2w_get_order_tracking_code;
const ali_go_to_payall = a2w_go_to_payall;
const ali_close_chrome_tab = a2w_close_chrome_tab;
const ali_switch_to_chrome_tab = a2w_switch_to_chrome_tab;

