var config = {
    get_ext_options: function(f) {
        chrome.storage.sync.get({
            api_key: false,
            api_root_url: false,
            stores: [],
            active_store: false,
            shippingOption: config.defaultShippingSettings.shippingOption,
            shippingCountry: config.defaultShippingSettings.shippingCountry,
            shippingCurrency: config.defaultShippingSettings.shippingCurrency,
            showShipping: !0,
            showOnlyActive: !1,
            showProcessing: !0,
            showDelivery: !0,
            markImported: !1,
            isPremium: !1,

        }, function(items) {
            f(items);
        });
    },
    alarms: {
        checkOrders: "a2w_check_orders",
    },
    defaults: {
        storedOrderTTL: 6e5,
        processingOrderTTL: 6e4,
        maxFulfilledOrders: 30,
        minPageMatchPercentage: .5,
        aliProductLink: "//www.aliexpress.com/item/slug/{0}.html",
        failedTaskPause: 150,
        chromeExtensionSource: 4,
        currency: "usd"
    },
    data_keys: {
        shipping_info_cache : 'a2w_shipping_info_cache',
    },
    constants: {
        freightCacheTime: 36e5,
    },
    assets: {
        svgLogo: "assets/images/logo.png",
        logoSM: "assets/images/logo-small.png",
        logoXS: "assets/images/logo-xs.png",
        iconImportSuccess: "assets/images/icon-import-success.png",
        iconImportError: "assets/images/icon-import-error.png",
        iconTime: "assets/images/icon-time.png",
        iconCheck: "assets/images/icon-check.png",
        iconClose: "assets/images/icon-close.png",
        iconCloseCircle: "assets/images/icon-close-circle.png",
        iconRemove: "assets/images/icon-x.png",
        btnFloating: "assets/images/btn-floating.png",
        iconImported: "assets/images/btn-imported.png",
    },
    urls: {
        shippingInfo_old: "https://freight.aliexpress.com/ajaxFreightCalculateService.htm?productid={1}&country={2}&count={3}&currencyCode={4}",
        shippingInfo_old1: "https://m.aliexpress.com/freight/ajaxapi/calculate.do?productId={1}&countryCode={2}&quantity={3}&currency={4}",
        shippingInfo_old2: "https://freight.aliexpress.com/ajaxFreightCalculateService.htm?productid={1}&country={2}&count={3}&currencyCode={4}",
        shippingInfo: "https://m.aliexpress.com/api/products/{1}/fees?country={2}&minPrice=0.01&maxPrice=0.01&tradeCurrency={4}&count={3}&userScene=M_DETAIL_SHIPPING_PANEL",

        logisticDetail: "https://track.aliexpress.com/logisticsdetail.htm?tradeId={1}&rrnd={2}",
        aliexpressLink: "https://www.aliexpress.com/",

        orderInfo: "https://trade.aliexpress.com/order_detail.htm?orderId={1}&rrnd={2}",
        orderInfo2: "https://www.aliexpress.com/p/order/detail.html?orderId={1}&rrnd={2}",


        aliexpressPayAllLink: "https://trade.aliexpress.com/order_list.htm",
        aliexpressMaintain: "https://www.aliexpress.com/maintain.html",
        queryCountries: "https://ilogisticsaddress.aliexpress.com/AjaxQueryCountries",
        ordersDetail: "https://shoppingcart.aliexpress.com/api/1.0/orders.htm",
        ajaxSaveOrUpdateBuyerAddress: "https://ilogisticsaddress.aliexpress.com/ajaxSaveOrUpdateBuyerAddress.htm",

        v2AddToCart: "https://shoppingcart.aliexpress.com/addToShopcart4Js.htm",
        v2GetShippingMethods: "https://www.aliexpress.com/aeglodetailweb/api/logistics/freight",
        v3AddToCart: "https://aliexpress.ru/aer-api/v1/cart/add",

        cart: "https://shoppingcart.aliexpress.com/api/1.0/cart.do",
        cartItems: "https://shoppingcart.aliexpress.com/api/1.0/cart/items.do?currentPage={1}&uniqueId={2}",

        oldOrderUrl: "https://shoppingcart.aliexpress.com/orders.htm",
    },
    actions: {
        SYNC_PRODUCT_LIST: "SYNC_PRODUCT_LIST",
        CONTENT_PUSH_PRODUCT_TO_APP: "CONTENT_PUSH_PRODUCT_TO_APP",
        CONTENT_DELETE_PRODUCT_FROM_APP: "CONTENT_DELETE_PRODUCT_FROM_APP",
        CONTENT_TEST_CONNECTION: "CONTENT_TEST_CONNECTION",

        CONTENT_ADD_PRODUCT_TO_CART: "CONTENT_ADD_PRODUCT_TO_CART",
        CONTENT_ADD_PRODUCT_TO_CART_V2: "CONTENT_ADD_PRODUCT_TO_CART_V2",
        CONTENT_GET_COUNTRIES: "CONTENT_GET_COUNTRIES",

        CONTENT_OPEN_SETTING_TAB: "CONTENT_OPEN_SETTING_TAB",
        CHECK_MAIN_CONTENT_IS_INCLUDED: "CHECK_MAIN_CONTENT_IS_INCLUDED",
        GET_AND_PUSH_PRODUCT_HTML_TO_APP: "GET_AND_PUSH_PRODUCT_HTML_TO_APP",

        CONTENT_GET_PRODUCT_HTML: "CONTENT_GET_PRODUCT_HTML",
      //  CONTENT_GET_PRODUCT_INFO: "CONTENT_GET_PRODUCT_INFO",

        CONTENT_ORDER_FULFILLMENT_QUEUE: "OrderFulfillmentQueue",
        CONTENT_ORDER_TRACKING_CODE_REQUEST: "CONTENT_ORDER_TRACKING_CODE_REQUEST",
        CONTENT_ORDER_TRACKING_CODE_RESPONSE: "CONTENT_ORDER_TRACKING_CODE_RESPONSE",
        CONTENT_ORDER_FULFILLMENT_STATUS_RESPONSE: "CONTENT_ORDER_FULFILLMENT_STATUS_RESPONSE",

        CONTENT_ORDER_FULFILLMENT_TO_CART: "toCart",
        WEB_GET_PRODUCT_INFO_REQUEST: "WEB_GET_PRODUCT_INFO_REQUEST",


        WEB_GET_PRODUCT_HTML_REQUEST: "WEB_GET_PRODUCT_HTML_REQUEST",

        WEB_GET_PRODUCT_HTML_RESPONSE: "WEB_GET_PRODUCT_HTML_RESPONSE",
        WEB_GET_PRODUCT_INFO_RESPONSE: "WEB_GET_PRODUCT_INFO_RESPONSE",

        WEB_ORDER_FULFILLMENT_REQUEST: "order_fulfillment",
        WEB_ORDER_TRACKING_CODE_REQUEST: "order_tracking_code",
        WEB_ORDER_TRACKING_CODE_RESPONSE: "order_tracking_code_response",
        WEB_ORDER_FULFILLMENT_STATUS_RESPONSE: "order_fulfillment_status_response",
        CONTENT_CLEAR_ORDER_DATA: "CONTENT_CLEAR_ORDER_DATA",
        CONTENT_ORDER_FULFILLMENT_RESPONSE: "get_order_fulfillment_response",
        WEB_ORDER_FULFILLMENT_PAYALL_REQUEST: "order_fulfillment_payall",
        CONTENT_ORDER_FULFILLMENT_PAYALL_REQUEST: "CONTENT_ORDER_FULFILLMENT_PAYALL_REQUEST",
        CONTENT_OPEN_PRICING_PAGE: "CONTENT_OPEN_PRICING_PAGE",
        WEB_CLOSE_CHROME_TAB_REQUEST: "close_chrome_tab",
        CONTENT_CLOSE_CHROME_TAB_REQUEST: "CONTENT_CLOSE_CHROME_TAB_REQUEST",
        WEB_SWITCH_TO_CHROME_TAB_REQUEST: "switch_to_chrome_tab",
        CONTENT_SWITCH_TO_CHROME_TAB_REQUEST: "SWITCH_TO_CHROME_TAB_REQUEST",
        CONTENT_SWITCH_TO_PLUGIN_TAB_REQUEST: "CONTENT_SWITCH_TO_PLUGIN_TAB_REQUEST",
        CONTENT_SET_ADDRESS: "CONTENT_SET_ADDRESS",
        CONTENT_TEST_REQUEST: "CONTENT_TEST_REQUEST",
        CONTENT_SET_POPUP: "CONTENT_SET_POPUP",
        CONTENT_CHECK_PRODUCTS_IMPORTED: "CONTENT_CHECK_PRODUCTS_IMPORTED",
        CONTENT_UPDATE_TAB_URL: "CONTENT_UPDATE_TAB_URL",
        FETCH_PRODUCT_SHIPPING_METHODS_DATA: "FETCH_PRODUCT_SHIPPING_METHODS_DATA",
        FETCH_CART_DATA: "FETCH_CART_DATA",
        FETCH_CART_ITEMS: "FETCH_CART_ITEMS",
        EMPTY_CART: "EMPTY_CART",
    },
    defaultShippingSettings: {
        showShipping: !0,
        shippingOption: "EMS_ZX_ZX_US",
        shippingCountry: "US",
        shippingCurrency: "USD",
        showOnlyActive: !1,
        showProcessing: !0,
        showDelivery: !0
    },
    locale_site_map: {
        "fr_FR": "fra",
        "pl_PL": "pol",
        "ru_RU": "rus",
        "pt_BR": "bra",
        "es_ES": "esp",
        "de_DE": "deu",
        "it_IT": "ita",
        "nl_NL": "nld",
        "tr_TR": "tur",
        "ja_JP": "jpn",
        "ko_KR": "kor",
        "th_TH": "tha",
        "vi_VN": "vnm",
        "ar_MA": "ara",
        "iw_IL": "isr",
    },
    shippingOptions: [{
        v: "CAINIAO_STANDARD",
        t: "AliExpress Standard Shipping"
    }, {
        v: "AliExpress Selection Standard",
        t: "AliExpress Selection Standard"
    }, {
        v: "ECONOMIC139",
        t: "139Express"
    }, {
        v: "AE_360LION_STANDARD",
        t: "360 Lion Standard Packet"
    }, {
        v: "FOURPX_RM",
        t: "4PX RM"
    }, {
        v: "SGP_OMP",
        t: "4PX Singapore Post OM Pro"
    }, {
        v: "CAINIAO_CONSOLIDATION_SA",
        t: "Aliexpress Direct (Saudi Arabia)"
    }, {
        v: "CAINIAO_CONSOLIDATION_AE",
        t: "Aliexpress Direct (UAE)"
    }, {
        v: "CAINIAO_CONSOLIDATION_BR",
        t: "Aliexpress Direct (Brazil)"
    }, {
        v: "CAINIAO_PREMIUM",
        t: "AliExpress Premium Shipping"
    }, {
        v: "CAINIAO_ECONOMY",
        t: "AliExpress Saver Shipping"
    }, {
        v: "ARAMEX",
        t: "ARAMEX"
    }, {
        v: "AUSPOST",
        t: "Australia Post"
    }, {
        v: "BSC_ECONOMY_SG",
        t: "BSC Special Economy"
    }, {
        v: "BSC_STANDARD_SG",
        t: "BSC Special Standard"
    }, {
        v: "CAINIAO_EXPEDITED_ECONOMY",
        t: "Cainiao Expedited Economy"
    }, {
        v: "AE_CAINIAO_STANDARD",
        t: "Cainiao Expedited Standard"
    }, {
        v: "CAINIAO_STANDARD_HEAVY",
        t: "Cainiao Heavy Parcel Line"
    }, {
        v: "CAINIAO_ECONOMY_SG",
        t: "Cainiao Saver Shipping For Special Goods"
    }, {
        v: "CAINIAO_STANDARD_SG",
        t: "Cainiao Standard For Special Goods"
    }, {
        v: "CAINIAO_SUPER_ECONOMY",
        t: "Cainiao Super Economy"
    }, {
        v: "CAINIAO_SUPER_ECONOMY_SG",
        t: "Cainiao Super Economy for Special Goods"
    }, {
        v: "AE_CN_SUPER_ECONOMY_G",
        t: "Cainiao Super Economy Global"
    }, {
        v: "CAINIAO_OVERSEAS_WH_EXPPL",
        t: "Cainiao Warehouse Express Shipping"
    }, {
        v: "CDEK_RU",
        t: "CDEK"
    }, {
        v: "CPAP",
        t: "China Post Air Parcel"
    }, {
        v: "YANWEN_JYT",
        t: "China Post Ordinary Small Packet Plus"
    }, {
        v: "CPAM",
        t: "China Post Registered Air Mail"
    }, {
        v: "CHOICE",
        t: "CHOICE Logistics"
    }, {
        v: "CJ",
        t: "CJ Logistics"
    }, {
        v: "CKE",
        t: "CKE Express"
    }, {
        v: "CNE",
        t: "CNE Express"
    }, {
        v: "CORREIOS_BR",
        t: "Correios Brazil"
    }, {
        v: "DEUTSCHE_POST",
        t: "Deutsche Post"
    }, {
        v: "DHL",
        t: "DHL"
    }, {
        v: "DHLECOM",
        t: "DHL e-commerce"
    }, {
        v: "TOLL",
        t: "DPEX"
    }, {
        v: "EMS",
        t: "EMS"
    }, {
        v: "E_EMS",
        t: "e-EMS"
    }, {
        v: "EMS_ZX_ZX_US",
        t: "ePacket"
    }, {
        v: "eTotal",
        t: "eTotal"
    }, {
        v: "FEDEX",
        t: "FedEx"
    }, {
        v: "FEDEX_IE",
        t: "Fedex IE"
    }, {
        v: "FEDEX_IP",
        t: "Fedex IP"
    }, {
        v: "FLYT",
        t: "Flyt Express"
    }, {
        v: "FLYT_ECONOMY_SG",
        t: "Flyt Special Economy"
    }, {
        v: "GATI",
        t: "GATI"
    }, {
        v: "GES",
        t: "GES Express"
    }, {
        v: "GLS_FR",
        t: "GLS France"
    }, {
        v: "GLS_ES",
        t: "GLS Spain"
    }, {
        v: "CTR_LAND_PICKUP",
        t: "J-NET"
    }, {
        v: "JCEX",
        t: "JCEX Express"
    }, {
        v: "LAPOSTE",
        t: "La Poste"
    }, {
        v: "MEEST",
        t: "Meest"
    }, {
        v: "POSTKR",
        t: "POSTKR"
    }, {
        v: "POST_NL",
        t: "PostNL"
    }, {
        v: "RUSSIAN_POST",
        t: "Russian Post"
    }, {
        v: "SF_EPARCEL_OM",
        t: "SF Economic Air Mail"
    }, {
        v: "SF_EPARCEL",
        t: "SF eParcel"
    }, {
        v: "SF",
        t: "SF Express"
    }, {
        v: "SGP",
        t: "Singapore Post"
    }, {
        v: "SUNYOU_RM",
        t: "SunYou"
    }, {
        v: "SUNYOU_ECONOMY",
        t: "SunYou Economic Air Mail"
    }, {
        v: "SUNYOU_ECONOMY_SG",
        t: "SunYou Special Economy"
    }, {
        v: "SHUNYOU_STANDARD_SG",
        t: "SunYou Special Standard"
    }, {
        v: "CHP",
        t: "Swiss Post"
    }, {
        v: "TNT",
        t: "TNT"
    }, {
        v: "LAOPOST",
        t: "TOPYOU"
    }, {
        v: "TOPYOU_ECONOMY_SG",
        t: "TOPYOU Special Economy"
    }, {
        v: "PTT",
        t: "Turkey Post"
    }, {
        v: "UBI",
        t: "UBI"
    }, {
        v: "UPS",
        t: "UPS"
    }, {
        v: "UPSE",
        t: "UPS Expedited"
    }, {
        v: "USPS",
        t: "USPS"
    }, {
        v: "YANWEN_ECONOMY",
        t: "Yanwen Economic Air Mail"
    }, {
        v: "YANWEN_ECONOMY_SG",
        t: "Yanwen Special Economy"
    }, {
        v: "YANWEN_AM",
        t: "Yanwen Special Line-YW"
    }, {
        v: "YANWEN_AM",
        t: "Yanwen Special Standard"
    }],
    shippingCurrencies: ["EUR", "GBP", "USD", "BRL", "RUB", "MXN", "AUD", "CAD"],
    shippingCountries: [{
        v: "AF",
        t: "Afghanistan"
    }, {
        v: "ALA",
        t: "Aland Islands"
    }, {
        v: "AL",
        t: "Albania"
    }, {
        v: "GBA",
        t: "Alderney"
    }, {
        v: "DZ",
        t: "Algeria"
    }, {
        v: "AS",
        t: "American Samoa"
    }, {
        v: "AD",
        t: "Andorra"
    }, {
        v: "AO",
        t: "Angola"
    }, {
        v: "AI",
        t: "Anguilla"
    }, {
        v: "AQ",
        t: "Antarctica"
    }, {
        v: "AG",
        t: "Antigua and Barbuda"
    }, {
        v: "AR",
        t: "Argentina"
    }, {
        v: "AM",
        t: "Armenia"
    }, {
        v: "AW",
        t: "Aruba"
    }, {
        v: "ASC",
        t: "Ascension Island"
    }, {
        v: "AU",
        t: "Australia"
    }, {
        v: "AT",
        t: "Austria"
    }, {
        v: "AZ",
        t: "Azerbaijan"
    }, {
        v: "BH",
        t: "Bahrain"
    }, {
        v: "GGY",
        t: "Bailiwick of Guernsey"
    }, {
        v: "BD",
        t: "Bangladesh"
    }, {
        v: "BB",
        t: "Barbados"
    }, {
        v: "BY",
        t: "Belarus"
    }, {
        v: "BE",
        t: "Belgium"
    }, {
        v: "BZ",
        t: "Belize"
    }, {
        v: "BJ",
        t: "Benin"
    }, {
        v: "BM",
        t: "Bermuda"
    }, {
        v: "BT",
        t: "Bhutan"
    }, {
        v: "BO",
        t: "Bolivia"
    }, {
        v: "BA",
        t: "Bosnia and Herzegovina"
    }, {
        v: "BW",
        t: "Botswana"
    }, {
        v: "BV",
        t: "Bouvet Island"
    }, {
        v: "BR",
        t: "Brazil"
    }, {
        v: "IO",
        t: "British Indian Ocean Territory"
    }, {
        v: "VG",
        t: "British Virgin Islands"
    }, {
        v: "BG",
        t: "Bulgaria"
    }, {
        v: "BF",
        t: "Burkina Faso"
    }, {
        v: "BI",
        t: "Burundi"
    }, {
        v: "KH",
        t: "Cambodia"
    }, {
        v: "CM",
        t: "Cameroon"
    }, {
        v: "CA",
        t: "Canada"
    }, {
        v: "IC",
        t: "Canary Islands"
    }, {
        v: "CV",
        t: "Cape Verde"
    }, {
        v: "BQ",
        t: "Caribbean Netherlands"
    }, {
        v: "KY",
        t: "Cayman Islands"
    }, {
        v: "CF",
        t: "Central African Republic"
    }, {
        v: "TD",
        t: "Chad"
    }, {
        v: "CL",
        t: "Chile"
    }, {
        v: "CN",
        t: "China"
    }, {
        v: "CX",
        t: "Christmas Island"
    }, {
        v: "CC",
        t: "Cocos (Keeling) Islands"
    }, {
        v: "CO",
        t: "Colombia"
    }, {
        v: "KM",
        t: "Comoros"
    }, {
        v: "CK",
        t: "Cook Islands"
    }, {
        v: "CR",
        t: "Costa Rica"
    }, {
        v: "CI",
        t: "Cote D'Ivoire"
    }, {
        v: "HR",
        t: "Croatia"
    }, {
        v: "CU",
        t: "Cuba"
    }, {
        v: "CW",
        t: "Curacao"
    }, {
        v: "CY",
        t: "Cyprus"
    }, {
        v: "CZ",
        t: "Czech Republic"
    }, {
        v: "DK",
        t: "Denmark"
    }, {
        v: "DJ",
        t: "Djibouti"
    }, {
        v: "DM",
        t: "Dominica"
    }, {
        v: "DO",
        t: "Dominican Republic"
    }, {
        v: "EC",
        t: "Ecuador"
    }, {
        v: "EG",
        t: "Egypt"
    }, {
        v: "SV",
        t: "El Salvador"
    }, {
        v: "GQ",
        t: "Equatorial Guinea"
    }, {
        v: "ER",
        t: "Eritrea"
    }, {
        v: "EE",
        t: "Estonia"
    }, {
        v: "ET",
        t: "Ethiopia"
    }, {
        v: "FK",
        t: "Falkland Islands (Islas Malvinas)"
    }, {
        v: "FO",
        t: "Faroe Islands"
    }, {
        v: "FJ",
        t: "Fiji"
    }, {
        v: "FI",
        t: "Finland"
    }, {
        v: "FR",
        t: "France"
    }, {
        v: "PF",
        t: "French Polynesia"
    }, {
        v: "TF",
        t: "French Southern Territories"
    }, {
        v: "GA",
        t: "Gabon"
    }, {
        v: "GM",
        t: "Gambia"
    }, {
        v: "GE",
        t: "Georgia"
    }, {
        v: "DE",
        t: "Germany"
    }, {
        v: "GH",
        t: "Ghana"
    }, {
        v: "GI",
        t: "Gibraltar"
    }, {
        v: "GR",
        t: "Greece"
    }, {
        v: "GL",
        t: "Greenland"
    }, {
        v: "GD",
        t: "Grenada"
    }, {
        v: "GP",
        t: "Guadeloupe"
    }, {
        v: "GU",
        t: "Guam"
    }, {
        v: "GT",
        t: "Guatemala"
    }, {
        v: "GN",
        t: "Guinea"
    }, {
        v: "GW",
        t: "Guinea-Bissau"
    }, {
        v: "GY",
        t: "Guyana"
    }, {
        v: "GF",
        t: "Guyane French"
    }, {
        v: "HT",
        t: "Haiti"
    }, {
        v: "HN",
        t: "Honduras"
    }, {
        v: "HK",
        t: "Hong Kong"
    }, {
        v: "HU",
        t: "Hungary"
    }, {
        v: "IS",
        t: "Iceland"
    }, {
        v: "IN",
        t: "India"
    }, {
        v: "ID",
        t: "Indonesia"
    }, {
        v: "IQ",
        t: "Iraq"
    }, {
        v: "IE",
        t: "Ireland"
    }, {
        v: "IR",
        t: "Islamic Republic of Iran"
    }, {
        v: "IM",
        t: "Isle of Man"
    }, {
        v: "IL",
        t: "Israel"
    }, {
        v: "IT",
        t: "Italy"
    }, {
        v: "JM",
        t: "Jamaica"
    }, {
        v: "JP",
        t: "Japan"
    }, {
        v: "JEY",
        t: "Jersey"
    }, {
        v: "JO",
        t: "Jordan"
    }, {
        v: "KZ",
        t: "Kazakhstan"
    }, {
        v: "KE",
        t: "Kenya"
    }, {
        v: "KI",
        t: "Kiribati"
    }, {
        v: "KR",
        t: "Korea"
    }, {
        v: "KS",
        t: "Kosovo"
    }, {
        v: "KW",
        t: "Kuwait"
    }, {
        v: "KG",
        t: "Kyrgyzstan"
    }, {
        v: "LA",
        t: "Lao People's Democratic Republic"
    }, {
        v: "LV",
        t: "Latvia"
    }, {
        v: "LB",
        t: "Lebanon"
    }, {
        v: "LS",
        t: "Lesotho"
    }, {
        v: "LR",
        t: "Liberia"
    }, {
        v: "LY",
        t: "Libya"
    }, {
        v: "LI",
        t: "Liechtenstein"
    }, {
        v: "LT",
        t: "Lithuania"
    }, {
        v: "LU",
        t: "Luxembourg"
    }, {
        v: "MO",
        t: "Macau"
    }, {
        v: "MK",
        t: "Macedonia"
    }, {
        v: "MG",
        t: "Madagascar"
    }, {
        v: "MW",
        t: "Malawi"
    }, {
        v: "MY",
        t: "Malaysia"
    }, {
        v: "MV",
        t: "Maldives"
    }, {
        v: "ML",
        t: "Mali"
    }, {
        v: "MT",
        t: "Malta"
    }, {
        v: "MQ",
        t: "Martinique"
    }, {
        v: "MR",
        t: "Mauritania"
    }, {
        v: "MU",
        t: "Mauritius"
    }, {
        v: "YT",
        t: "Mayotte"
    }, {
        v: "MX",
        t: "Mexico"
    }, {
        v: "FM",
        t: "Micronesia"
    }, {
        v: "MC",
        t: "Monaco"
    }, {
        v: "MN",
        t: "Mongolia"
    }, {
        v: "MNE",
        t: "Montenegro"
    }, {
        v: "MS",
        t: "Montserrat"
    }, {
        v: "MA",
        t: "Morocco"
    }, {
        v: "MZ",
        t: "Mozambique"
    }, {
        v: "MM",
        t: "Myanmar"
    }, {
        v: "NA",
        t: "Namibia"
    }, {
        v: "NR",
        t: "Nauru"
    }, {
        v: "BN",
        t: "Negara Brunei Darussalam"
    }, {
        v: "NP",
        t: "Nepal"
    }, {
        v: "NL",
        t: "Netherlands"
    }, {
        v: "AN",
        t: "Netherlands Antilles"
    }, {
        v: "NC",
        t: "New Caledonia"
    }, {
        v: "NZ",
        t: "New Zealand"
    }, {
        v: "NI",
        t: "Nicaragua"
    }, {
        v: "NE",
        t: "Niger"
    }, {
        v: "NG",
        t: "Nigeria"
    }, {
        v: "NU",
        t: "Niue"
    }, {
        v: "NF",
        t: "Norfolk Island"
    }, {
        v: "KP",
        t: "North Korea"
    }, {
        v: "MP",
        t: "Northern Mariana Islands"
    }, {
        v: "NO",
        t: "Norway"
    }, {
        v: "OM",
        t: "Oman"
    }, {
        v: "PK",
        t: "Pakistan"
    }, {
        v: "PW",
        t: "Palau"
    }, {
        v: "PS",
        t: "Palestine"
    }, {
        v: "PA",
        t: "Panama"
    }, {
        v: "PG",
        t: "Papua New Guinea"
    }, {
        v: "PY",
        t: "Paraguay"
    }, {
        v: "PE",
        t: "Peru"
    }, {
        v: "PH",
        t: "Philippines"
    }, {
        v: "PN",
        t: "Pitcairn Islands"
    }, {
        v: "PL",
        t: "Poland"
    }, {
        v: "PT",
        t: "Portugal"
    }, {
        v: "PR",
        t: "Puerto Rico"
    }, {
        v: "QA",
        t: "Qatar"
    }, {
        v: "MD",
        t: "Republic of Moldova"
    }, {
        v: "RE",
        t: "Reunion"
    }, {
        v: "RO",
        t: "Romania"
    }, {
        v: "RU",
        t: "Russian Federation"
    }, {
        v: "RW",
        t: "Rwanda"
    }, {
        v: "BLM",
        t: "Saint Barthelemy"
    }, {
        v: "SH",
        t: "Saint Helena"
    }, {
        v: "KN",
        t: "Saint Kitts and Nevis"
    }, {
        v: "LC",
        t: "Saint Lucia"
    }, {
        v: "MF",
        t: "Saint Martin（France）"
    }, {
        v: "PM",
        t: "Saint Pierre and Miquelon"
    }, {
        v: "VC",
        t: "Saint Vincent and the Grenadines"
    }, {
        v: "WS",
        t: "Samoa"
    }, {
        v: "SM",
        t: "San Marino"
    }, {
        v: "ST",
        t: "Sao Tome and Principe"
    }, {
        v: "SA",
        t: "Saudi Arabia"
    }, {
        v: "SN",
        t: "Senegal"
    }, {
        v: "SRB",
        t: "Serbia"
    }, {
        v: "SC",
        t: "Seychelles"
    }, {
        v: "SL",
        t: "Sierra Leone"
    }, {
        v: "SG",
        t: "Singapore"
    }, {
        v: "SX",
        t: "Sint Maarten (Netherlands)"
    }, {
        v: "SK",
        t: "Slovakia"
    }, {
        v: "SI",
        t: "Slovenia"
    }, {
        v: "SB",
        t: "Solomon Islands"
    }, {
        v: "SO",
        t: "Somalia"
    }, {
        v: "ZA",
        t: "South Africa"
    }, {
        v: "SGS",
        t: "South Georgia and The South Sandwich Islands"
    }, {
        v: "SS",
        t: "South Sudan"
    }, {
        v: "ES",
        t: "Spain"
    }, {
        v: "LK",
        t: "Sri Lanka"
    }, {
        v: "SD",
        t: "Sudan"
    }, {
        v: "SR",
        t: "Suriname"
    }, {
        v: "SJ",
        t: "Svalbard and Jan Mayen"
    }, {
        v: "SZ",
        t: "Swaziland"
    }, {
        v: "SE",
        t: "Sweden"
    }, {
        v: "CH",
        t: "Switzerland"
    }, {
        v: "SY",
        t: "Syrian Arab Republic"
    }, {
        v: "TW",
        t: "Taiwan"
    }, {
        v: "TJ",
        t: "Tajikistan"
    }, {
        v: "HM",
        t: "Territory of Heard Island and McDonald Islands"
    }, {
        v: "TH",
        t: "Thailand"
    }, {
        v: "BS",
        t: "The Commonwealth of The Bahamas"
    }, {
        v: "ZR",
        t: "The Democratic Republic Of The Congo"
    }, {
        v: "CG",
        t: "The Republic of Congo"
    }, {
        v: "MH",
        t: "The Republic of Marshall Islands"
    }, {
        v: "VA",
        t: "The Vatican City State"
    }, {
        v: "TLS",
        t: "Timor-Leste"
    }, {
        v: "TG",
        t: "Togo"
    }, {
        v: "TK",
        t: "Tokelau"
    }, {
        v: "TO",
        t: "Tonga"
    }, {
        v: "TT",
        t: "Trinidad and Tobago"
    }, {
        v: "TN",
        t: "Tunisia"
    }, {
        v: "TR",
        t: "Turkey"
    }, {
        v: "TM",
        t: "Turkmenistan"
    }, {
        v: "TC",
        t: "Turks and Caicos Islands"
    }, {
        v: "TV",
        t: "Tuvalu"
    }, {
        v: "VI",
        t: "U.S.Virgin Islands"
    }, {
        v: "UG",
        t: "Uganda"
    }, {
        v: "UA",
        t: "Ukraine"
    }, {
        v: "AE",
        t: "United Arab Emirates"
    }, {
        v: "UK",
        t: "United Kingdom"
    }, {
        v: "TZ",
        t: "United Republic of Tanzania"
    }, {
        v: "US",
        t: "United States"
    }, {
        v: "UM",
        t: "United States Minor Outlying Islands"
    }, {
        v: "UY",
        t: "Uruguay"
    }, {
        v: "UZ",
        t: "Uzbekistan"
    }, {
        v: "VU",
        t: "Vanuatu"
    }, {
        v: "VE",
        t: "Venezuela"
    }, {
        v: "VN",
        t: "Vietnam"
    }, {
        v: "WF",
        t: "Wallis And Futuna"
    }, {
        v: "EH",
        t: "Western sahara"
    }, {
        v: "YE",
        t: "Yemen"
    }, {
        v: "ZM",
        t: "Zambia"
    }, {
        v: "EAZ",
        t: "Zanzibar"
    }, {
        v: "ZW",
        t: "Zimbabwe"
    }],
    countryMapping: {
        GB: "UK",
        AX: "ALA",
        CG: "CG",
        CD: "CG",
        JE: "JEY",
        KV: "KS",
        ME: "MNE",
        RS: "SRB",
        GS: "SGS",
        GG: "GGY",
        BL: "BLM"
    },
    regionMapping: {
        US: {
            PR: {
                countryRegion: "PR",
                region: ""
            }
        }
    },
    phoneCountryCodes: {
        AD: "+376",
        AE: "+971",
        AF: "",
        AG: "+1 (268)",
        AI: "",
        AL: "+355",
        AM: "+374",
        AN: "",
        AO: "+244",
        AQ: "",
        AR: "+54",
        AS: "",
        ASC: "",
        AT: "+43",
        AU: "+61",
        AW: "+297",
        AX: "",
        AZ: "+994",
        BA: "+387",
        BB: "+1 (246)",
        BD: "+880",
        BE: "+32",
        BF: "+226",
        BG: "+359",
        BH: "+973",
        BI: "+257",
        BJ: "+229",
        BL: "",
        BM: "+1 (441)",
        BN: "+673",
        BO: "+591",
        BQ: "",
        BR: "+55",
        BS: "+1 (242)",
        BT: "+975",
        BV: "",
        BW: "+267",
        BY: "+375",
        BZ: "+501",
        CA: "+1",
        CC: "",
        CD: "+243",
        CF: "+236",
        CG: "+242",
        CH: "+41",
        CI: "+225",
        CK: "",
        CL: "+56",
        CM: "+237",
        CN: "+86",
        CO: "+57",
        CR: "+506",
        CU: "+53",
        CV: "+238",
        CW: "",
        CX: "",
        CY: "+357",
        CZ: "+420",
        DE: "+49",
        DJ: "+253",
        DK: "+45",
        DM: "+1 (767)",
        DO: "+1 (8)",
        DZ: "+213",
        EAZ: "",
        EC: "+593",
        EE: "+372",
        EG: "+20",
        EH: "+212",
        ER: "+291",
        ES: "+34",
        ET: "+251",
        FI: "+358",
        FJ: "+679",
        FK: "+500",
        FM: "+691",
        FO: "+298",
        FR: "+33",
        GA: "+241",
        GB: "+44",
        GBA: "",
        GD: "+1 (473)",
        GE: "+995",
        GF: "+594",
        GG: "+44",
        GGY: "+44",
        GH: "+233",
        GI: "+350",
        GL: "+299",
        GM: "+220",
        GN: "+224",
        GP: "+590",
        GQ: "+240",
        GR: "+30",
        GT: "+502",
        GU: "",
        GW: "+245",
        GY: "+592",
        HM: "",
        HN: "+504",
        HR: "+385",
        HT: "+509",
        HU: "+36",
        ID: "+62",
        IE: "+353",
        IL: "+972",
        IM: "+44",
        IN: "+91",
        IO: "",
        IQ: "+964",
        IR: "+98",
        IS: "+354",
        IT: "+39",
        JE: "+44",
        JEY: "+44",
        JM: "+1 (876)",
        JO: "+962",
        JP: "+81",
        KE: "+254",
        KG: "+996",
        KH: "",
        KI: "+686",
        KM: "+269",
        KN: "+1 (869)",
        KP: "+850",
        KR: "+82",
        KS: "",
        KW: "+965",
        KY: "+1 (345)",
        KZ: "+77",
        LA: "+856",
        LB: "+961",
        LC: "+1 (758)",
        LI: "+423",
        LK: "+94",
        LR: "+231",
        LS: "+266",
        LT: "+370",
        LU: "+352",
        LV: "+371",
        LY: "+218",
        MA: "+212",
        MC: "+377",
        MD: "+373",
        ME: "+382",
        MNE: "+382",
        MF: "",
        MG: "+261",
        MH: "+692",
        MK: "+389",
        ML: "+223",
        MM: "+95",
        MN: "+976",
        MP: "",
        MQ: "+596",
        MR: "+222",
        MS: "",
        MT: "+356",
        MU: "+230",
        MV: "+960",
        MW: "+265",
        MX: "+52",
        MY: "+60",
        MZ: "+258",
        NA: "+264",
        NC: "+687",
        NE: "+227",
        NF: "",
        NG: "+234",
        NI: "+505",
        NL: "+31",
        NO: "+47",
        NP: "+977",
        NR: "+674",
        NU: "",
        NZ: "+64",
        OM: "+968",
        PA: "+507",
        PE: "+51",
        PF: "+689",
        PG: "+675",
        PH: "+63",
        PK: "+92",
        PL: "+48",
        PM: "+508",
        PN: "",
        PR: "+1",
        PS: "",
        PT: "+351",
        PW: "+680",
        PY: "+595",
        QA: "+974",
        RE: "+262",
        RO: "+40",
        RS: "+381",
        SRB: "+381",
        RU: "+7",
        RW: "+250",
        SA: "+966",
        SB: "+677",
        SC: "+248",
        SD: "+249",
        SE: "+46",
        SG: "+65",
        SGS: "",
        SH: "",
        SI: "+386",
        SJ: "+47",
        SK: "+421",
        SL: "+232",
        SM: "+378",
        SN: "+221",
        SO: "+252",
        SR: "+597",
        SS: "+211",
        ST: "+239",
        SV: "+503",
        SX: "+590",
        SY: "+963",
        SZ: "+268",
        TC: "+1 (649)",
        TD: "+235",
        TF: "",
        TG: "+228",
        TH: "+66",
        TJ: "+992",
        TK: "",
        TL: "+670",
        TM: "+993",
        TN: "+216",
        TO: "+676",
        TR: "+90",
        TT: "+1 (868)",
        TV: "+688",
        TZ: "+255",
        UA: "+380",
        UG: "+256",
        UM: "",
        US: "+1",
        UY: "+598",
        UZ: "+998",
        VA: "+39 (066)",
        VC: "+1 (784)",
        VE: "+58",
        VG: "+1 (284)",
        VI: "",
        VN: "+84",
        VU: "+678",
        WF: "+681",
        WS: "+685",
        YE: "+967",
        YT: "+262",
        ZA: "+27",
        ZM: "+260",
        ZW: "+263",
        UK: "+44",
        HK: "+852"
    },
    api: {
        root_url: "http://plugins.ru/",
        product_list_url_part: "/wp-admin/admin.php?page=a2w_import",
        generateAuthCookie: "&a2w-json=auth/generate_auth_cookie",
        validateAuthCookie: "&a2w-json=auth/validate_auth_cookie",
        importList: "&a2w-json=get_products",
        productImport: "&a2w-json=add_product",
        productImportUpdate: "&a2w-json=upd_product",
        productDelete: "&a2w-json=del_product",
        getSettings: "&a2w-json=get_settings",
        orderSync: "&a2w-json=upd_order",
        checkProductsImported: "&a2w-json=get_products_info",
        getOrders: "&a2w-json=get_orders",
        updateTrackingData: "&a2w-json=update_tracking_data"
    },
}

const mainPanel = {
    parser: null,
    containerId: 'ma-main-panel',
    buttonId: 'ma-import-all',

    init(passedParser) {
        if (passedParser) this.setParser(passedParser);

        document.body.addEventListener('click', (e) => {
            if (e.target.id === this.buttonId && this.shouldShowImportAllButton()) {
                e.preventDefault();
                this.parser.clickImportAllHandler();
            }
        });
    },

    render(passedParser) {
        const html =
            '<div id="' + this.containerId + '">' +
            '<button id="' + this.buttonId + '">Import all products</button>' +
            '</div>';
        MAHtml.prependHtml(document, document.body, html);

        this.init(passedParser);

        if (!this.shouldShowImportAllButton()) {
            this.hideImportAllButton();
        }
    },

    setParser(p) {
        this.parser = p;
        if (this.shouldShowImportAllButton) {
            this.showImportAllButton();
        } else {
            this.hideImportAllButton();
        }
    },

    shouldShowImportAllButton() {
        return !!(this.parser && typeof this.parser.clickImportAllHandler === 'function');
    },

    hideImportAllButton() {
        const btn = document.getElementById(this.buttonId);
        if (btn) btn.style.display = 'none';
    },

    showImportAllButton() {
        const btn = document.getElementById(this.buttonId);
        if (btn) btn.style.display = '';
    }
}

class Panel {
    constructor(config) {
        this.iconClose = config.iconClose || '';
        this.svgLogo = config.svgLogo || '';
        this.state = config.state || {};
        this.isBusy = !!this.state.isBusy;
        this.ids = {
            container: config.containerId,
            content: config.contentId,
            close: config.closeId
        };
        this.defaultAutoClearTextMs = config.defaultAutoClearTextMs || 4000;
        this._clearTextTimeout = null;

        this.remove(); // очищаем старый контейнер при создании
    }

    remove() {
        const container = document.getElementById(this.ids.container);
        if (container) container.outerHTML = '';
        this.cancelClearText();
    }

    render(config = {}) {

        this.state = config.state || this.state;

        let container = document.getElementById(this.ids.container);

        if (!container) {
            let html = '';
            html += `<div id="${this.ids.container}" class="ma-panel">`;
            html += '  <div class="ma-panel-header">';
            html += `    <a href="#" id="${this.ids.close}" class="close">`;
            html += `      <img src="${this.iconClose}" alt="Close">`;
            html += '    </a>';
            html += `    <img src="${this.svgLogo}" alt="logo" class="ma-logo">`;
            html += '  </div>';
            html += `  <div id="${this.ids.content}" class="ma-panel-content">`;

            if (this.state.iconUrl) {
                let iconUrl = chrome.runtime.getURL(this.state.iconUrl);
                html += `<div class="img"><img src="${iconUrl}"></div>`;
            }

            html += `<h2 class="state" role="status" aria-live="polite">${this.state.text || ''}</h2>`;
            html += this.getButtonsHTML();

            if (config.showProgressLog) {
                html += '<div class="progress-log"></div>';
            }

            html += '  </div>';
            html += '</div>';

            let stack = document.getElementById('ma-panels-stack');
            if (!stack) {
                stack = document.createElement('div');
                stack.id = 'ma-panels-stack';
                stack.style.position = 'fixed';
                stack.style.top = '20px';
                stack.style.right = '20px';
                stack.style.zIndex = '1000';
                stack.style.display = 'flex';
                stack.style.flexDirection = 'column';
                stack.style.gap = '12px';
                document.body.appendChild(stack);
            }

            stack.insertAdjacentHTML('beforeend', html);

            const closeBtn = document.getElementById(this.ids.close);
            if (closeBtn) {
                closeBtn.addEventListener('click', e => {
                    e.preventDefault();
                    this.remove();
                });
            }
        } else {
            const contentEl = container.querySelector(`#${this.ids.content}`);
            if (contentEl) {
                const textEl = contentEl.querySelector('.state');
                if (textEl) textEl.innerText = this.state.text || '';

                const oldButtons = contentEl.querySelector('p');
                if (oldButtons) oldButtons.remove();
                const buttonsHTML = this.getButtonsHTML();
                if (buttonsHTML) {
                    contentEl.insertAdjacentHTML('beforeend', buttonsHTML);
                }

                if (this.state.iconUrl) {
                    let iconUrl = chrome.runtime.getURL(this.state.iconUrl);

                    let imgEl = contentEl.querySelector('.img img');
                    if (imgEl) {
                        imgEl.src = iconUrl;
                    } else {
                        const imgDiv = document.createElement('div');
                        imgDiv.className = 'img';
                        const img = document.createElement('img');
                        img.src = iconUrl;
                        imgDiv.appendChild(img);
                        contentEl.insertBefore(imgDiv, contentEl.firstChild);
                    }
                }
            }
        }
    }
    updateText(newText, autoClearMs) {
        const textEl = document.querySelector(`#${this.ids.content} .state`);
        if (textEl) textEl.innerText = newText;

        this.cancelClearText();
        const ms = (typeof autoClearMs === 'number') ? autoClearMs : this.defaultAutoClearTextMs;
        if (ms > 0) {
            this._clearTextTimeout = setTimeout(() => {
                this.clearText();
                this._clearTextTimeout = null;
            }, ms);
        }
    }

    updateActions(actions) {
        const contentEl = document.querySelector(`#${this.ids.content}`);
        if (!contentEl) return;

        const oldButtons = contentEl.querySelector('p');
        if (oldButtons) oldButtons.remove();

        this.state.actions = actions;

        if (Array.isArray(actions)) {
            const p = document.createElement('p');
            actions.forEach(action => {
                const link = document.createElement('a');
                link.id = action.id;
                link.href = '#';
                link.innerText = action.title || '...';

                if (typeof action.action === 'function') {
                    link.addEventListener('click', e => {
                        e.preventDefault();
                        action.action(action.arg);
                    });
                }

                p.appendChild(link);
            });
            contentEl.appendChild(p);
        }
    }

    updateState(newState) {
        if (newState.text) this.updateText(newState.text, 0);

        if (newState.iconUrl) {
            const imgEl = document.querySelector(`#${this.ids.content} .img img`);
            if (imgEl) {
                imgEl.src = newState.iconUrl;
            } else {
                const contentEl = document.querySelector(`#${this.ids.content}`);
                if (contentEl) {
                    const imgDiv = document.createElement('div');
                    imgDiv.className = 'img';
                    const img = document.createElement('img');
                    img.src = newState.iconUrl;
                    imgDiv.appendChild(img);
                    contentEl.insertBefore(imgDiv, contentEl.firstChild);
                }
            }
        }

        if (newState.actions) this.updateActions(newState.actions);
        if (newState.progress) this.updateProgress(newState.progress);
    }

    clearText() {
        const textEl = document.querySelector(`#${this.ids.content} .state`);
        if (textEl) textEl.innerText = '';
    }

    cancelClearText() {
        if (this._clearTextTimeout) {
            clearTimeout(this._clearTextTimeout);
            this._clearTextTimeout = null;
        }
    }

    getButtonsHTML() {
        let html = '';
        const actions = this.state.actions;
        if (!Array.isArray(actions)) return html;

        actions.forEach(action => {
            let link = `<a id="${action.id}" href="#">${action.title || '...'}</a>`;
            this.attachButtonAction(action);
            html += link;
        });

        return html ? `<p>${html}</p>` : '';
    }

    attachButtonAction(action) {
        const body = document.querySelector('body');
        if (body && typeof action.action === 'function') {
            body.addEventListener('click', e => {
                if (e.target?.id === action.id) {
                    e.preventDefault();
                    action.action(action.arg);
                }
            });
        }
    }

    updateProgress(entry) {
        const container = document.querySelector(`#${this.ids.content} .progress-log`);
        if (!container) return;

        let item = container.querySelector('.progress-item-single');
        if (!item) {
            item = document.createElement('div');
            item.className = 'progress-item-single';
            container.appendChild(item);
        } else {
            item.innerHTML = '';
        }

        if (typeof entry === 'string') {
            item.innerText = entry;
        } else if (typeof entry === 'object') {
            const textEl = document.createElement('div');
            textEl.innerText = entry.text || '';
            item.appendChild(textEl);

            if (Array.isArray(entry.actions)) {
                entry.actions.forEach(action => {
                    const link = document.createElement('a');
                    link.id = action.id;
                    link.href = '#';
                    link.innerText = action.title || '...';
                    link.setAttribute('role', 'button');

                    if (typeof action.action === 'function') {
                        link.addEventListener('click', e => {
                            e.preventDefault();
                            action.action(action.arg);
                        });
                    }

                    item.appendChild(link);
                });
            }
        }
    }
}


let _importPanelInstance = null;

function getImportPanel() {
    if (!_importPanelInstance) {
        _importPanelInstance = new Panel({
            containerId: 'ma-import-container',
            contentId: 'ma-import-panel-content',
            closeId: 'ma-close-import-popup',
            iconClose: chrome.runtime.getURL(config.assets.iconClose),
            svgLogo: chrome.runtime.getURL(config.assets.svgLogo)
        });
    }
    return _importPanelInstance;
}



const messagePanel = {
    iconClose: '',
    svgLogo: '',
    state: {},
    isBusy: false,

    init(config) {
        const state = config.state || {};
        messagePanel.isBusy = !!state.isBusy;
        messagePanel.iconClose = config.iconClose || '';
        messagePanel.svgLogo = config.svgLogo || '';
        messagePanel.state = state;

        messagePanel.remove();

        const body = document.querySelector('body');
        if (body) {
            body.addEventListener('click', function(e) {
                const parent = e.target?.parentElement;
                if (parent && parent.id === 'ma-close-popup') {
                    e.preventDefault();
                    messagePanel.remove();
                }
            });
        }
    },

    remove() {
        const container = document.getElementById('ma-import-container');
        if (container) {
            container.outerHTML = '';
        }
    },

    updateText(newText) {
        const textEl = document.querySelector('#ma-panel-import-content .state');
        if (textEl) {
            textEl.innerText = newText;
        }
    },

    applyDefaults(config) {
        config = config || {};
        config.state = config.state || {};
        config.state.isBusy = config.state.isBusy || false;
        config.iconClose = config.iconClose || chrome.runtime.getURL(config.assets.iconClose);
        config.svgLogo = config.svgLogo || chrome.runtime.getURL(config.assets.svgLogo);
        return config;
    },

    simpleTpl(text) {
        return messagePanel.applyDefaults({
            state: {
                text
            },
            iconClose: chrome.runtime.getURL(config.assets.iconClose),
            svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
        });
    },

    simpleErrorTpl(text) {
        return messagePanel.applyDefaults({
            state: {
                iconUrl: config.assets.iconImportError,
                text
            },
            iconClose: chrome.runtime.getURL(config.assets.iconClose),
            svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
        });
    },

    render(config) {
        messagePanel.init(config);

        let html = '';
        html += '<div id="ma-import-container" class="ma-panel ma-panel-import">';
        html += '<div class="ma-panel-header">';
        html += '<a href="#" id="ma-close-popup" class="close">';
        html += '<img src="' + messagePanel.iconClose + '" alt="Close icon">';
        html += '</a>';
        html += '<img src="' + messagePanel.svgLogo + '" alt="ma logo" class="ma-logo">';
        html += '</div>';
        html += '<div id="ma-panel-import-content" class="ma-panel-import-content">';
        html += '<div>';
        html += messagePanel.getStatusHTML();
        html += '<h2><div class="state">' + (messagePanel.state.text || '') + '</div></h2>';
        html += '<div></div>';
        html += messagePanel.getButtonsHTML();
        html += '<div class="progress-log"></div>';
        html += '</div></div></div>';

        let stack = document.getElementById('ma-panels-stack');
        if (!stack) {
            stack = document.createElement('div');
            stack.id = 'ma-panels-stack';
            stack.style.position = 'fixed';
            stack.style.top = '10px';
            stack.style.right = '10px';
            stack.style.zIndex = '1000';
            stack.style.display = 'flex';
            stack.style.flexDirection = 'column';
            stack.style.gap = '10px';
            document.body.appendChild(stack);
        }

        stack.insertAdjacentHTML('beforeend', html);
    },

    getStatusHTML() {
        const iconUrl = messagePanel.state.iconUrl;
        return iconUrl ? '<div class="img"><img src="' + chrome.runtime.getURL(iconUrl) + '"></div>' : '';
    },

    getButtonsHTML() {
        let html = '';
        const actions = messagePanel.state.actions;
        if (!Array.isArray(actions)) return html;

        for (let i = 0; i < actions.length; i++) {
            const action = actions[i];
            let link = '<a ';
            let titleText = '';

            for (const key in action) {
                if (Object.prototype.hasOwnProperty.call(action, key)) {
                    if (key === 'title') {
                        titleText = action[key];
                    } else if (key === 'action') {
                        messagePanel.attachButtonAction(action);
                    } else if (key !== 'arg') {
                        link += key + '="' + action[key] + '" ';
                    }
                }
            }

            link += '>' + titleText + '</a>';
            html += link;
        }

        return html ? '<p>' + html + '</p>' : '';
    },

    attachButtonAction(action) {
        const body = document.querySelector('body');
        if (body && typeof action.action === 'function') {
            body.addEventListener('click', function(e) {
                if (e.target?.id === action.id) {
                    e.preventDefault();
                    action.action(action.arg);
                }
            });
        }
    },

    safeUpdateProgress: function(entry) {
        let container = document.querySelector('#ma-panel-import-content .progress-log');

        if (!container) {

            const defaultState = {
                state: {
                    text: ``,
                    actions: []
                },
                iconClose: chrome.runtime.getURL(config.assets.iconClose),
                svgLogo: chrome.runtime.getURL(config.assets.svgLogo)
            };
            messagePanel.render(defaultState);
        }

        messagePanel.updateProgress(entry);
    },

    updateProgress: function(entry) {
        const container = document.querySelector('#ma-panel-import-content .progress-log');
        if (!container) return;

        let item = container.querySelector('.progress-item-single');
        if (!item) {
            item = document.createElement('div');
            item.className = 'progress-item-single';
            container.appendChild(item);
        } else {
            item.innerHTML = '';
        }

        if (typeof entry === 'string') {
            item.innerText = entry;
        } else if (typeof entry === 'object') {
            const textEl = document.createElement('div');
            textEl.innerText = entry.text || '';
            item.appendChild(textEl);

            if (Array.isArray(entry.actions)) {
                entry.actions.forEach(action => {
                    const link = document.createElement('a');
                    link.innerText = action.title || '...';
                    link.setAttribute('href', '#');
                    link.setAttribute('role', 'button'); // для доступности
                    link.style.display = 'block'; // если нужно переопределить inline

                    // Применяем остальные атрибуты
                    for (const key in action) {
                        if (action.hasOwnProperty(key) && !['title', 'action', 'arg'].includes(key)) {
                            link.setAttribute(key, action[key]);
                        }
                    }

                    if (typeof action.action === 'function') {
                        link.addEventListener('click', function(e) {
                            e.preventDefault();
                            action.action(action.arg);
                        });
                    }

                    item.appendChild(link);
                });
            }
        }
    },

    clearProgress: function() {
        const item = document.querySelector('#ma-panel-import-content .progress-log .progress-item-single');
        if (item) item.innerHTML = '';
    }
};

const shippingPanel = {
    iconClose: '',
    svgLogo: '',
    state: {},
    isBusy: false,

    _clearTextTimeout: null,
    defaultAutoClearTextMs: 4000,

    init(config) {
        const state = config.state || {};
        this.isBusy = !!state.isBusy;
        this.iconClose = config.iconClose || '';
        this.svgLogo = config.svgLogo || '';
        this.state = state;

        this.remove();
    },

    remove() {
        const container = document.getElementById('ma-shipping-container');
        if (container) {
            container.outerHTML = '';
        }
        this.cancelClearText();
    },

    render(config) {
        this.init(config);

        let html = '';
        html += '<div id="ma-shipping-container" class="ma-panel ma-panel-shipping">';
        html += '  <div class="ma-panel-header">';
        html += '    <a href="#" id="ma-close-shipping-popup" class="close">';
        html += '      <img src="' + this.iconClose + '" alt="Close">';
        html += '    </a>';
        html += '    <img src="' + this.svgLogo + '" alt="Shipping logo" class="ma-logo">';
        html += '  </div>';
        html += '  <div id="ma-panel-shipping-content" class="ma-panel-shipping-content">';
        html += '    <h2 class="state" role="status" aria-live="polite">' + (this.state.text || '') + '</h2>';
        html += this.getButtonsHTML();
        html += '  </div>';
        html += '</div>';

        let stack = document.getElementById('ma-panels-stack');
        if (!stack) {
            stack = document.createElement('div');
            stack.id = 'ma-panels-stack';
            stack.style.position = 'fixed';
            stack.style.top = '20px';
            stack.style.right = '20px';
            stack.style.zIndex = '1000';
            stack.style.display = 'flex';
            stack.style.flexDirection = 'column';
            stack.style.gap = '12px';
            document.body.appendChild(stack);
        }

        stack.insertAdjacentHTML('beforeend', html);

        const closeBtn = document.querySelector('#ma-close-shipping-popup');
        if (closeBtn) {
            closeBtn.addEventListener('click', e => {
                e.preventDefault();
                this.remove();
            });
        }
    },

    updateText(newText, autoClearMs) {
        const textEl = document.querySelector('#ma-panel-shipping-content .state');
        if (textEl) {
            textEl.innerText = newText;
        }

        this.cancelClearText();

        const ms = (typeof autoClearMs === 'number') ? autoClearMs : this.defaultAutoClearTextMs;
        if (typeof ms === 'number' && ms > 0) {
            this._clearTextTimeout = setTimeout(() => {
                this.clearText();
                this._clearTextTimeout = null;
            }, ms);
        }
    },

    clearText() {
        const textEl = document.querySelector('#ma-panel-shipping-content .state');
        if (textEl) textEl.innerText = '';
    },

    cancelClearText() {
        if (this._clearTextTimeout) {
            clearTimeout(this._clearTextTimeout);
            this._clearTextTimeout = null;
        }
    },

    getButtonsHTML() {
        let html = '';
        const actions = this.state.actions;
        if (!Array.isArray(actions)) return html;

        for (let i = 0; i < actions.length; i++) {
            const action = actions[i];
            let link = '<a ';
            let titleText = '';

            for (const key in action) {
                if (Object.prototype.hasOwnProperty.call(action, key)) {
                    if (key === 'title') {
                        titleText = action[key];
                    } else if (key === 'action') {
                        this.attachButtonAction(action);
                    } else if (key !== 'arg') {
                        link += key + '="' + action[key] + '" ';
                    }
                }
            }

            link += '>' + titleText + '</a>';
            html += link;
        }

        return html ? '<p>' + html + '</p>' : '';
    },

    attachButtonAction(action) {
        const body = document.querySelector('body');
        if (body && typeof action.action === 'function') {
            body.addEventListener('click', function(e) {
                if (e.target?.id === action.id) {
                    e.preventDefault();
                    action.action(action.arg);
                }
            });
        }
    }
};





var MA_Auth = {
    //content:
    testConnection: function(f) {
        messagePanel.render({
            iconClose: chrome.runtime.getURL(config.assets.iconClose),
            svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
            state: MA_Auth.getTestConnectionStateData()
        });

        chrome.runtime.sendMessage({
            action: config.actions.CONTENT_TEST_CONNECTION
        }, function(e) {

            messagePanel.render({
                iconClose: chrome.runtime.getURL(config.assets.iconClose),
                svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                state: MA_Auth.getTestedConnectionStateData(e)
            });

            f(e);
        });
    },

    getTestConnectionStateData: function() {
        var t = {
            text: "Attempting to authenticate...",
            isBusy: true,
        };
        return t
    },

    getTestedConnectionStateData: function(e) {

        var t = {};
        if (e.status === 'ok') {
            t = {
                text: 'Authentication is successful!',
                isBusy: false,
                iconUrl: config.assets.iconImportSuccess,
                actions: []
            };
        } else {
            t = {
                text: 'Authentication failed. ' + e.error,
                isBusy: false,
                iconUrl: config.assets.iconImportError,
                actions: [{
                    id: "ma-to-settings",
                    href: "/options.html",
                    target: "_blank",
                    className: '',
                    title: "Configure settings",
                    arg: '',
                    action: MA_Auth.openSettingTab
                }]
            };
        }

        return t;
    },
    getCustomStateData: function(e) {
        var t = {};

        return e.success ? (t = {
            text: e.msg,
            iconUrl: config.assets.iconImportSuccess,
        }) : (t = {
            text: e.msg,
            iconUrl: config.assets.iconImportError,
        }), t
    },
    openSettingTab: function() {
        chrome.runtime.sendMessage({ action: config.actions.CONTENT_OPEN_SETTING_TAB }, function(e) {});
    }
}

const MAProduct = {
    /**
     * Extracts the product ID from an AliExpress URL.
     * Supports both standard product URLs (e.g. /item/12345.html)
     * and bundle URLs with productIds parameter (e.g. productIds=12345:67890).
     *
     * @param {string} url - The full product or bundle URL.
     * @returns {string|false} - The extracted product ID, or false if not found.
     */
    getProductIdFromUrl: function (url) {
        let id = false;

        const htmlMatch = url.match(/.+\/([0-9,_]+)\.html/mi);
        if (htmlMatch) {
            const parts = htmlMatch[1].split('_');
            id = parts.length > 1 ? parts[1] : parts[0];
        } else {
            const queryMatch = url.match(/[?&]productIds=([0-9]+)(?::[0-9]+)?/i);
            if (queryMatch) {
                id = queryMatch[1];
            }
        }

        return id;
    },
    /**
     * Get product description be chrome extension
     */
    requestProductInfo: function (t, r, f) {
        
        var e = { "status": '404', "data": '', "error_msg": "this method is not implemented in chrome extension!", "reqId": r };
        if (typeof f !== "undefined") f(e);

        /*
        chrome.extension.sendMessage({
            action: config.actions.CONTENT_GET_PRODUCT_INFO,
            params: t,
            reqId: r
        }, function(e) {

            if (typeof f !== "undefined") f(e);

        });*/
    },
    pushProduct: function(e, i, th, pmn, pmx, ttl, cur, apd, f) {

        return new Promise(function(resolve, reject) {

            const importPanel = getImportPanel();

            importPanel.render({
                state: MAProduct.getPushStateData({ id: i })
            });

            chrome.runtime.sendMessage({
                action: config.actions.CONTENT_PUSH_PRODUCT_TO_APP,
                url: e,
                id: i,
                thumb: th,
                price_min: pmn,
                price_max: pmx,
                title: ttl,
                currency: cur,
                apd: apd,
            }, function(resp) {
                resp.success = resp.status === 'OK';

                config.get_ext_options(function(v) {
                    const ext_options = v;

                    importPanel.render({
                        state: MAProduct.getPushedStateData({
                            id: resp.id,
                            url: resp.url,
                            th: resp.th,
                            pmn: resp.pmn,
                            pmx: resp.pmx,
                            ttl: resp.ttl,
                            cur: resp.cur,
                            success: resp.success,
                            api_root_url: ext_options.api_root_url,
                            msg: resp.status_text || ''
                        })
                    });
                });

                if (typeof f !== "undefined") f();

                if (resp.status === 'OK') resolve({ data: resp });
                else reject(new Error(resp.status_text || ''));
            });
        });

    },
    pushProductSilent: function(e, i, th, pmn, pmx, ttl, cur, apd) {
        return new Promise(function(resolve, reject) {
            //  setTimeout( function(){ 
            chrome.runtime.sendMessage({
                action: config.actions.CONTENT_PUSH_PRODUCT_TO_APP,
                url: e,
                id: i,
                thumb: th,
                price_min: pmn,
                price_max: pmx,
                title: ttl,
                currency: cur,
                apd: apd,
            }, function(e) {
                if (e.status == 'OK') {
                    e.success = true;
                }
                else if (e.status == 'error' && e.status_text == "Product already imported.") {
                    e.success = true;
                }
                else if (e.status == 'warning' && e.status_text == "Product already exist") {
                    e.success = true;
                } else e.success = false;

                if (e.status == 'OK') {
                    resolve({ data: e });
                }
                else {
                    reject(new Error((typeof e.status_text !== 'undefined') ? e.status_text : ''));
                }
            });
        });
    },
    pushProductArr: async function(p) {
        if (!p || p.length === 0) return;

        let failed_p = [];

        while (p.length > 0) {
            const el = p.shift(); // take first product

            try {
                // state before push
                messagePanel.render({
                    iconClose: chrome.runtime.getURL(config.assets.iconClose),
                    svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                    state: MAProduct.getMassPushStateData({ success: true, number: p.length + 1 }),
                });

                // get product info and push
                const productInfo = await new Promise((resolve, reject) => {
                    const reqId = Math.random().toString();
                    MAProduct.requestProductInfo({ id: el.id }, reqId, d => resolve(d));
                });

                await MAProduct.pushProductSilent(
                    el.url, el.id, el.thumb,
                    el.price_min, el.price_max,
                    el.title, el.currency,
                    productInfo.data
                );

            } catch (err) {
                failed_p.push(el);

                if (err.message === "Can`t find Active store") {
                    messagePanel.render({
                        iconClose: chrome.runtime.getURL(config.assets.iconClose),
                        svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                        state: MA_Auth.getTestedConnectionStateData({ status: 'no', error: err.message }),
                    });
                    break; // break whole process
                } else if (err.message === "Product already imported.") {
                    messagePanel.render({
                        iconClose: chrome.runtime.getURL(config.assets.iconClose),
                        svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                        state: MAProduct.getMassPushedWarningStateData({ error: err.message + " Skip it..." }),
                    });
                    // continue
                } else {
                    console.log(err.message);
                }
            }
        }

        // final state
        let params = { success: failed_p.length === 0 };
        if (failed_p.length > 0) {
            params.error = failed_p.length + ' products could not be imported.\n Would you like to retry importing them?';
            params.arr = failed_p;
        }

        messagePanel.render({
            iconClose: chrome.runtime.getURL(config.assets.iconClose),
            svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
            state: MAProduct.getMassPushedStateData(params),
        });
    },

    sendProductHtml: function(e, i) {

        messagePanel.render({
            iconClose: chrome.runtime.getURL(config.assets.iconClose),
            svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
            state: MAProduct.getPushHtmlStateData({ id: i }),
        });

        chrome.runtime.sendMessage({
            action: config.actions.GET_AND_PUSH_PRODUCT_HTML_TO_APP,
            url: e,
            id: i
        }, function(e) {
            if (e.status == 'OK') e.success = true;
            else e.success = false;

            config.get_ext_options(function(v) {

                ext_options = v;

                messagePanel.render({
                    iconClose: chrome.runtime.getURL(config.assets.iconClose),
                    svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                    state: MAProduct.getPushedHtmlStateData({
                        id: e.id,
                        success: e.success,
                        api_root_url: ext_options.root_url,
                        msg: ((typeof e.status_text !== 'undefined') ? e.status_text : '')
                    })
                });
            });
        })

    },
    syncProductList: function() {

        messagePanel.render({
            iconClose: chrome.runtime.getURL(config.assets.iconClose),
            svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
            state: MAProduct.getSyncStateData()
        });


        chrome.runtime.sendMessage({
            action: config.actions.SYNC_PRODUCT_LIST
        }, function(e) {
            if (e.status == 'OK') e.success = true;
            else e.success = false;

            messagePanel.render({
                iconClose: chrome.runtime.getURL(config.assets.iconClose),
                svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                state: MAProduct.getSyncedStateData({ success: e.success, msg: ((typeof e.status_text !== 'undefined') ? e.status_text : '') }),
            });

        })
    },
    removeProduct: function(e) {

        messagePanel.render({
            iconClose: chrome.runtime.getURL(config.assets.iconClose),
            svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
            state: MAProduct.getRemoveStateData({ id: e.id })
        });

        chrome.runtime.sendMessage({
            action: config.actions.CONTENT_DELETE_PRODUCT_FROM_APP,
            id: e.id
        }, function(e) {

            if (e.status == 'OK') e.success = true;
            else
                e.success = false;

            messagePanel.render({
                iconClose: chrome.runtime.getURL(config.assets.iconClose),
                svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                state: MAProduct.getRemovedStateData({
                    id: e.id,
                    success: e.success,
                    msg: ((typeof e.status_text !== 'undefined') ? e.status_text : '')
                })
            });
        })
    },

    getSyncStateData: function() {
        var e = {
            text: "Sync product data...",
            isBusy: true,
        };
        return e
    },
    getSyncedStateData: function(e) {
        var t = {};

        return e.success ? (t = {
            text: "Product data was synced Successfully." + "<br/><br/>" + e.msg,
            iconUrl: config.assets.iconImportSuccess,
        }) : (t = {
            text: "Synchronization Failed." + "<br/><br/>" + e.msg,
            iconUrl: config.assets.iconImportError,
        }), t
    },
    getPushStateData: function(e) {
        var e = {
            text: "Product (id: " + e.id + ") being Imported...",
            isBusy: true,
        };
        return e
    },
    getMassPushStateData: function(e) {
        var e = {
            text: "Mass import product: " + e.number + " remaining, please wait...",
            isBusy: true,
        };
        return e
    },
    getMassPushedWarningStateData: function(e) {
        var t = {
            text: "The mass import product warning!\n" + e.error,
            isBusy: false,
            iconUrl: config.assets.iconImportError,
            actions: []
        };

        return t;
    },
    getMassPushedStateData: function(e) {
        var t = {
            text: e.success ? "Mass import product: completed!" : "Mass import completed with errors.\n" + e.error,
            isBusy: false,
            iconUrl: e.success ? config.assets.iconImportSuccess : config.assets.iconImportError,
            actions: []
        };

        return e.success ? void 0 : (t.actions = [
         {
            id: "ma-restart-button",
            href: "#",
            target: "_blank",
            className: '',
            title: "Yes, import",
            arg: e,
            action: async  function(i) {
                await MAProduct.pushProductArr(i.arr);
            }
        }, {
            id: "ma-close-button",
            href: "#",
            target: "_blank",
            className: '',
            title: "No, close",
            arg: e,
            action: function(e) { messagePanel.remove() }
        }]), t
    },
    getPushedStateData: function(e) {
        var t = {
            text: e.success ? "Product (id: " + e.id + ") Imported Successfully." + "<br/><br/>" + e.msg : "Product (id: " + e.id + ") Import Failed. \n\n " + e.msg,
            isBusy: false,
            iconUrl: e.success ? config.assets.iconImportSuccess : config.assets.iconImportError,
            actions: []
        };
        return e.success ? (t.actions = [{
            href: e.api_root_url + config.api.product_list_url_part,
            target: "_blank",
            title: "Open Import List"
        }, {
            id: "ma-remove-product",
            href: "#",
            target: '',
            className: "ma-text-danger",
            title: "Remove",
            arg: e.id,
            action: function(i) { MAProduct.removeProduct({ id: i }) }
        }]) : (t.actions = [{
            id: "ma-retry-button",
            href: "#",
            target: "_blank",
            className: '',
            title: "Try again",
            arg: e,
            action: function(i) { MAProduct.pushProduct(i.url, i.id, i.th, i.pmn, i.pmx, i.ttl, i.cur) }
        }, {
            id: "ma-to-settings",
            href: "#settings",
            target: "_blank",
            className: '',
            title: "Configure settings",
            arg: '',
            action: MA_Auth.openSettingTab
        }]), t
    },
    getCheckImportedStateData: function(e) {

        var t = {
            text: e.status_text,
            isBusy: false,
            iconUrl: config.assets.iconImportError,
            actions: []
        };

        if (e.status_text == "Can`t find Active store" || e.status_text == "Can't connect to your store using this key.") {
            t.actions = [{
                id: "ma-to-settings",
                href: "#settings",
                target: "_blank",
                className: '',
                title: "Configure settings",
                arg: '',
                action: MA_Auth.openSettingTab
            }]
        }

        return t;
    },
    getPushHtmlStateData: function(e) {
        var e = {
            text: "Product html (id: " + e.id + ") being Imported...",
            isBusy: true,
        };
        return e
    },
    getPushedHtmlStateData: function(e) {
        var t = {
            text: e.success ? "Product html (id: " + e.id + ") Imported Successfully." + "<br/><br/>" + e.msg : "Product html (id: " + e.id + ") Import Failed. \n\n " + e.msg,
            isBusy: false,
            iconUrl: e.success ? config.assets.iconImportSuccess : config.assets.iconImportError,
            actions: []
        };
        return e.success ? (t.actions = [{
            id: "ma-close-button",
            href: "#",
            target: "_blank",
            className: '',
            title: "OK",
            arg: e,
            action: function(e) { messagePanel.remove() }
        }]) : (t.actions = [{
            id: "ma-retry-button",
            href: "#",
            target: "_blank",
            className: '',
            title: "Try again",
            arg: e,
            action: function(i) { MAProduct.sendProductHtml(i.url, i.id) }
        }]), t
    },
    getRemoveStateData: function(e) {
        var e = {
            text: "Deleting product (id: " + e.id + ")...",
            isBusy: true,
        };
        return e
    },
    getRemovedStateData: function(e) {
        var t = {};

        return e.success ? (t = {
            text: "Product (id: " + e.id + ") deleted Successfully." + "<br/><br/>" + e.msg,
            iconUrl: config.assets.iconImportSuccess,
        }) : (t = {
            text: "Product (id: " + e.id + ") deleted Failed." + "<br/><br/>" + e.msg,
            iconUrl: config.assets.iconImportError,
        }), t

    },
    getAttrValueIndexes(html = "", attrArray = []) {
        var found = html.match(/window\.runParams = {([.\s\S]*?)};/i);
        var fullObjectStr = found && found[1] ? found[1].trim() : "";
        found = fullObjectStr.match(/data: {([.\s\S]*)},[.\s\S]*csrfToken/i);
        var object = found && found[1] ? JSON.parse("{" + found[1] + "}") : {};
        if (object.skuModule && object.skuModule.productSKUPropertyList) {
            return attrArray.reduce((acc, aId) => {
                const values = object.skuModule.productSKUPropertyList.reduce((acc, val, attrIndex) => {
                    let valIndex = val.skuPropertyValues.findIndex(v => v.propertyValueId.toString() === aId.toString())
                    return valIndex !== -1 ? [...acc, { attrIndex, valIndex }] : acc
                }, [])
                return [...acc, ...values];
            }, [])
        }
        return []
    }
}

var MAOrder = {
    updateOrder: function(e, f) {


        var sendUpdatedOrdersToApp = function(matchedOrders) {

            chrome.runtime.sendMessage({
                action: config.actions.CONTENT_ORDER_FULFILLMENT_RESPONSE,
                id: e.id,
                matchedOrders: (typeof matchedOrders !== "undefined") ? matchedOrders : [],
                type: (typeof e.type !== "undefined" ? e.type : false),
            }, function(e) {

                if (e.status == 'OK') e.success = true;
                else
                    e.success = false;

                messagePanel.render({
                    iconClose: chrome.runtime.getURL(config.assets.iconClose),
                    svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                    state: MAOrder.getUpdatedStateData({
                        id: e.id,
                        external_id: e.external_id,
                        success: e.success,
                        msg: ((typeof e.status_text !== 'undefined') ? e.status_text : '')
                    })
                });

                if (typeof f !== "undefined") f(e);

            })
        }

        messagePanel.render({
            iconClose: chrome.runtime.getURL(config.assets.iconClose),
            svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
            state: MAOrder.getUpdateStateData({ id: e.id })
        });

        if (e.type == "new_order_list") {

            chrome.storage.sync.set({
                stage: { action: 'order_fulfillment_update_orders', state: 'active' },
                matchOrders: [],

            }, function() {

                var ordersCount = 0;

                for (let a in e.id) {

                    ordersCount = ordersCount + 1;

                    let externalOrderId = e.id[a];

                    var iframe = document.createElement('iframe');
                    iframe.style.height = "1px";
                    iframe.style.width = "1px";
                    iframe.src = "https://www.aliexpress.com/p/order/detail.html?orderId=" + externalOrderId;

                    document.body.appendChild(iframe);

                }


                var matchOrdersCheckInterval = setInterval(function() {

                    chrome.storage.sync.get({
                        stage: !1,
                        matchOrders: [],
                    }, function(params) {

                        console.log("waiting for orders...");

                        if (params.stage && params.stage.action === 'order_fulfillment_update_orders' && params.stage.state === 'active' &&
                            params.matchOrders.length >= ordersCount) {

                            //use >= in the above condition if some reason we get more macthedOrders than expected

                            clearInterval(matchOrdersCheckInterval);

                            console.log("matched orders found:");
                            console.log(params.matchOrders);

                            var matchedOrders = params.matchOrders;

                            chrome.storage.sync.set({
                                stage: !1,
                                matchOrders: [],
                            }, function() {

                                sendUpdatedOrdersToApp(matchedOrders);

                            })
                        }

                    });

                }, 400);


            });


        } else {

            sendUpdatedOrdersToApp();
        }




    },

    sendStatus: function(e, f, d) {
        chrome.runtime.sendMessage({
            action: config.actions.CONTENT_ORDER_FULFILLMENT_STATUS_RESPONSE,
            stage: e.stage,
            param: typeof d !== "undefined" ? d : !1
        }, function(e) {
            if (typeof f !== "undefined") f(e);
        })
    },

    getUpdateStateData: function(e) {
        var e = {
            text: "Sync Order (id: " + e.id.join('<br />') + ") with WooCommerce...",
            isBusy: true,
        };
        return e
    },
    getUpdatedStateData: function(e) {
        var t = {};

        return e.success ? (t = {
            text: "Order (id: " + e.external_id.join('<br />') + ") - saved in your WC Order." + "<br/><br/>" + e.msg,
            iconUrl: config.assets.iconImportSuccess,
        }) : (t = {
            text: "Order (id: " + e.external_id.join('<br />') + ") Syncing Failed. Please copy it manually to your WC order." + "<br/><br/>" + e.msg,
            iconUrl: config.assets.iconImportError,
        }), t

    },
    clear: function(f) {
        chrome.storage.sync.set({
            aliOrderIDs: !1,
            orderId: !1,
            orderItems: !1,
            orderNumber: !1,
            shopName: !1,
            currentProduct: 0,
            orderData: !1,
            defaultShipping: "",
            note: !1,
            cartLoaded: !1,
            formFilled: 0,
            countrySet: 0,
            createdAt: !1,
        }, function() {
            if (typeof f !== "undefined") f();
        });
    },
    isFreshStorage: function(storage) {
        let o = storage;
        return (!o.createdAt || (o.createdAt && (Date.now() - o.createdAt <= 720 * 1000))); /* 12 min */
    },
}

const MAWorker = {
    updateRequestRules : async function(origin){
        const rules = [{
            id: 1,
            action: {
                type: 'modifyHeaders',
                responseHeaders: [
                    {
                        header: 'Access-Control-Allow-Origin',
                        operation: 'set',
                        value: origin
                    },
                    {
                        header: 'Access-Control-Allow-Credentials',
                        operation: 'set',
                        value: 'true'
                    }
                ],
            },
            condition: {
                urlFilter: 'm.aliexpress.com/api/',
                resourceTypes: ['xmlhttprequest'],
            },
        }];
        await chrome.declarativeNetRequest.updateDynamicRules({
            removeRuleIds: rules.map(r => r.id),
            addRules: rules,
        });
    }
}

const MAFunc = {

    waitForElm: function (selector) {
        return new Promise(resolve => {
            if (document.querySelector(selector)) {
                return resolve(document.querySelector(selector));
            }

            const observer = new MutationObserver(mutations => {
                if (document.querySelector(selector)) {
                    observer.disconnect();
                    resolve(document.querySelector(selector));
                }
            });

            // If you get "parameter 1 is not of type 'Node'" error, see https://stackoverflow.com/a/77855838/492336
            observer.observe(document.body, {
                childList: true,
                subtree: true
            });
        });
    },

    isAliExpressRuDomain: function () {
        let e = window.location.href;
        let result = e.indexOf(".ru") > -1 ? true : false;
        return result;
    },

    serialize: function (obj, prefix) {
        var str = [],
            p;
        for (p in obj) {
            if (obj.hasOwnProperty(p)) {
                var k = prefix ? prefix + "[" + p + "]" : p,
                    v = obj[p];
                str.push((v !== null && typeof v === "object") ?
                    serialize(v, k) :
                    encodeURIComponent(k) + "=" + encodeURIComponent(v));
            }
        }
        return str.join("&");
    },

    goToPluginTab: function (f) {

        chrome.runtime.sendMessage({
            action: config.actions.CONTENT_SWITCH_TO_PLUGIN_TAB_REQUEST
        }, function (e) {
            if (typeof f !== "undefined") f(e);
        })
    },


    parseAvailableProductShopcartIds: function () {
        var e = !0,
            t = !1,
            r = void 0;
        try {
            for (var n, o = document.head.querySelectorAll("script")[Symbol.iterator](); !(e = (n = o.next())
                .done); e = !0) {
                var i = n.value,
                    a = i.innerText.match(/availableProductShopcartIds":\s"([\d,]+)",/);
                if (null !== a) return a[1]
            }
        } catch (e) {
            t = !0, r = e
        } finally {
            try {
                !e && o.return && o.return()
            } finally {
                if (t) throw r
            }
        }
        return null
    },

    testRequest: function () {
        chrome.runtime.sendMessage({
            action: config.actions.CONTENT_TEST_REQUEST
        }, function (e) {

        })
    },

    getSetAliAddressStateData: function (e) {
        var t = {},
            s = "It can't fill the address fields. <br/><br/>";

        for (var h in e.messages) {
            s = s + e.messages[h] + "<br/>";
        }

        s = s + "<br/>Please fix shipping address in your orders and try to place again."

        return e.success ? (t = {
            text: e.status,
            iconUrl: config.assets.iconImportSuccess,
        }) : (t = {
            text: s,
            iconUrl: config.assets.iconImportError,
        }), t
    },

    setAliAddress: function (d) {

        return new Promise(function (n, l) {

            setTimeout(function () {

                var t = MAFunc.parseCsrfToken(),
                    i = MAFunc.parseAvailableProductShopcartIds();

                if (t !== null && i !== null) {
                    chrome.runtime.sendMessage({
                        action: config.actions.CONTENT_SET_ADDRESS,
                        isRuDomain: MAFunc.isAliExpressRuDomain(),
                        token: t,
                        ids: i,
                        data: d
                    }, function (e) {

                        if (e.success !== !0 && e.messages && e.messages.length > 0) {
                            console.log('Ali2Woo Chrome extension can`t set the address for this order using the fast methods. Below the errors:');
                            console.log(e);
                            messagePanel.render({
                                iconClose: chrome.runtime.getURL(config.assets.iconClose),
                                svgLogo: chrome.runtime.getURL(config.assets.svgLogo),
                                state: MAFunc.getSetAliAddressStateData(e)
                            });
                        }

                        return n(e);

                    });
                } else {
                    if (t == null) {
                        return l("Ali2Woo Chrome extension can`t get the aliexpress api token");
                    }
                    if (i == null) {
                        return l("Ali2Woo Chrome extension can`t get cart product ids");
                    }
                }
            }, 1300);
        });
    },

    checkPageNotFound: function (u) {
        return new Promise(function (n) {
            chrome.runtime.sendMessage({
                action: config.actions.CONTENT_TEST_PAGE_NOT_FOUND,
                url: u
            }, function (e) {
                return n(e);
            });
        });
    },

    parseCsrfToken: function () {
        var e = !0,
            t = !1,
            r = void 0;
        try {
            for (var n, o = document.body.querySelectorAll("script")[Symbol.iterator](); !(e = (n = o.next())
                .done); e = !0) {
                var i = n.value,
                    a = i.innerText.match(/\._csrf_token_\s=\s'(\w+)';/);
                if (null !== a) return a[1]
            }
        } catch (e) {
            t = !0, r = e
        } finally {
            try {
                !e && o.return && o.return()
            } finally {
                if (t) throw r
            }
        }
        return null
    },

    setPopup: function (p) {
        chrome.runtime.sendMessage({
            action: config.actions.CONTENT_SET_POPUP,
            popup: p
        }, function (e) {

        });
    },

    getOriginFromUrl(url, includeProtocol = true) {
        let domain = new URL(url);
        return domain.origin
        /* if (includeProtocol) {
             return domain.protocol + domain.hostname;
         }*/

        //return domain.origin
    },

    isAliPage: function (url) {
        const matches = [
            "http://*.aliexpress.com/*",
            "https://*.aliexpress.com/*",
            "https://*.alibaba.com/*",
            "https://aliexpress.ru/*",
            "http://aliexpress.ru/*",
            "https://*.aliexpress.ru/*",
            "http://*.aliexpress.ru/*",
            "https://*.aliexpress.us/*",
            "http://*.aliexpress.us/*"
        ];
        return MAFunc.isPageMathing(url, matches);
    },

    isAliCatPage: function (url) {
        const matches = [
            "https://*.aliexpress.com/ssr/*/*",
            "https://*.aliexpress.com/af/*",
            "https://*.aliexpress.com/w/*",
            "https://*.aliexpress.com/category/*",
            "https://*.aliexpress.com/store/*",
            "https://*.aliexpress.com/wholesale*",
            "https://*.aliexpress.com/premium*",
            "https://*.aliexpress.com/p/calp-plus/index.html*",
            "https://sale.aliexpress.com/*",

            "https://aliexpress.ru/af/*",
            "https://aliexpress.ru/w/*",
            "https://aliexpress.ru/category/*",
            "https://aliexpress.ru/store/*",
            "https://aliexpress.ru/wholesale*",
            "https://aliexpress.ru/premium*",
            "https://aliexpress.ru/p/calp-plus/index.html*",
            "https://sale.aliexpress.ru/*",

            "https://*.aliexpress.us/af/*",
            "https://*.aliexpress.us/w/*",
            "https://*.aliexpress.us/category/*",
            "https://*.aliexpress.us/store/*",
            "https://*.aliexpress.us/wholesale*",
            "https://*.aliexpress.us/premium*",
            "https://aliexpress.us/p/calp-plus/index.html*",
            "https://sale.aliexpress.us/*",
        ];

        return MAFunc.isPageMathing(url, matches);
    },

    isPageMathing: function (url, matches) {
        function urlGlobToRegex(matchPattern) {
            return matchPattern
                .replace(/[.]/g, '\\.')
                .replace(/[?]/, '.')
                .replace(/^[*]:/, 'https?')
                .replace(/^(https[?]?:[/][/])[*]/, '$1[^/:]+')
                .replace(/^(http[?]?:[/][/])[*]/, '$1[^/:]+')
                .replace(/[/][*]/, '/?.+')
                .replace(/[*]/g, '.+')
                .replace(/[/]/g, '\\/');
        }


        const matchesRegex = new RegExp('^(' + matches.map(urlGlobToRegex).join('|') + ')$');

        return matchesRegex.test(url);
    },
    //todo: remove this
    injectMainJs: async function (tabId) {

        'use strict';

        async function wasPreviouslyLoaded(tabId, js) {

            async function p(fn, ...args) {
                return new Promise((resolve, reject) => {
                    fn(...args, result => {
                        if (chrome.runtime.lastError) {
                            //  reject(chrome.runtime.lastError);
                            resolve(false);
                        } else {
                            result = result || {};
                            if (result.status != 'yes') {
                                resolve(false);
                            } else {
                                resolve(true);
                            }

                        }
                    });
                });
            }

            const result = await p(chrome.tabs.sendMessage, tabId, {
                "name": config.actions.CHECK_MAIN_CONTENT_IS_INCLUDED
            });
            return result;

        }

        async function isOriginPermitted(url) {
            return p(chrome.permissions.contains, {
                origins: [new URL(url).origin + '/*']
            });
        }

        function urlGlobToRegex(matchPattern) {
            return matchPattern
                .replace(/[.]/g, '\\.')
                .replace(/[?]/, '.')
                .replace(/^[*]:/, 'https?')
                .replace(/^(https[?]?:[/][/])[*]/, '$1[^/:]+')
                .replace(/^(http[?]?:[/][/])[*]/, '$1[^/:]+')
                .replace(/[/][*]/, '/?.+')
                .replace(/[*]/g, '.+')
                .replace(/[/]/g, '\\/');
        }

        async function p(fn, ...args) {
            return new Promise((resolve, reject) => {
                fn(...args, result => {
                    if (chrome.runtime.lastError) {
                        reject(chrome.runtime.lastError);
                    } else {
                        resolve(result);
                    }
                });
            });
        }

        const js = [{file: 'assets/js/libs/jquery.js'}, {file: 'assets/js/scripts/common.js'}, {file: 'scripts/content/content_ma_api.js'}];

        const loadCheck = `document[${JSON.stringify(JSON.stringify({js}))}]`;
        const loadCheckParam = JSON.stringify(JSON.stringify({js}));

        const matchAboutBlank = false;

        const allFrames = false;

        const runAt = "document_end";

        const matches = ["http://*.aliexpress.com/*", "https://*.aliexpress.com/*", "https://*.alibaba.com/*"];

        const {url} = await p(chrome.tabs.get, tabId);

        const matchesRegex = new RegExp('^(' + matches.map(urlGlobToRegex).join('|') + ')$');

        if (!url ||
            matchesRegex.test(url) ||
            !await isOriginPermitted(url)
        ) {
            return false;
        }

        if (await wasPreviouslyLoaded(tabId, loadCheck)) {
            return true;
        }


        let files = js.map(file => file.file);

        chrome.scripting.executeScript({
            target: {tabId: tabId, allFrames: allFrames},
            files: files,
        });

        const markScriptLoaded = (param) => {
            //document[ param ] = true;
            // alert( test );
        }

        chrome.scripting.executeScript({
            target: {tabId: tabId, allFrames: allFrames},
            injectImmediately: true,
            function: markScriptLoaded,
            args: [loadCheckParam]
        });

        return true;

    },

    isScriptAlreadyIncluded: function (sub_src) {
        var scripts = document.getElementsByTagName("script");
        for (var i = 0; i < scripts.length; i++) {
            t = scripts[i].getAttribute('src');
            if (t && t.includes(sub_src)) return true;
        }
        return false;
    },

    cleanAliUrl: function (url) {
        if (url.startsWith("//")) {
            url = "https:" + url;
        }

        let urlObj = new URL(url);
        urlObj.search = '';

        return urlObj.toString();
    }

};

var MAHtml = {
    prependHtml: function(e, t, r) {
        if (t && r) {
            var o = e.createElement("template");
            //o.innerHTML = r, n ? t.append(o.content.firstChild) : t.prepend(o.content.firstChild)
            o.innerHTML = r, t.prepend(o.content.firstChild)
        }
    },
    appendHtml: function(e, t, r) {
        if (t && r) {
            var o = e.createElement("template");
            o.innerHTML = r;
            t.append(o.content.firstChild)
        }
    },
    scrollPageTop: function (timeout, callback)
    {
        setTimeout(function (){
            $( "html, body" ).animate( { scrollTop: 0 }, 1500, function (){
                if (typeof callback !== "undefined") callback();       
            });
        }, timeout);
    },
    scrollPageBottom: function (timeout, callback)
    {
        setTimeout( function ()
        {
            $( "html, body" ).animate( { scrollTop: $( document ).height() }, 1500, function (){
                if (typeof callback !== "undefined") callback();
            });
        }, timeout);
    },
    scrollPageTopBottom: function (timeout, callback)
    {
        MAHtml.scrollPageTop(timeout, function (){
            MAHtml.scrollPageBottom(timeout, function (){
                if (typeof callback !== "undefined") callback();    
            });   
        });
    },

}

var MAMessages = {


    productImportedIcon: function() {
        var s = chrome.runtime.getURL(config.assets.iconImported);
        return '<a href="#" class="ma-imported-product" title="This product is already added into your store"><img src="' + s + '" alt=""></a>'
    },

    categoryProductImportedIcon: function() {
        var s = chrome.runtime.getURL(config.assets.iconImported);
        return '<a href="#" class="ma-imported-category-product" title="This product is already added into your store"><img src="' + s + '" alt=""></a>'
    },

    productPushButton: function() {
        var btnFloating = chrome.runtime.getURL(config.assets.btnFloating);
        return '<a href="#" id="ma-push-button" class="ma-btn-push-product" title="Add this product to the Import List"><img src="' + btnFloating + '" alt=""></a>'
    },

    categoryPushButton: function() {
        var btnFloating = chrome.runtime.getURL(config.assets.btnFloating);
        return '<a href="#" class="ma-btn-push-category-product" title="Add this product to the Import List"><img src="' + btnFloating + '" alt=""></a>'
    },
    statusBar: function() { return '<div id="ma-status-bar-container"></div>' }
}

var MAStatusBar = {
    add: function(e) {
        var logoSM = chrome.runtime.getURL(config.assets.logoSM);
        jQuery("#ma-status-bar-container").append('<div class="status-bar" style="background: url(' + logoSM + ') no-repeat 16px center #fff;">' + e + "</div>")
    },
    remove: function() {
        jQuery("#ma-status-bar-container").html("")
    }
}

var MAPromises = {
    clickBtn: function(e) {
        return new Promise(function(t, n) {
            var r = setInterval(function() {

                var n = e;
                if (typeof e !== "object")
                    n = document.querySelector(e);

                n && (clearInterval(r), n.click(), t(n));

            }, 400);
            setTimeout(function() {

                clearInterval(r), n(!1);
            }, 5000)
        })
    },

    waitEl: function(e, c) {
        return new Promise(function(t, n) {
            var r = setInterval(function() {

                var n = e;
                if (typeof e !== "object")
                    n = document.querySelector(e);

                if (typeof c !== 'undefined') {
                    if (c == ':visible') {
                        n && n.is(":visible") && (clearInterval(r), t(n));
                    } else {
                        n && n.classList.contains(c) && (clearInterval(r), t(n));
                    }

                } else {
                    n && (clearInterval(r), t(n));
                }



            }, 400);
            setTimeout(function() {

                clearInterval(r), n(!1);
            }, 20000)
        })
    }

}


class HttpClient {
    constructor(options = {}) {
      this._baseURL = options.baseURL || "";
      this._headers = options.headers || {};
    }
    setHeader(key, value) {
        this._headers[key] = value;
        return this;
    }
    async _fetchJSON(endpoint, options = {}) {
        const res = await fetch(this._baseURL + endpoint, {
            ...options,
            headers: this._headers
        });

        if ( !res.ok ) {
            let errorResult = await res.json();
            if (errorResult.error) {
                throw new Error(errorResult.error);
            } else {
                throw new Error(res.statusText);
            }
        }
      
       return res.json();
    }
    get(endpoint, options = {}) {
        return this._fetchJSON(
          endpoint, 
          { 
            ...options, 
            method: 'GET' 
          }
        )
      }
      
    post(endpoint, body= null, options = {}) {
        if (!body) {
            return this._fetchJSON(
                endpoint,
                {
                    ...options,
                    body: null,
                    method: 'POST'
                }
            );
        }

        return this._fetchJSON(
          endpoint,
          {
            ...options,
            body: JSON.stringify(body),
            method: 'POST'
          }
        );
    }

    postForm( endpoint, body, options = {} )
    {

        var form_data = new FormData();

        for ( var key in body )
        {
            if (body.hasOwnProperty(key))
                form_data.append(key, body[key]);
        }
        
        return this._fetchJSON(
            endpoint, 
            {
              ...options, 
              body: form_data, 
              method: 'POST' 
            }
          )    
    }
    

      
    delete(endpoint, options = {}) {
        return this._fetchJSON(
          endpoint, 
          {
            parseResponse: false,
            ...options, 
            method: 'DELETE' 
          }
        )
    }
      
}


class AliExpressAPIClient extends HttpClient
{
    constructor() {
        super();
    }    

    getShippingData(product_id, region = 'US', currency = 'USD') {
        //let price = 0;
        let sellerAdminSeq = '';
        let aliTax = (t) => '';
        const params = new URLSearchParams;
        
        params.append( "productId", product_id );
        params.append( "count", 1 );
        params.append( "country", region );
        /*
        params.append( "provinceCode", "922871650000000000" );
        params.append( "cityCode", "922871655747000000" );
        */
        params.append( "sellerAdminSeq", sellerAdminSeq);
        /*
        params.append( "minPrice", price );
        params.append( "maxPrice", price );
        */
        params.append( "tradeCurrency", currency );
        params.append( "userScene", "PC_DETAIL_SHIPPING_PANEL" );
        params.append( "displayMultipleFreight", true );
        params.append( "ext",
            '{"disCurrency":"'+currency+'","p3":"'+currency+'","p6":"'+aliTax(region)+'"}'
        );

        let endpoint = `${config.urls.v2GetShippingMethods}?${ params.toString()}`;

        return this.get(endpoint);
    }

    setAliexpressCurrencyV1(currency = 'USD') {
        let currencyEndpoint = `https://m.aliexpress.com/api/setting/currency?currency=${currency}`;
        return this.post(currencyEndpoint, null, {credentials: 'include'});
    }

    getShippingDataV1(product_id, region = 'US', currency = 'USD') {
        let shippingEndpoint = config.urls.shippingInfo
            .replace("{1}", product_id)
            .replace("{2}", region)
            .replace("{3}", "1")
            .replace("{4}", currency);

        return this.get(shippingEndpoint, {credentials: 'include'});
    }
}

class ApiClient extends HttpClient { 
    constructor(baseURL, langCode) {
      super({
        baseURL,
        headers: {
          lang: langCode
        }
      });
    }
  
    get_users() {
      return {
        get: () => this.get("/users"),
        delete: (id) => this.delete(`/users/${id}`),
        create: (user) => this.post("/users", user),
        update: (user) => this.put(`/users/${user.id}`, user)
      };
    }
}

/*
class DeclarativeRules
{
    static updateAliExpressFreightRule ()
    {
        return chrome.declarativeNetRequest.updateDynamicRules({
            addRules: [{
                id: 3,
                priority: 1,
                action: {
                    type: "modifyHeaders",
                    responseHeaders: [{
                        header: "Access-Control-Allow-Origin",
                        operation: "set",
                        value: "*"
                    }, ]
                },
                condition: {
                    urlFilter: "aliexpress.com/aeglodetailweb/api/logistics/freight",
                    resourceTypes: ["xmlhttprequest"]
                }
            }, ],
            removeRuleIds: [3]
        })
    }
}
*/
/**
* @class
* @property  {Number} productId
* @property  {Array} freight
*/
class shippingInfoDTO
{
    constructor(product_id, freight = []) {
        this.productId = product_id;
        this.freight = freight;
    }  
}

class DTOFactory
{
    static buildShippingInfoFromAPIResponse(product_id, response)
    {
        let freight = [];
        
        if ( 200 == response.code && response.body.hasOwnProperty( "freightResult" ) )
        {
            freight = response.body.freightResult;
        }
 
        return new shippingInfoDTO( product_id, freight );
    }
    static buildShippingInfoFromAPIResponseV1(product_id, response)
    {
        let freight = [];

        if ( 200 == response.code && response.data.hasOwnProperty( "freightResult" ) )
        {
            freight = response.data.freightResult;
        }

        return new shippingInfoDTO( product_id, freight );
    }
}

class LocalStorage
{
    constructor ()
    {
        throw Error( 'A static class cannot be instantiated.' );
    }

    static async getLocal ( _key )
    {
        let key = _key;

        return new Promise( ( resolve, reject ) =>
        {
            chrome.storage.local.get( key )
                .then( object => resolve( object[ key ] ) )
                .catch( error => reject( console.error( error ) ) );
        } );
    }
    
    static async setLocal ( object )
    {
        for ( let key in object )
        {
            const oldObject = await this.getLocal( key );
            const newObject = { ...oldObject, ...object[ key ] };
            await chrome.storage.local.set( { [ key ]: newObject } );
        }
    }
}

class ShippingCache extends LocalStorage
{
    constructor ()
    {
        super();
    }
    
    static async get ()
    {
        
        let data = Object.create(null);

        try
        {
            data = await this.getLocal( config.data_keys.shipping_info_cache ); 

            if ( typeof data === "undefined" )
            {
                data = Object.create(null);
            }
        
        } catch(err) { 
            console.log( err.message );  
        }
        finally
        {
            return data;    
        }
    }

    static async getByProductId (product_id, region = 'US', currency = 'USD')
    {
        let cache = await this.get();
        let item_cache_key = this.buildItemCacheKey( product_id, region, currency );

        if ( Object.hasOwn( cache, item_cache_key ) )
        {
            return cache[ item_cache_key ];  
        } else
        {
            return false;
        }
    }

    static checkItemExpire (item)
    {
        let now = Date.now();
        if ( now - item.time < config.contains.freightCacheTime )
        {
            return false
        } else
        {
            return true;
        }
    }

    static buildItemCacheKey (product_id, region = 'US', currency = 'USD')
    {
        return `${ product_id }_${ region }_${ currency }`;  
    }

    /**
     * 
     * @param {shippingInfoDTO} shipping_info_dto 
     * @returns 
     */
    static async set (shipping_info_dto, region = 'US', currency = 'USD')
    {
        let freight = shipping_info_dto.freight;
        let now = Date.now();

        let item_cache_key = this.buildItemCacheKey( shipping_info_dto.productId, region, currency );

        return await this.setLocal( { [config.data_keys.shipping_info_cache] : { [item_cache_key]: {'freight': freight, 'time': now} } } ); 
    }
}

